/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ExtendedSingleInstanceService;
import net.sourceforge.jnlp.services.XServiceManagerStub;

public class ServiceUtil {
    public static BasicService getBasicService() {
        return (BasicService)ServiceUtil.getService("javax.jnlp.BasicService");
    }

    public static ClipboardService getClipboardService() {
        return (ClipboardService)ServiceUtil.getService("javax.jnlp.ClipboardService");
    }

    public static DownloadService getDownloadService() {
        return (DownloadService)ServiceUtil.getService("javax.jnlp.DownloadService");
    }

    public static ExtensionInstallerService getExtensionInstallerService() {
        return (ExtensionInstallerService)ServiceUtil.getService("javax.jnlp.ExtensionInstallerService");
    }

    public static FileOpenService getFileOpenService() {
        return (FileOpenService)ServiceUtil.getService("javax.jnlp.FileOpenService");
    }

    public static FileSaveService getFileSaveService() {
        return (FileSaveService)ServiceUtil.getService("javax.jnlp.FileSaveService");
    }

    public static PersistenceService getPersistenceService() {
        return (PersistenceService)ServiceUtil.getService("javax.jnlp.PersistenceService");
    }

    public static PrintService getPrintService() {
        return (PrintService)ServiceUtil.getService("javax.jnlp.PrintService");
    }

    public static SingleInstanceService getSingleInstanceService() {
        return (SingleInstanceService)ServiceUtil.getService("javax.jnlp.SingleInstanceService");
    }

    public static void checkExistingSingleInstance(JNLPFile jnlpFile) {
        ExtendedSingleInstanceService esis = (ExtendedSingleInstanceService)ServiceUtil.getSingleInstanceService();
        esis.checkSingleInstanceRunning(jnlpFile);
    }

    private static Object getService(String name) {
        try {
            return ServiceManager.lookup(name);
        }
        catch (UnavailableServiceException ex) {
            return null;
        }
    }

    static Object createPrivilegedProxy(Class<?> iface, Object receiver) {
        return Proxy.newProxyInstance(XServiceManagerStub.class.getClassLoader(), new Class[]{iface}, (InvocationHandler)new PrivilegedHandler(receiver));
    }

    public static boolean checkAccess(SecurityDialogs.AccessType type, Object ... extras) {
        return ServiceUtil.checkAccess(null, type, extras);
    }

    public static boolean checkAccess(ApplicationInstance app, SecurityDialogs.AccessType type, Object ... extras) {
        boolean trusted = ServiceUtil.isSigned(app);
        if (!trusted) {
            if (!ServiceUtil.shouldPromptUser()) {
                return false;
            }
            if (app == null) {
                app = JNLPRuntime.getApplication();
            }
            final SecurityDialogs.AccessType tmpType = type;
            final Object[] tmpExtras = extras;
            final ApplicationInstance tmpApp = app;
            Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean b = SecurityDialogs.showAccessWarningDialog(tmpType, tmpApp.getJNLPFile(), tmpExtras);
                    return b;
                }
            });
            return b;
        }
        return true;
    }

    private static boolean shouldPromptUser() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.sandbox.jnlp.enhanced"));
            }
        });
    }

    public static boolean isSigned(ApplicationInstance app) {
        if (app == null) {
            app = JNLPRuntime.getApplication();
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            Class<?> c = null;
            try {
                c = Class.forName(stack[i].getClassName());
            }
            catch (Exception e1) {
                try {
                    c = Class.forName(stack[i].getClassName(), false, app.getClassLoader());
                }
                catch (Exception e2) {
                    System.err.println(e2.getMessage());
                }
            }
            if (c != null && (c.getProtectionDomain().getCodeSource() == null || c.getProtectionDomain().getCodeSource().getCodeSigners() != null)) continue;
            return false;
        }
        return true;
    }

    private static class PrivilegedHandler
    implements InvocationHandler {
        private final Object receiver;

        PrivilegedHandler(Object receiver) {
            this.receiver = receiver;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (JNLPRuntime.isDebug()) {
                System.err.println("call privileged method: " + method.getName());
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        System.err.println("           arg: " + args[i]);
                    }
                }
            }
            PrivilegedExceptionAction<Object> invoker = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(PrivilegedHandler.this.receiver, args);
                }
            };
            try {
                Object result = AccessController.doPrivileged(invoker);
                if (JNLPRuntime.isDebug()) {
                    System.err.println("        result: " + result);
                }
                return result;
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof InvocationTargetException) {
                    throw e.getCause().getCause();
                }
                throw e.getCause();
            }
        }
    }
}

