/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.runtime.Translator;

public class ExtendedAppletSecurityHelp
extends JDialog
implements HyperlinkListener {
    private JButton homeAndDialogueButton;
    private JButton homeButton;
    private JButton closeButton;
    private JEditorPane mainHtmlPane;
    private JPanel mainButtonsPanel;
    private JPanel navigationPanel;
    private JPanel closePanel;
    private JPanel mainPanel;
    private JScrollPane scrollPane;
    private JSeparator niceSeparator;

    public ExtendedAppletSecurityHelp(Frame parent, boolean modal, String reference) {
        this(parent, modal);
        this.mainHtmlPane.scrollToReference(reference);
    }

    public ExtendedAppletSecurityHelp(Frame parent, boolean modal) {
        super(parent, modal);
        Dimension d = new Dimension(600, 400);
        this.setPreferredSize(d);
        this.setSize(d);
        this.initComponents();
        this.mainHtmlPane.setText(Translator.R("APPEXTSEChelp"));
        this.mainHtmlPane.addHyperlinkListener(this);
        this.mainHtmlPane.setCaretPosition(1);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                if (event.getURL() == null) {
                    String s = event.getDescription().replace("#", "");
                    this.mainHtmlPane.scrollToReference(s);
                } else {
                    this.mainHtmlPane.setPage(event.getURL());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.mainHtmlPane = new JEditorPane();
        this.mainPanel = new JPanel();
        this.niceSeparator = new JSeparator();
        this.mainButtonsPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.homeButton = new JButton();
        this.homeAndDialogueButton = new JButton();
        this.closePanel = new JPanel();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.mainHtmlPane.setContentType("text/html");
        this.mainHtmlPane.setEditable(false);
        this.scrollPane.setViewportView(this.mainHtmlPane);
        this.getContentPane().add(this.scrollPane);
        GroupLayout mainLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainLayout);
        mainLayout.setHorizontalGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 485, Short.MAX_VALUE).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainLayout.createSequentialGroup().addGap(0, 217, Short.MAX_VALUE).addComponent(this.niceSeparator, -2, 50, -2).addGap(0, 218, Short.MAX_VALUE))));
        mainLayout.setVerticalGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.niceSeparator, -2, 10, -2).addGap(0, 0, Short.MAX_VALUE))));
        this.getContentPane().add(this.mainPanel);
        this.mainButtonsPanel.setLayout(new BoxLayout(this.mainButtonsPanel, 2));
        this.navigationPanel.setLayout(new BoxLayout(this.navigationPanel, 2));
        this.homeButton.setText(Translator.R("SPLASHHome"));
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtendedAppletSecurityHelp.this.goToIntroSection(evt);
            }
        });
        this.navigationPanel.add(this.homeButton);
        this.homeAndDialogueButton.setText(Translator.R("APPEXTSEChelpHomeDialogue"));
        this.homeAndDialogueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtendedAppletSecurityHelp.this.goToDialogueSection(evt);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtendedAppletSecurityHelp.this.dispose();
            }
        });
        this.navigationPanel.add(this.homeAndDialogueButton);
        this.mainButtonsPanel.add(this.navigationPanel);
        this.closeButton.setText(Translator.R("ButClose"));
        this.closePanel.add(this.closeButton);
        this.mainButtonsPanel.add(this.closePanel);
        this.getContentPane().add(this.mainButtonsPanel);
        this.pack();
    }

    private void goToIntroSection(ActionEvent evt) {
        this.mainHtmlPane.setText(Translator.R("APPEXTSEChelp"));
        this.mainHtmlPane.setCaretPosition(1);
    }

    private void goToDialogueSection(ActionEvent evt) {
        this.mainHtmlPane.setText(Translator.R("APPEXTSEChelp"));
        this.mainHtmlPane.scrollToReference("dialogue");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtendedAppletSecurityHelp dialog = new ExtendedAppletSecurityHelp(null, false);
                dialog.setVisible(true);
            }
        });
    }
}

