/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.CachePane;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;

public class CacheViewer
extends JDialog {
    private boolean initialized = false;
    private static final String dialogTitle = Translator.R("CVCPDialogTitle");
    private DeploymentConfiguration config;
    CachePane topPanel;

    public CacheViewer(DeploymentConfiguration config) {
        super((Frame)null, dialogTitle, true);
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.config = config;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.topPanel = new CachePane(this, this.config);
        contentPane.add((Component)this.topPanel, c);
        this.pack();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    CacheViewer.this.topPanel.focusOnDefaultButton();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowFocusListener(adapter);
        this.initialized = true;
    }

    public static void showCacheDialog(DeploymentConfiguration config) {
        CacheViewer psd = new CacheViewer(config);
        psd.setResizable(true);
        psd.centerDialog();
        psd.setVisible(true);
        psd.dispose();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void centerDialog() {
        ScreenFinder.centerWindowsToCurrentScreen(this);
    }
}

