#!/bin/sh
echo 'name: text
version: 0.11.3.1
id: text-0.11.3.1-bda2125c8335eaa4aca16bb46c88465a

license: BSD3
copyright: 2009-2011 Bryan O'\''Sullivan, 2008-2009 Tom Harper
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability:
homepage: https://github.com/bos/text
package-url:
synopsis: An efficient packed Unicode text type.
description:  
             .
             An efficient packed, immutable Unicode text type (both strict and
             lazy), with a powerful loop fusion optimization framework.
             .
             The '\''Text'\'' type represents Unicode character strings, in a time and
             space-efficient manner. This package provides text processing
             capabilities that are optimized for performance critical use, both
             in terms of large data quantities and high speed.
             .
             The '\''Text'\'' type provides character-encoding, type-safe case
             conversion via whole-string case conversion functions. It also
             provides a range of functions for converting '\''Text'\'' values to and from
             '\''ByteStrings'\'', using several standard encodings.
             .
             Efficient locale-sensitive support for text IO is also supported.
             .
             These modules are intended to be imported qualified, to avoid name
             clashes with Prelude functions, e.g.
             .
             > import qualified Data.Text as T
             .
             To use an extended and very rich family of functions for working
             with Unicode text (including normalization, regular expressions,
             non-standard encodings, text breaking, and locales), see
             the @text-icu@ package:
             <http://hackage.haskell.org/package/text-icu>
             .
             &#8212;&#8212; RELEASE NOTES &#8212;&#8212;
             .
             Changes in 0.11.2.0:
             .
             * String literals are now converted directly from the format in
             which GHC stores them into '\''Text'\'', without an intermediate
             transformation through '\''String'\'', and without inlining of
             conversion code at each site where a string literal is declared.
             .
category: Data, Text
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-text
exposed: True
exposed-modules: Data.Text Data.Text.Array Data.Text.Encoding
                 Data.Text.Encoding.Error Data.Text.Foreign Data.Text.IO
                 Data.Text.Internal Data.Text.Lazy Data.Text.Lazy.Builder
                 Data.Text.Lazy.Builder.Int Data.Text.Lazy.Builder.RealFloat
                 Data.Text.Lazy.Encoding Data.Text.Lazy.IO Data.Text.Lazy.Internal
                 Data.Text.Lazy.Read Data.Text.Read Data.Text.Unsafe
hidden-modules: Data.Text.Encoding.Fusion
                Data.Text.Encoding.Fusion.Common Data.Text.Encoding.Utf16
                Data.Text.Encoding.Utf32 Data.Text.Encoding.Utf8 Data.Text.Fusion
                Data.Text.Fusion.CaseMapping Data.Text.Fusion.Common
                Data.Text.Fusion.Internal Data.Text.Fusion.Size
                Data.Text.IO.Internal Data.Text.Lazy.Builder.Functions
                Data.Text.Lazy.Builder.Int.Digits Data.Text.Lazy.Builder.Internal
                Data.Text.Lazy.Builder.RealFloat.Functions
                Data.Text.Lazy.Encoding.Fusion Data.Text.Lazy.Fusion
                Data.Text.Lazy.Search Data.Text.Private Data.Text.Search
                Data.Text.Unsafe.Base Data.Text.UnsafeChar Data.Text.UnsafeShift
                Data.Text.Util
trusted: False
import-dirs: /usr/local/lib/ghc/text-0.11.3.1
library-dirs: /usr/local/lib/ghc/text-0.11.3.1
hs-libraries: HStext-0.11.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         deepseq-1.3.0.1-aa1be128186a233c7290faf88620ffe5
         ghc-prim-0.3.0.0-00db43fcd2f6e2a73243bdb496b765e0
         integer-gmp-0.5.0.0-4093e6ff1e8ebdba04ec892df9ac108f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-text-0.11.3.1/html/text.haddock
haddock-html: /usr/local/share/doc/hs-text-0.11.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
