#!/bin/sh
echo 'name: test-framework
version: 0.6
id: test-framework-0.6-5f7d2a97543a3d038987924df75ff1df

license: BSD3
copyright:
maintainer: Max Bolingbroke <batterseapower@hotmail.com>
stability:
homepage: http://batterseapower.github.com/test-framework/
package-url:
synopsis: Framework for running and organising tests, with HUnit and QuickCheck support
description: Allows tests such as QuickCheck properties and HUnit test cases to be assembled into test groups, run in
             parallel (but reported in deterministic order, to aid diff interpretation) and filtered and controlled by
             command line options. All of this comes with colored test output, progress reporting and test statistics output.
category: Testing
author: Max Bolingbroke <batterseapower@hotmail.com>
pkgpath: devel/hs-test-framework
exposed: True
exposed-modules: Test.Framework Test.Framework.Options
                 Test.Framework.Providers.API Test.Framework.Runners.Console
                 Test.Framework.Runners.Options Test.Framework.Seed
hidden-modules: Test.Framework.Core Test.Framework.Improving
                Test.Framework.Runners.Console.Colors
                Test.Framework.Runners.Console.ProgressBar
                Test.Framework.Runners.Console.Run
                Test.Framework.Runners.Console.Statistics
                Test.Framework.Runners.Console.Table
                Test.Framework.Runners.Console.Utilities
                Test.Framework.Runners.Core Test.Framework.Runners.Processors
                Test.Framework.Runners.Statistics
                Test.Framework.Runners.TestPattern
                Test.Framework.Runners.ThreadPool
                Test.Framework.Runners.TimedConsumption
                Test.Framework.Runners.XML.JUnitWriter Test.Framework.Runners.XML
                Test.Framework.Utilities
trusted: False
import-dirs: /usr/local/lib/ghc/test-framework-0.6
library-dirs: /usr/local/lib/ghc/test-framework-0.6
hs-libraries: HStest-framework-0.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ansi-terminal-0.5.5-0bcc070b48372993f61d0303d56a607e
         ansi-wl-pprint-0.6.4-5e022d81dafa55ae21a70676a4755fc1
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         extensible-exceptions-0.1.1.4-255a395b3b026cb94b23754e1c372785
         hostname-1.0-8ffb80aa24d243eeb34c8b8d9760f74b
         old-locale-1.0.0.5-753125cfaf463057d163a0cefde5b58f
         random-1.0.1.1-e63672c93ea60d4fa26e4b5c7949f935
         regex-posix-0.95.2-a34848eaff24ac32325260f99852c6c9
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         xml-1.3.7-22b510b8f0ef329dad717e7f3c57a3f4
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-test-framework-0.6/html/test-framework.haddock
haddock-html: /usr/local/share/doc/hs-test-framework-0.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
