#!/bin/sh
echo 'name: tar
version: 0.4.0.1
id: tar-0.4.0.1-29280e26861b726fd73255cd0750529f

license: BSD3
copyright: 2007 Bjorn Bringert <bjorn@bringert.net>
           2008-2012 Duncan Coutts <duncan@community.haskell.org>
maintainer: Duncan Coutts <duncan@community.haskell.org>
stability:
homepage:
package-url:
synopsis: Reading, writing and manipulating ".tar" archive files.
description: This library is for working with \"@.tar@\" archive files. It
             can read and write a range of common variations of archive
             format including V7, USTAR, POSIX and GNU formats. It provides
             support for packing and unpacking portable archives. This
             makes it suitable for distribution but not backup because
             details like file ownership and exact permissions are not
             preserved.
category: Codec
author: Bjorn Bringert <bjorn@bringert.net>
        Duncan Coutts <duncan@community.haskell.org>
pkgpath: devel/hs-tar
exposed: True
exposed-modules: Codec.Archive.Tar Codec.Archive.Tar.Entry
                 Codec.Archive.Tar.Check
hidden-modules: Codec.Archive.Tar.Types Codec.Archive.Tar.Read
                Codec.Archive.Tar.Write Codec.Archive.Tar.Pack
                Codec.Archive.Tar.Unpack
trusted: False
import-dirs: /usr/local/lib/ghc/tar-0.4.0.1
library-dirs: /usr/local/lib/ghc/tar-0.4.0.1
hs-libraries: HStar-0.4.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         directory-1.2.0.1-8ba84e5bc37997efd0921897c80d9454
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         old-time-1.1.0.1-8b10e3f99ed8611456aa344014a88da2
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tar-0.4.0.1/html/tar.haddock
haddock-html: /usr/local/share/doc/hs-tar-0.4.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
