#!/bin/sh
echo 'name: skein
version: 0.1.0.9
id: skein-0.1.0.9-f2878caf2c6030d2cfc7cf44c68f0cca

license: BSD3
copyright:
maintainer: Felipe Lessa <felipe.lessa@gmail.com>
stability:
homepage: https://github.com/meteficha/skein
package-url:
synopsis: Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.
description: Skein (<http://www.skein-hash.info/>) is a family of fast
             secure cryptographic hash functions designed by Niels
             Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
             Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.
             .
             This package uses bindings to the optimized C implementation
             of Skein.  We provide a high-level interface (see module
             "Crypto.Skein") to some of the Skein use cases.  We also
             provide a low-level interface (see module
             "Crypto.Skein.Internal") should you need to use Skein in a
             different way.
             .
             Currently we have support for Skein as cryptographic hash
             function as Skein as a message authentication code
             (Skein-MAC).  For examples of how to use this package, see
             "Crypto.Skein" module documentation.
category: Cryptography
author: Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
pkgpath: security/hs-skein
exposed: True
exposed-modules: Crypto.Skein Crypto.Skein.Internal
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/skein-0.1.0.9
library-dirs: /usr/local/lib/ghc/skein-0.1.0.9
hs-libraries: HSskein-0.1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes: skein.h
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         cereal-0.3.5.2-a8a790d0768a9248e2a627d1a1b5697e
         crypto-api-0.10.2-c639209e3566fc26d2c36828138592a5
         tagged-0.4.4-cba7ff9b4c1ef8e942d839e784d6f6ae
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-skein-0.1.0.9/html/skein.haddock
haddock-html: /usr/local/share/doc/hs-skein-0.1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
