#!/bin/sh
echo 'name: configurator
version: 0.2.0.0
id: configurator-0.2.0.0-18ddd7e64458e2773cfa2df47465296d

license: BSD3
copyright: Copyright 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: http://github.com/bos/configurator
package-url:
synopsis: Configuration management
description: A configuration management library for programs and daemons.
             .
             Features include:
             .
             * Automatic, dynamic reloading in response to modifications to
             configuration files.
             .
             * A simple, but flexible, configuration language, supporting several
             of the most commonly needed types of data, along with
             interpolation of strings from the configuration or the system
             environment (e.g. @$(HOME)@).
             .
             * Subscription-based notification of changes to configuration
             properties.
             .
             * An @import@ directive allows the configuration of a complex
             application to be split across several smaller files, or common
             configuration data to be shared across several applications.
             .
             For details of the configuration file format, see
             <http://hackage.haskell.org/packages/archive/configurator/latest/doc/html/Data-Configurator.html>.
category: Configuration, Data
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-configurator
exposed: True
exposed-modules: Data.Configurator Data.Configurator.Types
hidden-modules: Data.Configurator.Instances
                Data.Configurator.Parser Data.Configurator.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
library-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
hs-libraries: HSconfigurator-0.2.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.4.0-fb379774679ae5734f1b536d33d902ec
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         directory-1.2.0.1-8ba84e5bc37997efd0921897c80d9454
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         text-0.11.3.1-bda2125c8335eaa4aca16bb46c88465a
         unix-compat-0.4.1.1-7d1074b15de4b90d12292f611c87397a
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-configurator-0.2.0.0/html/configurator.haddock
haddock-html: /usr/local/share/doc/hs-configurator-0.2.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
