#!/bin/sh
echo 'name: attoparsec-enumerator
version: 0.3.1
id: attoparsec-enumerator-0.3.1-9799ee49c7c228079abd7930e5560145

license: MIT
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/attoparsec-enumerator/
package-url:
synopsis: Pass input from an enumerator to an Attoparsec parser.
description: This library allows an Attoparsec parser to receive input incrementally
             from an enumerator. This could be used for parsing large files, or
             implementing binary network protocols.
             .
             > (-# LANGUAGE OverloadedStrings #-)
             >
             > import Control.Applicative
             > import Data.Attoparsec
             > import Data.Attoparsec.Enumerator
             > import Data.Enumerator
             > import Data.Enumerator.Binary (enumHandle)
             > import Data.Enumerator.List
             > import System.IO
             >
             > parser = string "foo" <|> string "bar"
             >
             > main = do
             >     xy <- run_ (enumHandle 1 stdin $$ do
             >         x <- iterParser parser
             >         y <- iterParser parser
             >         return (x, y))
             >     print xy
category: Text, Parsing, Enumerator
author: John Millikin <jmillikin@gmail.com>
pkgpath: textproc/hs-attoparsec-enumerator
exposed: True
exposed-modules: Data.Attoparsec.Enumerator
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3.1
library-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3.1
hs-libraries: HSattoparsec-enumerator-0.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.4.0-fb379774679ae5734f1b536d33d902ec
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         enumerator-0.4.19-af2193302e502a3821d2e5d25db7ea2c
         text-0.11.3.1-bda2125c8335eaa4aca16bb46c88465a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-attoparsec-enumerator-0.3.1/html/attoparsec-enumerator.haddock
haddock-html: /usr/local/share/doc/hs-attoparsec-enumerator-0.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
