#!/bin/sh
echo 'name: ListLike
version: 3.1.7.1
id: ListLike-3.1.7.1-d7b4699a9259d9c60636fc8f8f890d28

license: BSD3
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Lato <jwlato@gmail.com>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
synopsis: Generic support for list-like structures
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.CharString Data.ListLike.FoldableLL Data.ListLike.IO
                 Data.ListLike.Instances Data.ListLike.String Data.ListLike.Utils
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/ListLike-3.1.7.1
library-dirs: /usr/local/lib/ghc/ListLike-3.1.7.1
hs-libraries: HSListLike-3.1.7.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-3.1.7.1/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-3.1.7.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
