#!/bin/sh
echo 'name: HTTP
version: 4000.2.8
id: HTTP-4000.2.8-00a4daf0982fa02db5cff1d3f0d3a0d1

license: BSD3
copyright:
maintainer: Ganesh Sittampalam <http@projects.haskell.org>
stability:
homepage: https://github.com/haskell/HTTP
package-url:
synopsis: A library for client-side HTTP
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      (_, rsp)
             >         <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://www.haskell.org/"
             >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
pkgpath: net/hs-HTTP
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
trusted: False
import-dirs: /usr/local/lib/ghc/HTTP-4000.2.8
library-dirs: /usr/local/lib/ghc/HTTP-4000.2.8
hs-libraries: HSHTTP-4000.2.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         network-2.4.1.2-2168de8ac065aaee79248d6a7e40b6bc
         old-time-1.1.0.1-8b10e3f99ed8611456aa344014a88da2
         parsec-3.1.3-b22b2727b76201c9de9a61961208ca5b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.2.8/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.2.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
