/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class TableView
extends BoxView {
    int[] columnOffsets;
    int[] columnSpans;
    SizeRequirements[] columnRequirements = new SizeRequirements[0];

    public TableView(Element el) {
        super(el, 1);
    }

    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.layoutChanged(1);
    }

    protected TableRow createTableRow(Element el) {
        return new TableRow(el);
    }

    protected TableCell createTableCell(Element el) {
        return new TableCell(el);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory vf) {
    }

    protected void layoutColumns(int targetSpan, int[] offsets, int[] spans, SizeRequirements[] reqs) {
        this.updateColumnRequirements();
        SizeRequirements r = this.calculateMinorAxisRequirements(0, null);
        SizeRequirements.calculateTiledPositions(targetSpan, r, this.columnRequirements, offsets, spans);
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.layoutColumns(targetSpan, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements req) {
        SizeRequirements res = req;
        if (res == null) {
            res = new SizeRequirements();
        } else {
            res.alignment = 0.5f;
            res.maximum = 0;
            res.minimum = 0;
            res.preferred = 0;
        }
        int i = 0;
        while (i < this.columnRequirements.length) {
            res.minimum += this.columnRequirements[i].minimum;
            res.preferred += this.columnRequirements[i].preferred;
            res.maximum += this.columnRequirements[i].maximum;
            ++i;
        }
        return res;
    }

    protected View getViewAtPosition(int pos, Rectangle a) {
        return super.getViewAtPosition(pos, a);
    }

    private void updateColumnRequirements() {
        int rowCount = this.getViewCount();
        int r = 0;
        while (r < rowCount) {
            TableRow row = (TableRow)this.getView(r);
            int columnCount = row.getViewCount();
            int c = 0;
            while (c < columnCount) {
                View cell = row.getView(c);
                SizeRequirements cr = this.columnRequirements[c];
                cr.minimum = Math.max(cr.minimum, (int)cell.getMinimumSpan(0));
                cr.preferred = Math.max(cr.preferred, (int)cell.getPreferredSpan(0));
                cr.maximum = Math.max(cr.maximum, (int)cell.getMaximumSpan(0));
                ++c;
            }
            ++r;
        }
    }

    public class TableCell
    extends BoxView {
        private int row;
        private int column;

        public TableCell(Element el) {
            super(el, 0);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int r, int c) {
            this.row = r;
            this.column = c;
        }

        public int getGridRow() {
            return this.row;
        }

        public int getGridColumn() {
            return this.column;
        }
    }

    public class TableRow
    extends BoxView {
        public TableRow(Element el) {
            super(el, 0);
        }

        public void replace(int offset, int length, View[] views) {
            super.replace(offset, length, views);
            int viewCount = this.getViewCount();
            if (TableView.this.columnRequirements == null || viewCount > TableView.this.columnRequirements.length) {
                TableView.this.columnRequirements = new SizeRequirements[viewCount];
                int i = 0;
                while (i < TableView.this.columnRequirements.length) {
                    TableView.this.columnRequirements[i] = new SizeRequirements();
                    ++i;
                }
            }
            if (TableView.this.columnOffsets == null || TableView.this.columnOffsets.length < viewCount) {
                TableView.this.columnOffsets = new int[viewCount];
            }
            if (TableView.this.columnSpans == null || TableView.this.columnSpans.length < viewCount) {
                TableView.this.columnSpans = new int[viewCount];
            }
            this.layoutChanged(0);
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            assert (offsets.length == TableView.this.columnOffsets.length);
            assert (spans.length == TableView.this.columnSpans.length);
            assert (offsets.length == spans.length);
            int i = 0;
            while (i < offsets.length) {
                offsets[i] = TableView.this.columnOffsets[i];
                spans[i] = TableView.this.columnSpans[i];
                ++i;
            }
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMinorAxis(targetSpan, axis, offsets, spans);
        }

        public int getResizeWeight(int axis) {
            return 0;
        }

        protected View getViewAtPosition(int pos, Rectangle a) {
            return super.getViewAtPosition(pos, a);
        }
    }
}

