/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.PlainSocketImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;

public class Socket {
    static SocketImplFactory factory;
    SocketImpl impl;
    boolean implCreated;
    boolean bound;
    private boolean inputShutdown;
    private boolean outputShutdown;

    public Socket() {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
    }

    protected Socket(SocketImpl impl) throws SocketException {
        this.impl = impl == null ? new PlainSocketImpl() : impl;
    }

    public Socket(String host, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port, null, 0, true);
    }

    public Socket(InetAddress address, int port) throws IOException {
        this(address, port, null, 0, true);
    }

    public Socket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort, true);
    }

    public Socket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(address, port, localAddr, localPort, true);
    }

    public Socket(String host, int port, boolean stream) throws IOException {
        this(InetAddress.getByName(host), port, null, 0, stream);
    }

    public Socket(InetAddress host, int port, boolean stream) throws IOException {
        this(host, port, null, 0, stream);
    }

    private Socket(InetAddress raddr, int rport, InetAddress laddr, int lport, boolean stream) throws IOException {
        this();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(raddr.getHostAddress(), rport);
        }
        InetSocketAddress bindaddr = laddr == null ? null : new InetSocketAddress(laddr, lport);
        this.bind(bindaddr);
        try {
            this.connect(new InetSocketAddress(raddr, rport));
        }
        catch (IOException ioe) {
            this.impl.close();
            throw ioe;
        }
        catch (RuntimeException re) {
            this.impl.close();
            throw re;
        }
    }

    private SocketImpl getImpl() throws SocketException {
        if (!this.implCreated) {
            try {
                this.impl.create(true);
            }
            catch (IOException x) {
                throw (SocketException)new SocketException().initCause(x);
            }
            this.implCreated = true;
        }
        return this.impl;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (bindpoint == null) {
            bindpoint = new InetSocketAddress(InetAddress.ANY_IF, 0);
        }
        if (!(bindpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException();
        }
        InetSocketAddress tmp = (InetSocketAddress)bindpoint;
        try {
            this.getImpl().bind(tmp.getAddress(), tmp.getPort());
            this.bound = true;
        }
        catch (IOException exception) {
            this.close();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.close();
            throw exception;
        }
        catch (Error error) {
            this.close();
            throw error;
        }
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            InetSocketAddress inetAddr = (InetSocketAddress)endpoint;
            sm.checkConnect(inetAddr.getHostName(), inetAddr.getPort());
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((PlainSocketImpl)this.getImpl()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        if (!this.isBound()) {
            this.bind(null);
        }
        this.getImpl().connect(endpoint, timeout);
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        SecurityManager sm;
        if (!this.isBound()) {
            return InetAddress.ANY_IF;
        }
        InetAddress addr = null;
        if (this.impl instanceof PlainSocketImpl) {
            addr = ((PlainSocketImpl)this.impl).getLocalAddress().getAddress();
        }
        if (addr == null) {
            try {
                addr = (InetAddress)this.getImpl().getOption(15);
            }
            catch (SocketException socketException) {
                return null;
            }
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkConnect(addr.getHostName(), this.getLocalPort());
        }
        return addr;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return 0;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            if (this.getImpl() != null) {
                return this.getImpl().getLocalPort();
            }
        }
        catch (SocketException socketException) {}
        return -1;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        InetAddress addr = this.getLocalAddress();
        try {
            return new InetSocketAddress(addr, this.getImpl().getLocalPort());
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return new InetSocketAddress(this.getImpl().getInetAddress(), this.getImpl().getPort());
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!this.isConnected()) {
            throw new IOException("not connected");
        }
        return this.getImpl().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!this.isConnected()) {
            throw new IOException("not connected");
        }
        return this.getImpl().getOutputStream();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(1, on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object on = this.getImpl().getOption(1);
        if (on instanceof Boolean) {
            return (Boolean)on;
        }
        throw new SocketException("Internal Error");
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (on) {
            if (linger < 0) {
                throw new IllegalArgumentException("SO_LINGER must be >= 0");
            }
            if (linger > 65535) {
                linger = 65535;
            }
            this.getImpl().setOption(128, linger);
        } else {
            this.getImpl().setOption(128, -1);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object linger = this.getImpl().getOption(128);
        if (linger instanceof Integer) {
            return (Integer)linger;
        }
        return -1;
    }

    public void sendUrgentData(int data) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().sendUrgentData(data);
    }

    public void setOOBInline(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(4099, on);
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4099);
        if (buf instanceof Boolean) {
            return (Boolean)buf;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.getImpl().setOption(4102, timeout);
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object timeout = this.getImpl().getOption(4102);
        if (timeout instanceof Integer) {
            return (Integer)timeout;
        }
        return 0;
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_SNDBUF value must be > 0");
        }
        this.getImpl().setOption(4097, size);
    }

    public int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4097);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.getImpl().setOption(4098, size);
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4098);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public void setKeepAlive(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(8, on);
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(8);
        if (buf instanceof Boolean) {
            return (Boolean)buf;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.impl.close();
        this.impl = null;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return String.valueOf(super.toString()) + " [addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {}
        return String.valueOf(super.toString()) + " [unconnected]";
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("SocketImplFactory already defined");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        if (fac == null) {
            throw new SocketException("SocketImplFactory cannot be null");
        }
        factory = fac;
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().shutdownInput();
        this.inputShutdown = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().shutdownOutput();
        this.outputShutdown = true;
    }

    public SocketChannel getChannel() {
        return null;
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object reuseaddr = this.getImpl().getOption(4);
        if (!(reuseaddr instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)reuseaddr;
    }

    public void setReuseAddress(boolean reuseAddress) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(4, reuseAddress);
    }

    public int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object obj = this.getImpl().getOption(3);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException();
        }
        this.getImpl().setOption(3, tc);
    }

    public boolean isConnected() {
        if (this.impl == null) {
            return false;
        }
        return this.impl.getInetAddress() != null;
    }

    public boolean isBound() {
        if (this.isClosed()) {
            return false;
        }
        if (this.impl instanceof PlainSocketImpl) {
            InetSocketAddress addr = ((PlainSocketImpl)this.impl).getLocalAddress();
            return addr != null && addr.getAddress() != null;
        }
        return this.bound;
    }

    public boolean isClosed() {
        SocketChannel channel = this.getChannel();
        return this.impl == null || channel != null && !channel.isOpen();
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }
}

