/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.DatagramChannelImpl;
import gnu.java.nio.DatagramChannelSelectionKey;
import gnu.java.nio.SelectionKeyImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import gnu.java.nio.ServerSocketChannelSelectionKey;
import gnu.java.nio.SocketChannelImpl;
import gnu.java.nio.SocketChannelSelectionKey;
import gnu.java.nio.SocketChannelSelectionKeyImpl;
import gnu.java.nio.VMSelector;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorImpl
extends AbstractSelector {
    private Set<SelectionKey> keys;
    private Set<SelectionKey> selected;
    private Object selectThreadMutex = new Object();
    private Thread selectThread;
    private boolean unhandledWakeup;

    public SelectorImpl(SelectorProvider provider) {
        super(provider);
        this.keys = new HashSet<SelectionKey>();
        this.selected = new HashSet<SelectionKey>();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected final void implCloseSelector() throws IOException {
        this.wakeup();
        Set<SelectionKey> set = this.keys;
        // MONITORENTER : set
        Set<SelectionKey> set2 = this.selected;
        // MONITORENTER : set2
        Set<SelectionKey> set3 = this.cancelledKeys();
        // MONITORENTER : set3
        // MONITOREXIT : set3
        // MONITOREXIT : set2
        return;
    }

    @Override
    public final Set<SelectionKey> keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return Collections.unmodifiableSet(this.keys);
    }

    @Override
    public final int selectNow() throws IOException {
        return this.select(1L);
    }

    @Override
    public final int select() throws IOException {
        return this.select(0L);
    }

    private final int[] getFDsAsArray(int ops) {
        int counter = 0;
        for (SelectionKeyImpl selectionKeyImpl : this.keys) {
            if ((selectionKeyImpl.interestOps() & ops) == 0) continue;
            ++counter;
        }
        int[] result = new int[counter];
        counter = 0;
        for (SelectionKeyImpl selectionKeyImpl : this.keys) {
            if ((selectionKeyImpl.interestOps() & ops) == 0) continue;
            result[counter] = selectionKeyImpl.getNativeFD();
            ++counter;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int select(long timeout) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        Set<SelectionKey> set = this.keys;
        synchronized (set) {
            Set<SelectionKey> set2 = this.selected;
            synchronized (set2) {
                this.deregisterCancelledKeys();
                int[] read = this.getFDsAsArray(17);
                int[] write = this.getFDsAsArray(12);
                int[] except = new int[]{};
                Object object = this.selectThreadMutex;
                synchronized (object) {
                    if (this.unhandledWakeup) {
                        this.unhandledWakeup = false;
                        return 0;
                    }
                    this.selectThread = Thread.currentThread();
                }
                int result = 0;
                try {
                    this.begin();
                    result = VMSelector.select(read, write, except, timeout);
                }
                finally {
                    this.end();
                }
                Object object2 = this.selectThreadMutex;
                synchronized (object2) {
                    if (this.unhandledWakeup) {
                        this.unhandledWakeup = false;
                        Thread.interrupted();
                    }
                    this.selectThread = null;
                }
                Iterator<SelectionKey> it = this.keys.iterator();
                while (it.hasNext()) {
                    int ops = 0;
                    SelectionKeyImpl key = (SelectionKeyImpl)it.next();
                    if (this.selected.contains(key)) {
                        ops = key.readyOps();
                    }
                    int i = 0;
                    while (i < read.length) {
                        if (key.getNativeFD() == read[i]) {
                            ops = key.channel() instanceof ServerSocketChannelImpl ? (ops |= 0x10) : (ops |= 1);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < write.length) {
                        if (key.getNativeFD() == write[i]) {
                            ops = key.channel() instanceof SocketChannel ? (((SocketChannel)key.channel()).isConnected() ? (ops |= 4) : (ops |= 8)) : (ops |= 4);
                        }
                        ++i;
                    }
                    if (!this.selected.contains(key)) {
                        this.selected.add(key);
                    }
                    key.readyOps(key.interestOps() & ops);
                }
                this.deregisterCancelledKeys();
                return result;
            }
        }
    }

    @Override
    public final Set<SelectionKey> selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Selector wakeup() {
        Object object = this.selectThreadMutex;
        synchronized (object) {
            this.unhandledWakeup = true;
            if (this.selectThread != null) {
                this.selectThread.interrupt();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deregisterCancelledKeys() {
        Set<SelectionKey> ckeys;
        Set<SelectionKey> set = ckeys = this.cancelledKeys();
        synchronized (set) {
            Iterator<SelectionKey> it = ckeys.iterator();
            while (it.hasNext()) {
                this.keys.remove((SelectionKeyImpl)it.next());
                it.remove();
            }
        }
    }

    protected SelectionKey register(SelectableChannel ch, int ops, Object att) {
        return this.register((AbstractSelectableChannel)ch, ops, att);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        SelectionKeyImpl result;
        if (ch instanceof SocketChannelImpl) {
            result = new SocketChannelSelectionKey(ch, this);
        } else if (ch instanceof DatagramChannelImpl) {
            result = new DatagramChannelSelectionKey(ch, this);
        } else if (ch instanceof ServerSocketChannelImpl) {
            result = new ServerSocketChannelSelectionKey(ch, this);
        } else if (ch instanceof SocketChannelImpl) {
            result = new SocketChannelSelectionKeyImpl((SocketChannelImpl)ch, this);
        } else {
            throw new InternalError("No known channel type");
        }
        Set<SelectionKey> set = this.keys;
        synchronized (set) {
            this.keys.add(result);
            result.interestOps(ops);
            result.attach(att);
        }
        return result;
    }
}

