/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ComponentInputMap
extends InputMap {
    private JComponent component;

    public ComponentInputMap(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        this.component = comp;
    }

    public void put(KeyStroke keystroke, Object value) {
        super.put(keystroke, value);
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public void clear() {
        super.clear();
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public void remove(KeyStroke keystroke) {
        super.remove(keystroke);
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public void setParent(InputMap parentMap) {
        if (parentMap != null && !(parentMap instanceof ComponentInputMap)) {
            throw new IllegalArgumentException("ComponentInputMaps can only have ComponentInputMaps for parents");
        }
        if (parentMap != null && ((ComponentInputMap)parentMap).getComponent() != this.component) {
            throw new IllegalArgumentException("ComponentInputMaps' parents must be associated with the same JComponents");
        }
        super.setParent(parentMap);
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }
}

