/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFactory {
    private static final String KEY_FACTORY = "KeyFactory";
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFacSpi, Provider provider, String algorithm) {
        this.keyFacSpi = keyFacSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static KeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return KeyFactory.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static KeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((provider = provider.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyFactory.getInstance(algorithm, p);
    }

    public static KeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        CPStringBuilder sb = new CPStringBuilder("KeyFactory for algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(KEY_FACTORY, algorithm, provider);
            return new KeyFactory((KeyFactorySpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final <T extends KeySpec> T getKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, keySpec);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(key);
    }
}

