/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class UnitWanderMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitWanderMission.class.getName());
    private static final String tag = "AI wanderer";

    public UnitWanderMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        this.uninitialized = false;
    }

    public UnitWanderMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public Location getTarget() {
        return null;
    }

    public void setTarget(Location target) {
    }

    public Location findTarget() {
        return null;
    }

    public String invalidReason() {
        return UnitWanderMission.invalidAIUnitReason(this.getAIUnit());
    }

    public boolean isOneTime() {
        return true;
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (reason != null) {
            logger.finest("AI wanderer broken(" + reason + "): " + this);
            return;
        }
        this.moveRandomlyTurn(tag);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, UnitWanderMission.getXMLElementTagName());
        }
    }

    public static String getXMLElementTagName() {
        return "unitWanderMission";
    }
}

