/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class ScoutingMission
extends Mission {
    private static final Logger logger = Logger.getLogger(ScoutingMission.class.getName());
    private static final String tag = "AI scout";
    private Location target = null;

    public ScoutingMission(AIMain aiMain, AIUnit aiUnit, Location loc) {
        super(aiMain, aiUnit);
        this.setTarget(loc);
        logger.finest("AI scout starts at " + aiUnit.getUnit().getLocation() + " with target " + this.target + ": " + this);
        this.uninitialized = false;
    }

    public ScoutingMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    private static boolean hasHorses(AIUnit aiUnit) {
        return aiUnit.getUnit().hasAbility("model.ability.scoutIndianSettlement");
    }

    private boolean hasHorses() {
        return ScoutingMission.hasHorses(this.getAIUnit());
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        return loc == null ? null : (ScoutingMission.invalidSettlementReason(aiUnit, loc.getSettlement()) == null ? loc.getSettlement() : (ScoutingMission.invalidTileReason(aiUnit, loc.getTile()) == null ? loc.getTile() : null));
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc;
        if (path == null || (loc = ScoutingMission.extractTarget(aiUnit, path)) == null || !(loc instanceof IndianSettlement) && !(loc instanceof Tile)) {
            return Integer.MIN_VALUE;
        }
        return 1000 / (path.getTotalTurns() + 1);
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value;
                Location loc = ScoutingMission.extractTarget(aiUnit, path);
                if ((loc instanceof IndianSettlement || loc instanceof Tile) && this.bestValue < (value = ScoutingMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (ScoutingMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        Unit carrier = unit.getCarrier();
        GoalDecider gd = ScoutingMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidIllegal();
        return unit.search(startTile, gd, standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = ScoutingMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? ScoutingMission.extractTarget(aiUnit, path) : ScoutingMission.upLoc(ScoutingMission.findCircleTarget(aiUnit, ScoutingMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    public static String prepare(AIUnit aiUnit) {
        String reason = ScoutingMission.invalidReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        if (!ScoutingMission.hasHorses(aiUnit)) {
            aiUnit.equipForRole(Unit.Role.SCOUT, false);
        }
        return ScoutingMission.hasHorses(aiUnit) || aiUnit.getUnit().hasAbility("model.ability.expertScout") ? null : "unit-not-a-SCOUT";
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Settlement || target instanceof Tile) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return ScoutingMission.findTarget(this.getAIUnit(), 20, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = ScoutingMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!ScoutingMission.hasHorses(aiUnit) ? "unit-not-a-SCOUT" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return ScoutingMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidIndianSettlementReason(AIUnit aiUnit, IndianSettlement is) {
        Tension tension;
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        String reason = ScoutingMission.invalidTargetReason(is);
        return reason != null ? reason : (is.hasScouted(owner) ? "settlement-contacted" : ((tension = is.getAlarm(owner)) != null && tension.getValue() >= Tension.Level.HATEFUL.getLimit() ? "settlement-hateful" : null));
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        return settlement instanceof Colony ? ScoutingMission.invalidColonyReason(aiUnit, (Colony)settlement) : (settlement instanceof IndianSettlement ? ScoutingMission.invalidIndianSettlementReason(aiUnit, (IndianSettlement)settlement) : "target-invalid");
    }

    private static String invalidTileReason(AIUnit aiUnit, Tile tile) {
        return tile == null ? "tile-null" : (!tile.hasLostCityRumour() ? "tile-lacks-rumour" : null);
    }

    public static String invalidReason(AIUnit aiUnit) {
        return ScoutingMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = ScoutingMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Settlement ? ScoutingMission.invalidSettlementReason(aiUnit, (Settlement)loc) : (loc instanceof Tile ? ScoutingMission.invalidTileReason(aiUnit, (Tile)loc) : "target-invalid"));
    }

    public String invalidReason() {
        return ScoutingMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (this.isTargetReason(reason)) {
            if (!this.retargetMission(tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest("AI scout broken(" + reason + "): " + this);
            return;
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits());
        switch (mt) {
            case MOVE_ILLEGAL: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: {
                return;
            }
            case ATTACK_UNIT: {
                this.moveRandomly(tag, unit.getTile().getDirection(this.getTarget().getTile()));
                return;
            }
            case MOVE: {
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                Map.Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                if (d == null) {
                    throw new IllegalStateException("Unit not next to target " + this.getTarget() + ": " + unit + "/" + unit.getLocation());
                }
                if (AIMessage.askScoutIndianSettlement(aiUnit, d)) break;
                logger.warning("AI scout unexpected failure at " + this.getTarget() + ": " + this);
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                Map.Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                if (d == null) {
                    throw new IllegalStateException("Unit not next to target " + this.getTarget() + ": " + unit + "/" + unit.getLocation());
                }
                if (AIMessage.askMove(aiUnit, d)) break;
                logger.warning("AI scout unexpected failure at " + this.getTarget() + ": " + this);
                break;
            }
            default: {
                logger.warning("AI scout unexpected move type " + (Object)((Object)mt) + ": " + this);
                return;
            }
        }
        if (unit.isDisposed()) {
            logger.finest("AI scout died at target " + this.getTarget() + ": " + this);
            return;
        }
        Location completed = this.getTarget();
        this.setTarget(ScoutingMission.findTarget(aiUnit, 20, false));
        if (completed instanceof Colony) {
            if (this.getTarget() == null) {
                for (EquipmentType e : new ArrayList<EquipmentType>(unit.getEquipment().keySet())) {
                    AIMessage.askEquipUnit(aiUnit, e, -unit.getEquipmentCount(e));
                }
            }
            logger.finest("AI scout arrived at " + ((Colony)completed).getName() + ", retargeting " + this.getTarget() + ": " + this);
        } else {
            logger.finest("AI scout completed target " + completed + ", retargeting " + this.getTarget() + ": " + this);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, ScoutingMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeAttribute(out, "target", (FreeColGameObject)((Object)this.target));
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = str == null ? null : this.getGame().getFreeColLocation(str);
    }

    public static String getXMLElementTagName() {
        return "scoutingMission";
    }
}

