/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.mission.Mission;

public class PioneeringMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PioneeringMission.class.getName());
    private static final String tag = "AI pioneer";
    private static final int DEFAULT_THREAT_TURNS = 3;
    private TileImprovementPlan tileImprovementPlan = null;
    private Location target = null;

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit, Location loc) {
        super(aiMain, aiUnit);
        this.setTarget(loc);
        logger.finest("AI pioneer starts with target " + this.getTarget() + ": " + this);
        this.uninitialized = false;
    }

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    private TileImprovementPlan getBestPlan(Tile tile) {
        return this.getEuropeanAIPlayer().getBestPlan(tile);
    }

    private static TileImprovementPlan getBestPlan(AIUnit aiUnit, Tile tile) {
        return ((EuropeanAIPlayer)aiUnit.getAIOwner()).getBestPlan(tile);
    }

    public TileImprovementPlan getTileImprovementPlan() {
        return this.tileImprovementPlan;
    }

    public void setTileImprovementPlan(TileImprovementPlan tip) {
        TileImprovementPlan old = this.tileImprovementPlan;
        this.tileImprovementPlan = tip;
        AIUnit aiUnit = this.getAIUnit();
        if (old != this.tileImprovementPlan) {
            if (old != null && old.getPioneer() == aiUnit) {
                old.setPioneer(null);
            }
            if (this.tileImprovementPlan != null) {
                this.tileImprovementPlan.setPioneer(aiUnit);
            }
        }
    }

    private void abandonTileImprovementPlan() {
        if (this.tileImprovementPlan != null) {
            this.setTileImprovementPlan(null);
        }
    }

    public void dispose() {
        this.abandonTileImprovementPlan();
        super.dispose();
    }

    private static boolean hasTools(AIUnit aiUnit) {
        return aiUnit.getUnit().hasAbility("model.ability.improveTerrain");
    }

    private boolean hasTools() {
        return PioneeringMission.hasTools(this.getAIUnit());
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        return loc == null ? null : (PioneeringMission.hasTools(aiUnit) ? (PioneeringMission.invalidReason(aiUnit, loc.getTile()) != null ? null : loc.getTile()) : (PioneeringMission.invalidReason(aiUnit, loc.getColony()) != null ? null : loc.getColony()));
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = PioneeringMission.extractTarget(aiUnit, path);
        if (PioneeringMission.hasTools(aiUnit)) {
            TileImprovementPlan tip;
            if (loc instanceof Tile && (tip = PioneeringMission.getBestPlan(aiUnit, (Tile)loc)) != null) {
                return 1000 * tip.getValue() / (path.getTotalTurns() + 1);
            }
        } else if (loc instanceof Colony) {
            return 1000 / (path.getTotalTurns() + 1);
        }
        return Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        Player owner = aiUnit.getUnit().getOwner();
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value = PioneeringMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (PioneeringMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        Unit carrier = unit.getCarrier();
        GoalDecider gd = PioneeringMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        return unit.search(startTile, gd, standardCd, range, carrier);
    }

    private static Colony getBestPioneeringColony(AIUnit aiUnit) {
        EuropeanAIPlayer aiPlayer = (EuropeanAIPlayer)aiUnit.getAIOwner();
        AIColony bestColony = null;
        int bestValue = -1;
        for (AIColony aic : aiPlayer.getAIColonies()) {
            int value = aic.getTileImprovementPlans().size();
            if (value <= bestValue) continue;
            bestValue = value;
            bestColony = aic;
        }
        if (bestColony == null) {
            return null;
        }
        Colony colony = bestColony.getColony();
        if (colony.isConnectedPort()) {
            return colony;
        }
        PathNode path = aiUnit.getUnit().findOurNearestPort();
        return path == null ? colony : path.getLastNode().getLocation().getColony();
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = PioneeringMission.findTargetPath(aiUnit, range, false);
        if (path != null) {
            return PioneeringMission.extractTarget(aiUnit, path);
        }
        if (deferOK) {
            return PioneeringMission.getBestPioneeringColony(aiUnit);
        }
        Location loc = PioneeringMission.findCircleTarget(aiUnit, PioneeringMission.getGoalDecider(aiUnit, false), range * 3, false);
        return PioneeringMission.hasTools(aiUnit) ? loc : PioneeringMission.upLoc(loc);
    }

    public static String prepare(AIUnit aiUnit) {
        String reason = PioneeringMission.invalidReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        if (!PioneeringMission.hasTools(aiUnit) && !aiUnit.equipForRole(Unit.Role.PIONEER, false)) {
            return "unit-could-not-equip";
        }
        return PioneeringMission.hasTools(aiUnit) || unit.hasAbility("model.ability.expertPioneer") ? null : "unit-missing-tools";
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Colony || target instanceof Tile) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            this.setTileImprovementPlan(target instanceof Tile ? this.getBestPlan((Tile)target) : null);
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return PioneeringMission.findTarget(this.getAIUnit(), 10, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = PioneeringMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isPerson() ? "unit-not-a-person" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = PioneeringMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
        return reason != null ? reason : (!PioneeringMission.hasTools(aiUnit) && !colony.canProvideEquipment(Unit.Role.PIONEER.getRoleEquipment(colony.getSpecification())) ? "colony-can-not-provide-equipment" : null);
    }

    private static TileImprovementPlan getPlan(AIUnit aiUnit, Tile tile) {
        PioneeringMission pm;
        if (aiUnit.getMission() instanceof PioneeringMission && (pm = (PioneeringMission)aiUnit.getMission()).getTileImprovementPlan() != null && pm.getTileImprovementPlan().getTarget() == tile) {
            return pm.getTileImprovementPlan();
        }
        return null;
    }

    private static String invalidTileReason(AIUnit aiUnit, Tile tile) {
        return tile == null ? "target-invalid" : (!PioneeringMission.hasTools(aiUnit) ? "unit-needs-tools" : (PioneeringMission.getPlan(aiUnit, tile) == null && PioneeringMission.getBestPlan(aiUnit, tile) == null ? "tile-has-no-plan" : null));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return PioneeringMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = PioneeringMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Tile ? PioneeringMission.invalidTileReason(aiUnit, (Tile)loc) : (loc instanceof Colony ? (aiUnit.getUnit().getLocation() instanceof Tile ? PioneeringMission.invalidColonyReason(aiUnit, (Colony)loc) : PioneeringMission.invalidTargetReason((Colony)loc, aiUnit.getUnit().getOwner())) : "target-invalid"));
    }

    public String invalidReason() {
        if (this.tileImprovementPlan != null) {
            if (this.tileImprovementPlan.isComplete()) {
                return null;
            }
            if (this.tileImprovementPlan.isDisposed()) {
                return "plan-disposed";
            }
        }
        return PioneeringMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        String where;
        String reason;
        Location newTarget;
        AIUnit aiUnit = this.getAIUnit();
        if (this.tileImprovementPlan != null) {
            String logMe = null;
            if (this.tileImprovementPlan.isComplete()) {
                logMe = "AI pioneer completed improvement " + this.getTarget() + "/" + this.tileImprovementPlan;
            } else if (!this.tileImprovementPlan.validate()) {
                logMe = "AI pioneer abandoned invalid plan " + this.getTarget() + "/" + this.tileImprovementPlan;
            }
            if (logMe != null) {
                newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
                this.setTarget(newTarget);
                logMe = logMe + ", retargeting " + newTarget + "/" + this.tileImprovementPlan + ": " + this;
                logger.finest(logMe);
                if (newTarget == null) {
                    return;
                }
            }
        }
        if (this.isTargetReason(reason = this.invalidReason())) {
            if (!this.retargetMission(tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest("AI pioneer broken(" + reason + "): " + this);
            return;
        }
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        EuropeanAIPlayer aiPlayer = this.getEuropeanAIPlayer();
        CostDecider costDecider = CostDeciders.avoidSettlementsAndBlockingUnits();
        while (!this.hasTools()) {
            if (this.travelToTarget(tag, this.getTarget(), costDecider) != Unit.MoveType.MOVE) {
                return;
            }
            where = ((Colony)this.getTarget()).getName();
            String logMe = "AI pioneer reached " + where;
            logMe = logMe + (aiUnit.equipForRole(Unit.Role.PIONEER, false) && this.hasTools() ? " and equips" : " but fails to equip");
            newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
            this.setTarget(newTarget);
            logMe = logMe + ", retargeting " + newTarget + "/" + this.tileImprovementPlan + ": " + this;
            logger.finest(logMe);
            if (newTarget != null) continue;
            return;
        }
        if (this.getTarget() instanceof Colony && PioneeringMission.invalidTargetReason(this.getTarget(), player) == null) {
            if (this.travelToTarget(tag, this.getTarget(), costDecider) != Unit.MoveType.MOVE) {
                return;
            }
            where = ((Colony)this.getTarget()).getName();
            newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
            this.setTarget(newTarget);
            logger.finest("AI pioneer reached intermediate colony " + where + ", retargeting " + newTarget + "/" + this.tileImprovementPlan + ": " + this);
            if (newTarget == null) {
                return;
            }
        }
        Unit.MoveType mt = this.travelToTarget(tag, this.getTarget(), costDecider);
        switch (mt) {
            case MOVE_NO_MOVES: {
                return;
            }
            case MOVE_ILLEGAL: 
            case MOVE_NO_ATTACK_CIVILIAN: {
                Map.Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                if (d != null) {
                    this.moveRandomly(tag, d);
                }
                return;
            }
            case MOVE: {
                break;
            }
            default: {
                logger.warning("AI pioneer unexpected move type (" + (Object)((Object)mt) + ") at " + unit.getLocation() + ": " + this);
                return;
            }
        }
        Tile tile = this.getTarget().getTile();
        if (!player.owns(tile)) {
            boolean fail = false;
            int price = player.getLandPrice(tile);
            if (price < 0) {
                fail = true;
            } else {
                if (price > 0 && !player.checkGold(price)) {
                    price = -1;
                }
                if (!AIMessage.askClaimLand(tile, aiUnit, price) || !player.owns(tile)) {
                    fail = true;
                }
            }
            if (fail) {
                aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
                this.tileImprovementPlan.dispose();
                this.setTarget(null);
                logger.finest("AI pioneer can not claim land at " + tile + ": " + this);
                return;
            }
        }
        if (unit.getState() == Unit.UnitState.IMPROVING) {
            unit.setMovesLeft(0);
            logger.finest("AI pioneer improving " + this.tileImprovementPlan.getType() + ": " + this);
        } else if (unit.checkSetState(Unit.UnitState.IMPROVING)) {
            if (AIMessage.askChangeWorkImprovementType(aiUnit, this.tileImprovementPlan.getType())) {
                logger.finest("AI pioneer began improvement " + this.tileImprovementPlan.getType() + " at target " + tile + ": " + this);
            } else {
                aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
                this.tileImprovementPlan.dispose();
                this.setTarget(null);
                logger.warning("AI pioneer failed to improve " + tile + ": " + this);
            }
        } else {
            logger.finest("AI pioneer waiting to improve at " + tile + ": " + this);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, PioneeringMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeAttribute(out, "target", (FreeColGameObject)((Object)this.target));
            if (this.tileImprovementPlan != null) {
                out.writeAttribute("tileImprovementPlan", this.tileImprovementPlan.getId());
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        AIObject aio;
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = str == null ? null : this.getGame().getFreeColLocation(str);
        str = in.getAttributeValue(null, "tileImprovementPlan");
        this.tileImprovementPlan = str == null ? null : ((aio = this.getAIMain().getAIObject(str)) instanceof TileImprovementPlan ? (TileImprovementPlan)aio : new TileImprovementPlan(this.getAIMain(), str));
    }

    public static String getXMLElementTagName() {
        return "pioneeringMission";
    }
}

