/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class IndianDemandMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianDemandMission.class.getName());
    private static final String tag = "AI native demander";
    private Location target;
    private boolean completed;
    private boolean demanded;

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.target = target;
        this.completed = false;
        this.demanded = false;
        Unit unit = this.getUnit();
        if (!unit.getOwner().isIndian() || !unit.canCarryGoods()) {
            throw new IllegalArgumentException("Unsuitable unit: " + unit);
        }
        this.uninitialized = false;
    }

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    private boolean hasTribute() {
        return IndianDemandMission.hasTribute(this.getAIUnit());
    }

    private static boolean hasTribute(AIUnit aiUnit) {
        return aiUnit.getUnit().hasGoodsCargo();
    }

    public Goods selectGoods(Colony target) {
        int goodsValue;
        int value;
        Specification spec = this.getSpecification();
        Tension.Level tension = this.getUnit().getOwner().getTension(target.getOwner()).getLevel();
        int dx = spec.getInteger("model.option.nativeDemands") + 1;
        GoodsType food = this.getSpecification().getPrimaryFoodType();
        AbstractGoods goods = null;
        if (tension.compareTo(Tension.Level.CONTENT) <= 0 && target.getGoodsCount(food) >= 100) {
            int amount = target.getGoodsCount(food) * dx / 6;
            if (amount > 0) {
                return new Goods(this.getGame(), target, food, this.capAmount(amount, dx));
            }
        } else if (tension.compareTo(Tension.Level.DISPLEASED) <= 0) {
            Market market = target.getOwner().getMarket();
            value = 0;
            for (Goods currentGoods : target.getCompactGoods()) {
                goodsValue = market.getSalePrice(currentGoods);
                if (currentGoods.getType().isFoodType() || currentGoods.getType().isMilitaryGoods() || goodsValue <= value) continue;
                value = goodsValue;
                goods = currentGoods;
            }
            if (goods != null) {
                goods.setAmount(this.capAmount(goods.getAmount(), dx));
                return goods;
            }
        } else {
            int amount;
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isMilitaryGoods() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isBuildingMaterial() || !preferred.isStorable() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isTradeGoods() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isRefined() || !preferred.isStorable() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
        }
        Market market = target.getOwner().getMarket();
        value = 0;
        for (Goods currentGoods : target.getCompactGoods()) {
            goodsValue = market.getSalePrice(currentGoods);
            if (goodsValue <= value) continue;
            value = goodsValue;
            goods = currentGoods;
        }
        if (goods != null) {
            goods.setAmount(this.capAmount(goods.getAmount(), dx));
        }
        return goods;
    }

    private int capAmount(int amount, int difficulty) {
        int finalAmount = Math.max(amount * difficulty / 6, 1);
        finalAmount = Math.min(finalAmount, 100);
        return finalAmount;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        throw new IllegalStateException("Target is fixed");
    }

    public Location findTarget() {
        throw new IllegalStateException("Target is fixed");
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = IndianDemandMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (aiUnit.getUnit().getIndianSettlement() == null ? "home-destroyed" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = IndianDemandMission.invalidTargetReason(colony);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Player targetPlayer = colony.getOwner();
        switch (owner.getStance(targetPlayer)) {
            case UNCONTACTED: 
            case PEACE: 
            case ALLIANCE: {
                return "bad-stance";
            }
            case WAR: 
            case CEASE_FIRE: {
                Tension tension = unit.getIndianSettlement().getAlarm(targetPlayer);
                if (tension == null || tension.getLevel().compareTo(Tension.Level.CONTENT) > 0) break;
                return "happy";
            }
        }
        return null;
    }

    public static String invalidReason(AIUnit aiUnit) {
        return IndianDemandMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = IndianDemandMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? IndianDemandMission.invalidColonyReason(aiUnit, (Colony)loc) : "target-invalid");
    }

    public String invalidReason() {
        String reason = IndianDemandMission.invalidReason(this.getAIUnit(), this.target);
        return reason != null ? reason : (this.completed ? "completed" : null);
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (reason != null) {
            logger.finest("AI native demander broken(" + reason + "): " + this);
            return;
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        IndianSettlement is = unit.getIndianSettlement();
        while (!this.completed) {
            int oldGoods;
            Map.Direction d;
            Unit.MoveType mt;
            if (this.hasTribute()) {
                mt = this.travelToTarget(tag, is, CostDeciders.avoidSettlementsAndBlockingUnits());
                switch (mt) {
                    case MOVE_NO_MOVES: {
                        return;
                    }
                    case MOVE: {
                        break;
                    }
                    default: {
                        logger.warning("AI native demander unexpected delivery move type: " + (Object)((Object)mt) + ": " + this);
                        this.moveRandomly(tag, null);
                        return;
                    }
                }
                GoodsContainer container = unit.getGoodsContainer();
                for (Goods goods : container.getCompactGoods()) {
                    Goods tribute = container.removeGoods(goods.getType());
                    is.addGoods(tribute);
                }
                logger.finest("AI native demander completed unloading tribute at " + is.getName() + ": " + this);
                this.completed = true;
                return;
            }
            mt = this.travelToTarget(tag, this.target, null);
            switch (mt) {
                case MOVE_NO_MOVES: {
                    return;
                }
                case ATTACK_SETTLEMENT: {
                    d = unit.getTile().getDirection(this.target.getTile());
                    if (d != null) break;
                }
                case ATTACK_UNIT: {
                    Location blocker = IndianDemandMission.resolveBlockage(aiUnit, this.target);
                    if (blocker == null) {
                        logger.warning("AI native demander could not resolve blockage: " + this);
                        this.moveRandomly(tag, null);
                        unit.setMovesLeft(0);
                    } else {
                        logger.finest("AI native demander blocked by " + blocker + ", attacking: " + this);
                        d = unit.getTile().getDirection(blocker.getTile());
                        AIMessage.askAttack(aiUnit, d);
                    }
                    return;
                }
                default: {
                    logger.warning("AI native demander unexpected demand move type: " + (Object)((Object)mt) + ": " + this);
                    this.moveRandomly(tag, null);
                    return;
                }
            }
            Colony colony = (Colony)this.getTarget();
            Player enemy = colony.getOwner();
            Goods goods = this.selectGoods(colony);
            int gold = 0;
            int n = oldGoods = goods == null ? 0 : unit.getGoodsCount(goods.getType());
            if (goods == null) {
                if (!enemy.checkGold(1)) {
                    this.completed = true;
                    logger.finest("AI native demander completed empty handed at " + colony.getName() + ": " + this);
                    return;
                }
                gold = enemy.getGold() / 20;
                if (gold == 0) {
                    gold = enemy.getGold();
                }
            }
            this.demanded = true;
            boolean accepted = AIMessage.askIndianDemand(aiUnit, colony, goods, gold);
            if (accepted && (gold > 0 || this.hasTribute())) {
                if (goods != null) {
                    logger.finest("AI native demander accepted at " + colony.getName() + " tribute: " + goods.toString() + ": " + this);
                    continue;
                }
                logger.finest("AI native demander completed at " + colony.getName() + " tribute: " + gold + " gold: " + this);
            } else {
                int unitTension = is == null ? 0 : is.getAlarm(enemy).getValue();
                int tension = Math.max(unitTension, unit.getOwner().getTension(enemy).getValue());
                d = unit.getTile().getDirection(colony.getTile());
                boolean attack = tension >= Tension.Level.CONTENT.getLimit() && d != null;
                logger.finest("AI native demander completed with refusal at " + colony.getName() + (attack ? "(attacking)" : "") + ": " + this);
                if (attack) {
                    AIMessage.askAttack(aiUnit, d);
                    return;
                }
            }
            this.completed = true;
            this.moveRandomlyTurn(tag);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, IndianDemandMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("completed", Boolean.toString(this.completed));
        out.writeAttribute("demanded", Boolean.toString(this.demanded));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = this.getGame().getFreeColGameObject(str, Colony.class);
        str = in.getAttributeValue(null, "completed");
        this.completed = Boolean.valueOf(str);
        str = in.getAttributeValue(null, "demanded");
        this.demanded = Boolean.valueOf(str);
    }

    public static String getXMLElementTagName() {
        return "indianDemandMission";
    }
}

