/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class IdleAtSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IdleAtSettlementMission.class.getName());
    private static final String tag = "AI idler";

    public IdleAtSettlementMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        this.uninitialized = false;
    }

    public IdleAtSettlementMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public Location getTransportDestination() {
        Unit unit = this.getUnit();
        if (unit.getTile() == null || unit.getTile().getSettlement() != null) {
            return null;
        }
        PathNode path = unit.findOurNearestOtherSettlement();
        Tile target = path == null ? null : path.getLastNode().getTile();
        return unit.shouldTakeTransportTo(target) ? target : null;
    }

    public Location getTarget() {
        return null;
    }

    public void setTarget(Location target) {
    }

    public Location findTarget() {
        PathNode path = this.getAIUnit().getUnit().findOurNearestOtherSettlement();
        return path == null ? null : IdleAtSettlementMission.upLoc(path.getLastNode().getLocation());
    }

    public String invalidReason() {
        return IdleAtSettlementMission.invalidAIUnitReason(this.getAIUnit());
    }

    public boolean isOneTime() {
        return true;
    }

    public void doMission() {
        Unit unit = this.getUnit();
        String reason = this.invalidReason();
        if (reason != null) {
            logger.warning("AI idler broken(" + reason + "): " + this);
            return;
        }
        if (unit.getTile() == null) {
            return;
        }
        if (unit.getTile().getSettlement() != null) {
            return;
        }
        Location target = this.findTarget();
        if (target != null) {
            this.travelToTarget(tag, target, null);
        } else {
            this.moveRandomlyTurn(tag);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, IdleAtSettlementMission.getXMLElementTagName());
        }
    }

    public static String getXMLElementTagName() {
        return "idleAtSettlementMission";
    }
}

