/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class WorkerWish
extends Wish {
    private static final Logger logger = Logger.getLogger(WorkerWish.class.getName());
    private UnitType unitType;
    private boolean expertNeeded;

    public WorkerWish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.unitType = null;
        this.expertNeeded = false;
    }

    public WorkerWish(AIMain aiMain, Location destination, int value, UnitType unitType, boolean expertNeeded) {
        this(aiMain, WorkerWish.getXMLElementTagName() + ":" + aiMain.getNextId());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.setValue(value);
        this.unitType = unitType;
        this.expertNeeded = expertNeeded;
        this.uninitialized = false;
    }

    public WorkerWish(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.unitType == null;
    }

    public WorkerWish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.unitType == null;
    }

    public void update(UnitType unitType, boolean expertNeeded, int value) {
        this.setValue(value);
        this.unitType = unitType;
        this.expertNeeded = expertNeeded;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public boolean satisfiedBy(Unit unit) {
        return this.expertNeeded ? unit.getType() == this.unitType : unit.getType().isNaval() == this.unitType.isNaval();
    }

    public boolean checkIntegrity() {
        return super.checkIntegrity() && this.unitType != null;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(WorkerWish.getXMLElementTagName());
        this.writeAttributes(out);
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("unitType", this.unitType.getId());
        out.writeAttribute("expertNeeded", Boolean.toString(this.expertNeeded));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "unitType");
        this.unitType = this.getSpecification().getUnitType(str);
        this.expertNeeded = this.getAttribute(in, "expertNeeded", false);
    }

    public String toString() {
        return "[" + this.getId() + " " + (this.unitType == null ? "null" : this.unitType.getNameKey()) + " (" + this.getValue() + (this.expertNeeded ? ", expert" : "") + ")]";
    }

    public static String getXMLElementTagName() {
        return "workerWish";
    }
}

