/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.model.ServerPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(NativeAIPlayer.class.getName());
    private static final String SHIP_TRADE_PENALTY = "model.modifier.shipTradePenalty";
    private static final String MISSIONARY_TRADE_BONUS = "model.modifier.missionaryTradeBonus";
    public static final int MAX_DISTANCE_TO_BRING_GIFTS = 5;
    public static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    public static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    public static final int MAX_NUMBER_OF_DEMANDS = 1;
    private HashMap<String, Integer> sessionRegister = new HashMap();

    public NativeAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
        this.uninitialized = this.getPlayer() == null;
    }

    public NativeAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.getPlayer() == null;
    }

    @Override
    public void startWorking() {
        Turn turn = this.getGame().getTurn();
        logger.finest(this.getClass().getName() + " in " + turn + ": " + this.getPlayer().getNationID());
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.determineStances();
        if (turn.isFirstTurn()) {
            this.initializeMissions();
        } else {
            this.abortInvalidAndOneTimeMissions();
            this.secureSettlements();
            this.bringGifts();
            this.demandTribute();
            this.giveNormalMissions();
            this.doMissions();
            this.abortInvalidMissions();
            this.giveNormalMissions();
        }
        this.doMissions();
        this.abortInvalidMissions();
        this.clearAIUnits();
    }

    private void initializeMissions() {
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (IndianSettlement is : player.getIndianSettlements()) {
            int defence = is.getType().getMinimumSize() - 1;
            units.clear();
            units.addAll(is.getTile().getUnitList());
            units.addAll(is.getUnitList());
            while (units.size() > defence) {
                units.remove(0);
            }
            for (Unit u : units) {
                AIUnit aiu = this.getAIUnit(u);
                aiu.setMission(new DefendSettlementMission(aiMain, aiu, is));
            }
        }
    }

    private void secureSettlements() {
        List<IndianSettlement> settlements = this.getPlayer().getIndianSettlements();
        for (IndianSettlement is : settlements) {
            int n = Utils.randomInt(logger, "Secure", this.getAIRandom(), settlements.size());
            IndianSettlement settlement = settlements.get(n);
            if (settlement == is) continue;
            is.tradeGoodsWithSettlement(settlement);
        }
        for (IndianSettlement is : settlements) {
            this.equipBraves(is);
            this.secureIndianSettlement(is);
        }
    }

    public void equipBraves(IndianSettlement is) {
        Specification spec = this.getSpecification();
        List<Unit> units = is.getUnitList();
        units.addAll(is.getTile().getUnitList());
        block0: for (Unit.Role r : new Unit.Role[]{Unit.Role.DRAGOON, Unit.Role.SOLDIER, Unit.Role.SCOUT}) {
            List<EquipmentType> e = r.getRoleEquipment(spec);
            while (!units.isEmpty()) {
                Unit u = units.get(0);
                for (EquipmentType et : e) {
                    if (!u.canBeEquippedWith(et) || is.canProvideEquipment(et)) continue;
                    continue block0;
                }
                if (u.getRole() != Unit.Role.DRAGOON && u.getRole() != r) {
                    this.getAIUnit(u).equipForRole(r, false);
                }
                units.remove(0);
            }
        }
    }

    public void secureIndianSettlement(final IndianSettlement is) {
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        CombatModel cm = this.getGame().getCombatModel();
        int minimumDefence = is.getType().getMinimumSize() - 1;
        ArrayList<Unit> units = new ArrayList<Unit>();
        ArrayList<Unit> defenders = new ArrayList<Unit>();
        units.addAll(is.getUnitList());
        units.addAll(is.getTile().getUnitList());
        for (Unit u : is.getOwnedUnits()) {
            if (units.contains(u)) continue;
            units.add(u);
        }
        String logMe = "Defending settlement " + is.getName() + " with:";
        for (Unit u : new ArrayList(units)) {
            AIUnit aiu = aiMain.getAIUnit(u);
            if (aiu == null) {
                units.remove(u);
                continue;
            }
            if (aiu.getMission() instanceof DefendSettlementMission && ((DefendSettlementMission)aiu.getMission()).getTarget() == is) {
                logMe = logMe + " " + u.getId();
                defenders.add(u);
                units.remove(u);
                continue;
            }
            if (Mission.invalidNewMissionReason(aiu) == null) continue;
            units.remove(u);
        }
        final HashMap<Tile, Float> threats = new HashMap<Tile, Float>();
        for (Tile t : is.getTile().getSurroundingTiles(2)) {
            float bonus;
            float threshold;
            if (!t.isLand() || t.getUnitCount() == 0) continue;
            Player enemy = t.getFirstUnit().getOwner();
            if (enemy == player) {
                for (Unit u : t.getUnitList()) {
                    AIUnit aiu;
                    if (defenders.contains(u) || units.contains(u) || (aiu = aiMain.getAIUnit(u)) == null) continue;
                    if (aiu.getMission() instanceof DefendSettlementMission && ((DefendSettlementMission)aiu.getMission()).getTarget() == is) {
                        logMe = logMe + " " + u.getId();
                        defenders.add(u);
                        continue;
                    }
                    if (Mission.invalidNewMissionReason(aiu) != null) continue;
                    units.add(u);
                }
                continue;
            }
            Tension tension = is.getAlarm(enemy);
            if (tension == null || tension.getLevel().compareTo(Tension.Level.CONTENT) <= 0) continue;
            float value = 0.0f;
            if (tension.getLevel().compareTo(Tension.Level.DISPLEASED) <= 0) {
                threshold = 1.0f;
                bonus = 0.0f;
            } else {
                threshold = 0.0f;
                bonus = (float)tension.getLevel().ordinal() - (float)Tension.Level.CONTENT.ordinal();
            }
            for (Unit u : t.getUnitList()) {
                float offence = cm.getOffencePower(u, is);
                if (!(offence > threshold)) continue;
                value += offence + bonus;
            }
            if (!(value > 0.0f)) continue;
            threats.put(t, new Float(value));
        }
        int homeBonus = 3;
        Collections.sort(units, new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int s1 = u1.getTile().getDistanceTo(is.getTile());
                int s2 = u2.getTile().getDistanceTo(is.getTile());
                if (u1.getIndianSettlement() == is) {
                    s1 -= 3;
                }
                if (u2.getIndianSettlement() == is) {
                    s2 -= 3;
                }
                return s1 - s2;
            }
        });
        if (defenders.size() < minimumDefence + threats.size()) {
            int needed = minimumDefence + threats.size();
            logger.finest(is.getName() + " has " + defenders.size() + " initial defenders but needs " + minimumDefence + "(base)" + " + " + threats.size() + "(threats)" + " = " + needed);
            while (!units.isEmpty()) {
                Unit u = (Unit)units.remove(0);
                AIUnit aiu = aiMain.getAIUnit(u);
                aiu.setMission(new DefendSettlementMission(aiMain, aiu, is));
                logMe = logMe + " [" + u.getId() + "]";
                defenders.add(u);
                if (defenders.size() < needed) continue;
                break;
            }
        }
        logger.finest(logMe);
        if (units.isEmpty()) {
            return;
        }
        ArrayList threatTiles = new ArrayList(threats.keySet());
        Collections.sort(threatTiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile t1, Tile t2) {
                return Float.compare(((Float)threats.get(t2)).floatValue(), ((Float)threats.get(t1)).floatValue());
            }
        });
        while (!threatTiles.isEmpty() && !units.isEmpty()) {
            Tile tile = (Tile)threatTiles.remove(0);
            int bestDistance = Integer.MAX_VALUE;
            Unit unit = null;
            for (Unit u : units) {
                int distance;
                AIUnit aiu = aiMain.getAIUnit(u);
                if (UnitSeekAndDestroyMission.invalidReason(aiu, tile.getDefendingUnit(u)) != null || bestDistance <= (distance = u.getTile().getDistanceTo(tile))) continue;
                bestDistance = distance;
                unit = u;
            }
            if (unit == null) continue;
            units.remove(unit);
            AIUnit aiUnit = aiMain.getAIUnit(unit);
            Unit target = tile.getDefendingUnit(unit);
            logger.finest(is.getName() + " sends unit to attack " + target + " at " + tile + ": " + aiUnit);
            aiUnit.setMission(new UnitSeekAndDestroyMission(aiMain, aiUnit, target));
        }
    }

    private void giveNormalMissions() {
        Mission m;
        Unit unit;
        AIUnit aiUnit;
        AIMain aiMain = this.getAIMain();
        Specification spec = aiMain.getGame().getSpecification();
        int turnNumber = this.getGame().getTurn().getNumber();
        List<EquipmentType> scoutEq = Unit.Role.SCOUT.getRoleEquipment(spec);
        List<EquipmentType> soldierEq = Unit.Role.SOLDIER.getRoleEquipment(spec);
        List<AIUnit> aiUnits = this.getAIUnits();
        String report = "";
        int allUnits = aiUnits.size();
        int i = 0;
        while (i < aiUnits.size()) {
            aiUnit = aiUnits.get(i);
            unit = aiUnit.getUnit();
            m = aiUnit.getMission();
            String reason = null;
            if (unit.isUninitialized() || unit.isDisposed()) {
                reason = "Invalid-" + aiUnit.toString();
            } else if (m != null && m.isValid() && !m.isOneTime()) {
                reason = "Valid-" + m.toString();
            }
            if (reason == null) {
                ++i;
                continue;
            }
            report = report + "\n  " + reason;
            aiUnits.remove(i);
        }
        report = Utils.lastPart(this.getPlayer().getNationID(), ".") + ".giveNormalMissions(turn=" + turnNumber + " all-units=" + allUnits + " free-land-units=" + aiUnits.size() + ")" + report;
        i = 0;
        while (i < aiUnits.size()) {
            aiUnit = aiUnits.get(i);
            unit = aiUnit.getUnit();
            Settlement settlement = unit.getSettlement();
            IndianSettlement is = unit.getIndianSettlement();
            if (settlement != null && settlement.getUnitCount() + unit.getTile().getUnitCount() <= 1 && (m = new DefendSettlementMission(aiMain, aiUnit, settlement)) != null || is != null && (!unit.isMounted() && is.canProvideEquipment(scoutEq) || !unit.isArmed() && is.canProvideEquipment(soldierEq)) && (m = new DefendSettlementMission(aiMain, aiUnit, is)) != null || UnitWanderHostileMission.invalidReason(aiUnit) == null && (m = new UnitWanderHostileMission(aiMain, aiUnit)) != null) {
                aiUnit.setMission(m);
                report = report + "\n  New-" + m.toString();
                aiUnits.remove(i);
                continue;
            }
            ++i;
        }
        for (AIUnit aiUnit2 : aiUnits) {
            if (aiUnit2.getMission() instanceof IdleAtSettlementMission) {
                m = aiUnit2.getMission();
            } else {
                m = new IdleAtSettlementMission(aiMain, aiUnit2);
                aiUnit2.setMission(m);
            }
            report = report + "\n  UNUSED-" + m + " at " + aiUnit2.getUnit().getLocation();
        }
        logger.fine(report);
    }

    private void bringGifts() {
        Player player = this.getPlayer();
        Map map = this.getGame().getMap();
        CostDecider cd = CostDeciders.numberOfLegalTiles();
        int giftProbability = this.getGame().getSpecification().getInteger("model.option.giftProbability");
        for (IndianSettlement is : player.getIndianSettlements()) {
            Goods gift;
            if (Utils.randomInt(logger, is.getName() + " bring gifts", this.getAIRandom(), 100) >= giftProbability || (gift = is.getRandomGift(this.getAIRandom())) == null) continue;
            ArrayList<Unit> availableUnits = new ArrayList<Unit>();
            int alreadyAssignedUnits = 0;
            for (Unit ou : is.getOwnedUnits()) {
                AIUnit aiu = this.getAIUnit(ou);
                if (aiu == null) continue;
                if (aiu.getMission() instanceof IndianBringGiftMission) {
                    ++alreadyAssignedUnits;
                    continue;
                }
                if (Mission.invalidNewMissionReason(aiu) != null) continue;
                availableUnits.add(ou);
            }
            if (alreadyAssignedUnits > 1) {
                logger.finest(is.getName() + " has " + alreadyAssignedUnits + " already.");
                continue;
            }
            if (availableUnits.isEmpty()) {
                logger.finest(is.getName() + " has no gift units.");
                continue;
            }
            Unit unit = null;
            AIUnit aiUnit = null;
            Tile home = is.getTile();
            while (unit == null && !availableUnits.isEmpty()) {
                Unit u = (Unit)availableUnits.get(Utils.randomInt(logger, "Choose gift unit", this.getAIRandom(), availableUnits.size()));
                availableUnits.remove(u);
                aiUnit = this.getAIUnit(u);
                if (IndianBringGiftMission.invalidReason(aiUnit) != null || u.findPath(u.getTile(), home, null, cd) == null) continue;
                unit = u;
            }
            if (unit == null) {
                logger.finest(is.getName() + " has no suitable gift units.");
                continue;
            }
            ArrayList nearbyColonies = new ArrayList();
            for (Tile t : home.getSurroundingTiles(5)) {
                PathNode path;
                Colony c = t.getColony();
                if (c == null || !is.hasContacted(c.getOwner()) || IndianBringGiftMission.invalidReason(aiUnit, c) != null || (path = unit.findPath(home, c.getTile(), null, cd)) == null) continue;
                int alarm = Math.max(1, is.getAlarm(c.getOwner()).getValue());
                nearbyColonies.add(new RandomChoice<Colony>(c, 1000000 / alarm / path.getTotalTurns()));
            }
            if (nearbyColonies.isEmpty()) {
                logger.finest(is.getName() + " has no nearby gift colonies.");
                continue;
            }
            Colony target = (Colony)RandomChoice.getWeightedRandom(logger, "Choose gift colony", this.getAIRandom(), nearbyColonies);
            if (target == null) {
                throw new IllegalStateException("No gift target!?!");
            }
            logger.finest("Assigning gift " + gift + " from " + is.getName() + " to " + target.getName() + ": " + unit);
            aiUnit.setMission(new IndianBringGiftMission(this.getAIMain(), aiUnit, target));
        }
    }

    private void demandTribute() {
        Map map = this.getGame().getMap();
        Player player = this.getPlayer();
        CostDecider cd = CostDeciders.numberOfLegalTiles();
        int demandProbability = this.getGame().getSpecification().getInteger("model.option.demandProbability");
        for (IndianSettlement is : player.getIndianSettlements()) {
            if (Utils.randomInt(logger, is.getName() + " demand tribute", this.getAIRandom(), 100) >= demandProbability) continue;
            ArrayList<Unit> availableUnits = new ArrayList<Unit>();
            int alreadyAssignedUnits = 0;
            for (Unit ou : is.getOwnedUnits()) {
                AIUnit aiu = this.getAIUnit(ou);
                if (Mission.invalidNewMissionReason(aiu) != null) continue;
                if (aiu.getMission() instanceof IndianDemandMission) {
                    ++alreadyAssignedUnits;
                    continue;
                }
                availableUnits.add(ou);
            }
            if (alreadyAssignedUnits > 1) {
                logger.finest(is.getName() + " has " + alreadyAssignedUnits + " already.");
                continue;
            }
            if (availableUnits.isEmpty()) {
                logger.finest(is.getName() + " has no demand units.");
                continue;
            }
            Tile home = is.getTile();
            Unit unit = null;
            AIUnit aiUnit = null;
            while (unit == null && !availableUnits.isEmpty()) {
                Unit u = (Unit)availableUnits.get(Utils.randomInt(logger, "Choose demand unit", this.getAIRandom(), availableUnits.size()));
                availableUnits.remove(u);
                aiUnit = this.getAIUnit(u);
                if (IndianDemandMission.invalidReason(aiUnit) != null || u.findPath(u.getTile(), home, null, cd) == null) continue;
                unit = u;
            }
            if (unit == null) {
                logger.finest(is.getName() + " has no suitable demand units.");
                continue;
            }
            ArrayList nearbyColonies = new ArrayList();
            for (Tile t : home.getSurroundingTiles(5)) {
                PathNode path;
                Colony c = t.getColony();
                if (c == null || !is.hasContacted(c.getOwner()) || IndianDemandMission.invalidReason(aiUnit, c) != null || (path = unit.findPath(home, c.getTile(), null, cd)) == null) continue;
                int alarm = is.getAlarm(c.getOwner()).getValue();
                int defence = c.getUnitCount() + (c.getStockade() == null ? 1 : c.getStockade().getLevel() * 10);
                nearbyColonies.add(new RandomChoice<Colony>(c, alarm * (1000000 / defence / path.getTotalTurns())));
            }
            if (nearbyColonies.isEmpty()) {
                logger.finest(is.getName() + " has no nearby demand colonies.");
                continue;
            }
            Colony target = (Colony)RandomChoice.getWeightedRandom(logger, "Choose demand colony", this.getAIRandom(), nearbyColonies);
            if (target == null) {
                throw new IllegalStateException("No demand target!?!");
            }
            logger.finest("Assigning demand from " + is.getName() + " to " + target.getName() + ": " + unit);
            aiUnit.setMission(new IndianDemandMission(this.getAIMain(), aiUnit, target));
        }
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (type == DefendSettlementMission.class) {
            Settlement settlement = (Settlement)DefendSettlementMission.extractTarget(aiUnit, path);
            value -= 75 * this.getSettlementDefenders(settlement);
        } else if (type == UnitSeekAndDestroyMission.class) {
            Location target = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
            Player targetPlayer = target instanceof Ownable ? ((Ownable)((Object)target)).getOwner() : null;
            IndianSettlement is = aiUnit.getUnit().getIndianSettlement();
            if (targetPlayer != null && is != null && is.getAlarm(targetPlayer) != null) {
                value += is.getAlarm(targetPlayer).getValue() - Tension.Level.DISPLEASED.getLimit();
            }
        }
        return value;
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        boolean validOffer = true;
        Player.Stance stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                switch (stance) {
                    case UNCONTACTED: {
                        validOffer = false;
                        break;
                    }
                    case WAR: {
                        break;
                    }
                    case CEASE_FIRE: {
                        value -= 500;
                        break;
                    }
                    case PEACE: {
                        if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace")) break;
                        value -= 1000;
                        break;
                    }
                    case ALLIANCE: {
                        value -= 2000;
                    }
                }
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        if (validOffer) {
            logger.info("Trade value is " + value + ", accept if >=0");
        } else {
            logger.info("Trade offer is considered invalid!");
        }
        return value >= 0 && validOffer;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    private Set<Modifier> getMissionaryTradeBonuses(Unit missionary, boolean sense) {
        Set<Modifier> result;
        Set<Modifier> missionaryBonuses = missionary.getModifierSet(MISSIONARY_TRADE_BONUS);
        if (sense) {
            result = missionaryBonuses;
        } else {
            result = new HashSet<Modifier>();
            for (Modifier m : missionaryBonuses) {
                result.add(new Modifier(m.getId(), m.getSource(), -m.getValue(), m.getType()));
            }
        }
        return result;
    }

    private Set<Modifier> getShipTradePenalties(boolean sense) {
        Specification spec = this.getSpecification();
        List<Modifier> shipPenalties = spec.getModifiers(SHIP_TRADE_PENALTY);
        HashSet<Modifier> result = new HashSet<Modifier>();
        int penalty = spec.getInteger("model.option.shipTradePenalty");
        for (Modifier m : shipPenalties) {
            result.add(new Modifier(m.getId(), m.getSource(), sense ? penalty : -penalty, m.getType()));
        }
        return result;
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        Specification spec = this.getSpecification();
        IndianSettlement is = (IndianSettlement)settlement;
        Player buyer = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = is.getPriceToSell(goods);
            switch (is.getAlarm(buyer).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    break;
                }
                case DISPLEASED: {
                    price *= 2;
                    break;
                }
                default: {
                    return -3;
                }
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            Unit missionary = is.getMissionary(buyer);
            if (missionary != null && spec.getBoolean("model.option.enhancedMissionaries")) {
                modifiers.addAll(this.getMissionaryTradeBonuses(missionary, false));
            }
            if (unit.isNaval()) {
                modifiers.addAll(this.getShipTradePenalties(false));
            }
            price = (int)FeatureContainer.applyModifierSet(price, this.getGame().getTurn(), modifiers);
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (Utils.randomInt(logger, "Haggle-buy", this.getAIRandom(), 3 + haggling) >= 3) {
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -2;
        }
        this.sessionRegister.put(goldKey, new Integer(gold));
        this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
        return gold;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        int price;
        logger.finest("Entering method sellProposition");
        Specification spec = this.getSpecification();
        IndianSettlement is = (IndianSettlement)settlement;
        Player seller = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        if (this.sessionRegister.containsKey(goldKey)) {
            price = this.sessionRegister.get(goldKey);
        } else {
            price = is.getPriceToBuy(goods);
            switch (is.getAlarm(seller).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    break;
                }
                case DISPLEASED: {
                    price /= 2;
                    break;
                }
                case ANGRY: {
                    if (!goods.getType().isMilitaryGoods()) {
                        return -3;
                    }
                    price /= 2;
                    break;
                }
                default: {
                    return -3;
                }
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            Unit missionary = is.getMissionary(seller);
            if (missionary != null && spec.getBoolean("model.option.enhancedMissionaries")) {
                modifiers.addAll(this.getMissionaryTradeBonuses(missionary, true));
            }
            if (unit.isNaval()) {
                modifiers.addAll(this.getShipTradePenalties(true));
            }
            if ((price = (int)FeatureContainer.applyModifierSet(price, this.getGame().getTurn(), modifiers)) <= 0) {
                return 0;
            }
            this.sessionRegister.put(goldKey, new Integer(price));
        }
        if (gold < 0 || price == gold) {
            return price;
        }
        if (gold > price * 11 / 10) {
            logger.warning("Cheating attempt: haggling request too high");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (Utils.randomInt(logger, "Haggle-sell", this.getAIRandom(), 3 + haggling) >= 3) {
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -2;
        }
        this.sessionRegister.put(goldKey, new Integer(gold));
        this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
        return gold;
    }
}

