/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.goal.Goal;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class AIUnit
extends AIObject
implements Transportable {
    private static final Logger logger = Logger.getLogger(AIUnit.class.getName());
    private Unit unit;
    private Mission mission;
    private Goal goal = null;
    private int dynamicPriority;
    private AIUnit transport;

    public AIUnit(AIMain aiMain, String id) {
        super(aiMain, id);
        this.unit = null;
        this.mission = null;
        this.goal = null;
        this.dynamicPriority = 0;
        this.transport = null;
    }

    public AIUnit(AIMain aiMain, Unit unit) {
        this(aiMain, unit.getId());
        this.unit = unit;
        this.mission = null;
        this.uninitialized = this.getUnit() == null;
    }

    public AIUnit(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.getUnit() == null;
    }

    public AIUnit(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.getUnit() == null;
    }

    public void dispose() {
        this.getAIOwner().removeAIUnit(this);
        this.abortMission("AIUnit-disposed");
        this.setTransport(null, "disposing");
        super.dispose();
    }

    public String getId() {
        if (this.unit == null) {
            logger.warning("Uninitialized AI unit");
            return null;
        }
        return this.unit.getId();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Random getAIRandom() {
        return this.getAIMain().getAIPlayer(this.unit.getOwner()).getAIRandom();
    }

    public AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.unit.getOwner());
    }

    public Mission getMission() {
        return this.mission;
    }

    public boolean moveToAmerica() {
        return AIMessage.askMoveTo(this, this.unit.getOwner().getGame().getMap());
    }

    public boolean moveToEurope() {
        return AIMessage.askMoveTo(this, this.unit.getOwner().getEurope());
    }

    public boolean hasCargo() {
        return this.unit == null ? false : this.unit.hasCargo();
    }

    public boolean hasMission() {
        return this.mission != null;
    }

    public void abortMission(String why) {
        if (this.mission != null) {
            if (!this.mission.isOneTime()) {
                logger.fine("Mission-ABORT(" + why + "): " + this.mission);
            }
            this.removeTransport(why);
            this.mission.dispose();
            this.mission = null;
            this.dynamicPriority = 0;
        }
    }

    private void removeTransport(String reason) {
        Mission m;
        AIUnit transport = this.getTransport();
        if (transport != null && (m = transport.getMission()) instanceof TransportMission) {
            ((TransportMission)m).removeTransportable(this, reason);
        }
        this.setTransport(null, reason);
    }

    private void retargetTransport() {
        Mission m;
        AIUnit transport = this.getTransport();
        if (transport != null && (m = transport.getMission()) instanceof TransportMission) {
            ((TransportMission)m).retargetTransportable(this);
        }
    }

    public void setMission(Mission mission) {
        if (this.mission == mission) {
            return;
        }
        if (this.mission == null) {
            if (!mission.isOneTime()) {
                logger.fine("Replacing null mission with " + mission);
            }
        } else {
            this.abortMission("replaced");
        }
        this.mission = mission;
        this.dynamicPriority = 0;
    }

    public void doMission() {
        if (this.mission != null && this.mission.isValid()) {
            this.mission.doMission();
        }
    }

    public Goal getGoal() {
        return this.goal;
    }

    public void setGoal(Goal goal) {
        this.goal = goal;
    }

    public boolean equipForRole(Unit.Role r, boolean cheat) {
        Settlement settlement;
        Europe europe;
        Specification spec = this.getSpecification();
        Player player = this.unit.getOwner();
        Location loc = this.unit.getLocation();
        Europe europe2 = europe = this.unit.isInEurope() ? player.getEurope() : null;
        if (loc == null || (settlement = loc.getSettlement()) == null && europe == null) {
            return false;
        }
        block0: for (EquipmentType e : r.getRoleEquipment(spec)) {
            if (!this.unit.canBeEquippedWith(e)) continue;
            if (europe != null) {
                for (AbstractGoods ag : e.getRequiredGoods()) {
                    if (player.getMarket().getArrears(ag.getType()) > 0) continue block0;
                    int cost = player.getMarket().getBidPrice(ag.getType(), ag.getAmount());
                    if (player.checkGold(cost)) continue;
                    if (!cheat) continue block0;
                    player.logCheat("minted " + cost + " gold to equip " + this.unit + " for " + (Object)((Object)r));
                    player.modifyGold(cost);
                }
            } else if (!settlement.canBuildEquipment(e)) continue;
            AIMessage.askEquipUnit(this, e, 1);
        }
        return this.unit.getRole() == r;
    }

    public boolean move(Map.Direction direction) {
        Tile start = this.unit.getTile();
        return AIMessage.askMove(this, direction) && this.unit.getTile() != start;
    }

    public boolean stepPath(PathNode path) {
        return this.unit.isOnCarrier() && !path.isOnCarrier() ? this.leaveTransport(path.getDirection()) : this.move(path.getDirection());
    }

    public boolean checkIntegrity() {
        return super.checkIntegrity() && this.unit != null && !this.unit.isDisposed();
    }

    public int getSpaceTaken() {
        return this.getUnit() == null ? 0 : this.getUnit().getSpaceTaken();
    }

    public Location getTransportSource() {
        return this.getUnit() == null || this.getUnit().isDisposed() ? null : this.getUnit().getLocation();
    }

    public Location getTransportDestination() {
        return this.getUnit() == null || this.getUnit().isDisposed() || !this.hasMission() ? null : this.mission.getTransportDestination();
    }

    public int getTransportPriority() {
        if (this.hasMission()) {
            return this.mission.getTransportPriority() + this.dynamicPriority;
        }
        return 0;
    }

    public void setTransportPriority(int transportPriority) {
        if (this.hasMission()) {
            this.dynamicPriority = transportPriority;
        }
    }

    public void increaseTransportPriority() {
        if (this.hasMission()) {
            ++this.dynamicPriority;
        }
    }

    public Locatable getTransportLocatable() {
        return this.unit;
    }

    public AIUnit getTransport() {
        return this.transport;
    }

    public void setTransport(AIUnit transport, String reason) {
        if (this.transport != transport) {
            logger.finest("setTransport " + this + " on " + transport + ": " + reason);
        }
        this.transport = transport;
    }

    public void abortWish(Wish w) {
        if (this.mission instanceof WishRealizationMission) {
            this.mission = null;
            this.dynamicPriority = 0;
        }
        if (w.getTransportable() == this) {
            w.dispose();
        }
    }

    public boolean leaveTransport(Map.Direction direction) {
        boolean result;
        if (!this.unit.isOnCarrier()) {
            return false;
        }
        Unit carrier = this.unit.getCarrier();
        boolean bl = direction != null ? this.move(direction) : (result = AIMessage.askDisembark(this) && this.unit.getLocation() == carrier.getTile());
        if (result) {
            Colony colony = this.unit.getColony();
            if (colony != null) {
                colony.firePropertyChange("rearrangeWorkers", true, false);
            }
            this.removeTransport("disembarked");
        }
        return result;
    }

    public boolean joinTransport(Unit carrier, Map.Direction direction) {
        boolean result;
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        if (aiCarrier == null) {
            return false;
        }
        Location old = AIUnit.upLoc(this.unit.getLocation());
        boolean bl = result = AIMessage.askEmbark(aiCarrier, this.unit, direction) && this.unit.getLocation() == carrier;
        if (result) {
            Colony colony = this.unit.getColony();
            if (colony != null) {
                colony.firePropertyChange("rearrangeWorkers", true, false);
            }
            this.retargetTransport();
            AIPlayer owner = this.getAIOwner();
            if (owner instanceof EuropeanAIPlayer && !((EuropeanAIPlayer)owner).claimTransportable(this, old)) {
                logger.warning("Could not claim transportable from " + old + ": " + this);
            }
        }
        return result;
    }

    public boolean carriableBy(Unit carrier) {
        return carrier.couldCarry(this.unit);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIUnit.getXMLElementTagName());
        this.writeAttributes(out);
        if (this.mission != null && !this.mission.isOneTime()) {
            String reason = this.mission.invalidReason();
            if (reason != null) {
                this.abortMission(reason);
            } else {
                this.mission.toXML(out);
            }
        }
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.transport != null) {
            if (this.transport.getUnit() == null) {
                logger.warning("transport.getUnit() == null");
            } else if (this.getAIMain().getAIObject(this.transport.getId()) == null) {
                logger.warning("broken reference to transport");
            } else {
                out.writeAttribute("transport", this.transport.getUnit().getId());
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String str;
        AIMain aiMain = this.getAIMain();
        Game game = aiMain.getGame();
        this.unit = game.getFreeColGameObject(str = in.getAttributeValue(null, "ID"), Unit.class);
        if (this.unit == null) {
            throw new IllegalStateException("Not a Unit: " + str);
        }
        str = in.getAttributeValue(null, "transport");
        if (str == null) {
            this.transport = null;
        } else {
            this.transport = (AIUnit)aiMain.getAIObject(str);
            if (this.transport == null) {
                this.transport = new AIUnit(aiMain, str);
            }
        }
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        String tag = in.getLocalName();
        this.mission = null;
        if (tag.equals(BuildColonyMission.getXMLElementTagName())) {
            this.mission = new BuildColonyMission(aiMain, this, in);
        } else if (tag.equals(CashInTreasureTrainMission.getXMLElementTagName())) {
            this.mission = new CashInTreasureTrainMission(aiMain, this, in);
        } else if (tag.equals(DefendSettlementMission.getXMLElementTagName())) {
            this.mission = new DefendSettlementMission(aiMain, this, in);
        } else if (tag.equals(IdleAtSettlementMission.getXMLElementTagName()) || tag.equals("idleAtColonyMission")) {
            this.mission = new IdleAtSettlementMission(aiMain, this, in);
        } else if (tag.equals(IndianBringGiftMission.getXMLElementTagName())) {
            this.mission = new IndianBringGiftMission(aiMain, this, in);
        } else if (tag.equals(IndianDemandMission.getXMLElementTagName())) {
            this.mission = new IndianDemandMission(aiMain, this, in);
        } else if (tag.equals(MissionaryMission.getXMLElementTagName())) {
            this.mission = new MissionaryMission(aiMain, this, in);
        } else if (tag.equals(PioneeringMission.getXMLElementTagName()) || tag.equals("tileImprovementPlanMission")) {
            this.mission = new PioneeringMission(aiMain, this, in);
        } else if (tag.equals(PrivateerMission.getXMLElementTagName())) {
            this.mission = new PrivateerMission(aiMain, this, in);
        } else if (tag.equals(ScoutingMission.getXMLElementTagName())) {
            this.mission = new ScoutingMission(aiMain, this, in);
        } else if (tag.equals(TransportMission.getXMLElementTagName())) {
            this.mission = new TransportMission(aiMain, this, in);
        } else if (tag.equals(UnitSeekAndDestroyMission.getXMLElementTagName())) {
            this.mission = new UnitSeekAndDestroyMission(aiMain, this, in);
        } else if (tag.equals(UnitWanderHostileMission.getXMLElementTagName())) {
            this.mission = new UnitWanderHostileMission(aiMain, this, in);
        } else if (tag.equals(UnitWanderMission.getXMLElementTagName())) {
            this.mission = new UnitWanderMission(aiMain, this, in);
        } else if (tag.equals(WishRealizationMission.getXMLElementTagName())) {
            this.mission = new WishRealizationMission(aiMain, this, in);
        } else if (tag.equals(WorkInsideColonyMission.getXMLElementTagName())) {
            this.mission = new WorkInsideColonyMission(aiMain, this, in);
        } else {
            throw new IllegalStateException("Unknown AIUnit child: " + tag);
        }
    }

    public String toString() {
        return this.unit.toString("AIUnit ");
    }

    public static String getXMLElementTagName() {
        return "aiUnit";
    }
}

