/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringOption
extends AbstractOption<String> {
    private static Logger logger = Logger.getLogger(StringOption.class.getName());
    private String value;
    private List<String> choices;

    public StringOption(String id) {
        super(id);
    }

    public StringOption(Specification specification) {
        super(specification);
    }

    public StringOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public StringOption clone() {
        StringOption result = new StringOption(this.getId());
        result.setValues(this);
        result.choices = new ArrayList<String>(this.choices);
        return result;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(valueString != null ? valueString : defaultValueString);
    }

    public final List<String> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<String> newChoices) {
        this.choices = newChoices;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, StringOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", this.value);
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.choices != null && !this.choices.isEmpty()) {
            for (String choice : this.choices) {
                out.writeStartElement("choice");
                out.writeAttribute("value", choice);
                out.writeEndElement();
            }
        }
    }

    @Override
    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.readAttributes(in);
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
        if (this.choices.isEmpty()) {
            this.choices.add(this.value);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.choices = new ArrayList<String>();
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if ("choice".equals(in.getLocalName())) {
            this.choices.add(in.getAttributeValue(null, "value"));
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "stringOption";
    }

    @Override
    public String toString() {
        String result = "";
        if (this.choices != null) {
            for (String choice : this.choices) {
                result = result + ", " + choice;
            }
            if (result.length() > 0) {
                result = result.substring(2);
            }
        }
        return StringOption.getXMLElementTagName() + " [value=" + this.value + ", choices=[" + result + "]]";
    }
}

