/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NetworkReplyObject;
import org.xml.sax.SAXException;

final class ReceivingThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ReceivingThread.class.getName());
    private static final int MAXIMUM_RETRIES = 5;
    private final Map<Integer, NetworkReplyObject> waitingThreads = Collections.synchronizedMap(new HashMap());
    private final FreeColNetworkInputStream in;
    private final Connection connection;
    private boolean shouldRun;
    private int nextNetworkReplyId;

    ReceivingThread(Connection connection, InputStream in, String threadName) {
        super(threadName + "ReceivingThread - " + connection.toString());
        this.in = new FreeColNetworkInputStream(in);
        this.connection = connection;
        this.shouldRun = true;
        this.nextNetworkReplyId = 1;
    }

    public synchronized int getNextNetworkReplyId() {
        return this.nextNetworkReplyId++;
    }

    public NetworkReplyObject waitForNetworkReply(int networkReplyId) {
        NetworkReplyObject nro = new NetworkReplyObject(networkReplyId);
        this.waitingThreads.put(networkReplyId, nro);
        return nro;
    }

    private synchronized boolean shouldRun() {
        return this.shouldRun;
    }

    public synchronized void askToStop() {
        this.shouldRun = false;
        for (NetworkReplyObject o : this.waitingThreads.values()) {
            o.interrupt();
        }
    }

    private void disconnect(String reason) {
        if (this.connection.getMessageHandler() != null) {
            try {
                this.connection.getMessageHandler().handle(this.connection, DOMMessage.createMessage("disconnect", "reason", reason));
            }
            catch (FreeColException e) {
                logger.log(Level.WARNING, "Rx disconnect", e);
            }
        }
        this.askToStop();
    }

    private void listen() throws IOException, SAXException, XMLStreamException {
        int LOOK_AHEAD = 500;
        BufferedInputStream bis = new BufferedInputStream(this.in, 500);
        this.in.enable();
        bis.mark(500);
        if (!this.shouldRun()) {
            return;
        }
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader xmlIn = xif.createXMLStreamReader(bis);
        xmlIn.nextTag();
        String tag = xmlIn.getLocalName();
        if ("disconnect".equals(tag)) {
            this.askToStop();
        } else if ("reply".equals(tag)) {
            String id = xmlIn.getAttributeValue(null, "networkReplyId");
            NetworkReplyObject nro = this.waitingThreads.remove(Integer.valueOf(id));
            if (nro == null) {
                logger.warning("Could not find networkReplyId: " + id);
            } else {
                bis.reset();
                nro.setResponse(new DOMMessage(bis));
            }
        } else {
            bis.reset();
            try {
                this.connection.handleAndSendReply(bis);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "IO error", ioe);
            }
        }
        xmlIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int timesFailed = 0;
        try {
            while (this.shouldRun()) {
                try {
                    this.listen();
                    timesFailed = 0;
                }
                catch (XMLStreamException e) {
                    if (!this.shouldRun || ++timesFailed <= 5) continue;
                    this.disconnect("XML failure: " + e.getMessage());
                }
                catch (SAXException e) {
                    if (!this.shouldRun || ++timesFailed <= 5) continue;
                    this.disconnect("SAX failure: " + e.getMessage());
                }
                catch (IOException e) {
                    if (!this.shouldRun) continue;
                    this.disconnect("IO failure: " + e.getMessage());
                }
            }
        }
        finally {
            this.askToStop();
        }
    }

    private class FreeColNetworkInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 8192;
        private static final char END_OF_STREAM = '\n';
        private final InputStream in;
        private byte[] buffer = new byte[8192];
        private int bStart = 0;
        private int bEnd = 0;
        private boolean empty = true;
        private boolean wait = false;

        FreeColNetworkInputStream(InputStream in) {
            this.in = in;
        }

        private boolean fill() throws IOException {
            int r;
            if (this.bStart < this.bEnd || this.empty && this.bStart == this.bEnd) {
                if (this.empty) {
                    this.bStart = 0;
                    this.bEnd = 0;
                }
                r = this.in.read(this.buffer, this.bEnd, 8192 - this.bEnd);
            } else {
                if (this.bStart == this.bEnd) {
                    throw new IllegalStateException();
                }
                r = this.in.read(this.buffer, this.bEnd, this.bStart - this.bEnd);
            }
            if (r <= 0) {
                logger.fine("Could not read data from stream.");
                return false;
            }
            this.empty = false;
            this.bEnd += r;
            if (this.bEnd == 8192) {
                this.bEnd = 0;
            }
            return true;
        }

        public void enable() {
            this.wait = false;
        }

        public int read() throws IOException {
            if (this.wait) {
                return -1;
            }
            if (this.empty && !this.fill()) {
                this.wait = true;
                return -1;
            }
            if (this.buffer[this.bStart] == 10) {
                ++this.bStart;
                if (this.bStart == 8192) {
                    this.bStart = 0;
                }
                if (this.bStart == this.bEnd) {
                    this.empty = true;
                }
                this.wait = true;
                return -1;
            }
            ++this.bStart;
            if (this.bStart == this.bEnd || this.bEnd == 0 && this.bStart == 8192) {
                this.empty = true;
            }
            if (this.bStart == 8192) {
                this.bStart = 0;
                return this.buffer[8191];
            }
            return this.buffer[this.bStart - 1];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.wait) {
                return -1;
            }
            if (this.empty && !this.fill()) {
                this.wait = true;
                return -1;
            }
            for (int r = 0; r < len; ++r) {
                if (this.buffer[this.bStart] == 10) {
                    ++this.bStart;
                    if (this.bStart == 8192) {
                        this.bStart = 0;
                    }
                    if (this.bStart == this.bEnd) {
                        this.empty = true;
                    }
                    this.wait = true;
                    return r;
                }
                b[r + off] = this.buffer[this.bStart];
                ++this.bStart;
                if (this.bStart == this.bEnd || this.bEnd == 0 && this.bStart == 8192) {
                    this.empty = true;
                    if (!this.fill()) {
                        this.wait = true;
                        return r + 1;
                    }
                }
                if (this.bStart != 8192) continue;
                this.bStart = 0;
            }
            return len;
        }
    }
}

