/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class PutOutsideColonyMessage
extends DOMMessage {
    private String unitId;

    public PutOutsideColonyMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public PutOutsideColonyMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        if (unit.getColony() == null) {
            return DOMMessage.clientError("Unit is not in a colony: " + this.unitId);
        }
        return server.getInGameController().putOutsideColony(serverPlayer, unit);
    }

    public Element toXMLElement() {
        return PutOutsideColonyMessage.createMessage(PutOutsideColonyMessage.getXMLElementTagName(), "unit", this.unitId);
    }

    public static String getXMLElementTagName() {
        return "putOutsideColony";
    }
}

