/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DisembarkMessage
extends DOMMessage {
    private String unitId;

    public DisembarkMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public DisembarkMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().disembarkUnit(serverPlayer, unit);
    }

    public Element toXMLElement() {
        return DisembarkMessage.createMessage(DisembarkMessage.getXMLElementTagName(), "unit", this.unitId);
    }

    public static String getXMLElementTagName() {
        return "disembark";
    }
}

