/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.GoalDecider;

public final class GoalDeciders {
    public static GoalDecider getComposedGoalDecider(final GoalDecider ... gds) {
        if (gds.length < 2) {
            throw new IllegalArgumentException("Short GoalDecider list");
        }
        return new GoalDecider(){
            private GoalDecider[] goalDeciders;
            {
                this.goalDeciders = gds;
            }

            public PathNode getGoal() {
                for (int i = 0; i < this.goalDeciders.length; ++i) {
                    PathNode path = this.goalDeciders[i].getGoal();
                    if (path == null) continue;
                    return path;
                }
                return null;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                boolean ret = false;
                for (int i = this.goalDeciders.length - 1; i >= 0; --i) {
                    ret = this.goalDeciders[i].check(u, path);
                }
                return ret;
            }
        };
    }

    public static GoalDecider getOurClosestSettlementGoalDecider() {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private float bestValue = 0.0f;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                float value;
                Location loc = path.getLastNode().getLocation();
                Settlement settlement = loc.getSettlement();
                if (settlement != null && settlement.getOwner().owns(u) && this.bestValue < (value = (settlement.isConnectedPort() ? 2.0f : 1.0f) / (float)(path.getTotalTurns() + 1))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getHighSeasGoalDecider() {
        return new GoalDecider(){
            private PathNode best = null;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode path) {
                if (path.getTile() != null && path.getTile().isDirectlyHighSeasConnected()) {
                    if (this.best == null || path.getCost() < this.best.getCost()) {
                        this.best = path;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getLocationGoalDecider(final Location target) {
        return new GoalDecider(){
            private PathNode best = null;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode path) {
                if (Map.isSameLocation(path.getLocation(), target)) {
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getAdjacentLocationGoalDecider(Location target) {
        final Tile tile = target.getTile();
        if (tile == null) {
            return null;
        }
        return new GoalDecider(){
            private PathNode best = null;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode path) {
                Tile t = path.getTile();
                if (t != null && t.isAdjacent(tile)) {
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
    }
}

