/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;

public class UnitTradeItem
extends TradeItem {
    private Unit unit;

    public UnitTradeItem(Game game, Player source, Player destination, Unit unit) {
        super(game, "tradeItem.unit", source, destination);
        this.unit = unit;
    }

    public UnitTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public boolean isValid() {
        return this.unit.getOwner() == this.getSource() && this.unit.getType().isAvailableTo(this.getDestination());
    }

    public boolean isUnique() {
        return false;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, UnitTradeItem.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("unit", this.unit.getId());
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        super.readFromXML(in);
        String unitId = in.getAttributeValue(null, "unit");
        this.unit = this.game.getFreeColGameObject(unitId, Unit.class);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "unitTradeItem";
    }
}

