/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monarch
extends FreeColGameObject
implements Named {
    private static final Logger logger = Logger.getLogger(Monarch.class.getName());
    public static final int MINIMUM_PRICE = 300;
    public static final int MINIMUM_TAX_RATE = 20;
    private String name;
    private Player player;
    private boolean supportSea = false;
    private boolean displeasure = false;
    private Force expeditionaryForce = new Force();
    private Force interventionForce = new Force();
    private Force mercenaryForce = new Force();

    public Monarch(Game game, Player player, String name) {
        super(game);
        if (player == null) {
            throw new IllegalStateException("player == null");
        }
        this.player = player;
        this.name = name;
        Specification spec = this.getSpecification();
        this.expeditionaryForce = new Force((UnitListOption)spec.getOption("model.option.refSize"), "model.ability.refUnit");
        this.interventionForce = new Force((UnitListOption)spec.getOption("model.option.interventionForce"), null);
    }

    public Monarch(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Monarch(Game game, String id) {
        super(game, id);
    }

    public Force getExpeditionaryForce() {
        return this.expeditionaryForce;
    }

    public Force getInterventionForce() {
        return this.interventionForce;
    }

    public Force getMercenaryForce() {
        return this.interventionForce;
    }

    public boolean getSupportSea() {
        return this.supportSea;
    }

    public void setSupportSea(boolean supportSea) {
        this.supportSea = supportSea;
    }

    public boolean getDispleasure() {
        return this.displeasure;
    }

    public void setDispleasure(boolean displeasure) {
        this.displeasure = displeasure;
    }

    @Override
    public String getNameKey() {
        return this.name;
    }

    private int taxMaximum() {
        return this.getSpecification().getInteger("model.option.maximumTax");
    }

    public List<Player> collectPotentialEnemies() {
        ArrayList<Player> enemies = new ArrayList<Player>();
        if (!this.player.hasAbility("model.ability.ignoreEuropeanWars")) {
            for (Player enemy : this.getGame().getLiveEuropeanPlayers()) {
                if (enemy.isREF()) continue;
                switch (this.player.getStance(enemy)) {
                    case PEACE: 
                    case CEASE_FIRE: {
                        enemies.add(enemy);
                    }
                }
            }
        }
        return enemies;
    }

    public List<Player> collectPotentialFriends() {
        ArrayList<Player> friends = new ArrayList<Player>();
        if (!this.player.hasAbility("model.ability.ignoreEuropeanWars")) {
            for (Player enemy : this.getGame().getLiveEuropeanPlayers()) {
                if (enemy.isREF()) continue;
                switch (this.player.getStance(enemy)) {
                    case CEASE_FIRE: 
                    case WAR: {
                        friends.add(enemy);
                    }
                }
            }
        }
        return friends;
    }

    public boolean actionIsValid(MonarchAction action) {
        switch (action) {
            case NO_ACTION: {
                return true;
            }
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                return this.player.getTax() < this.taxMaximum();
            }
            case FORCE_TAX: {
                return false;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                return this.player.getTax() > 30;
            }
            case WAIVE_TAX: {
                return true;
            }
            case ADD_TO_REF: {
                return true;
            }
            case DECLARE_PEACE: {
                return !this.collectPotentialFriends().isEmpty();
            }
            case DECLARE_WAR: {
                return !this.collectPotentialEnemies().isEmpty();
            }
            case SUPPORT_SEA: {
                return this.player.getAttackedByPrivateers() && !this.getSupportSea() && !this.getDispleasure();
            }
            case SUPPORT_LAND: 
            case OFFER_MERCENARIES: {
                return this.player.isAtWar() && !this.getDispleasure();
            }
            case DISPLEASURE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Bogus monarch action: " + (Object)((Object)action));
    }

    public List<RandomChoice<MonarchAction>> getActionChoices() {
        int grace;
        Specification spec = this.getSpecification();
        ArrayList<RandomChoice<MonarchAction>> choices = new ArrayList<RandomChoice<MonarchAction>>();
        int dx = 1 + spec.getInteger("model.option.monarchMeddling");
        int turn = this.getGame().getTurn().getNumber();
        if (turn < (grace = (6 - dx) * 10) || this.player.getSettlements().size() == 0 || this.player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return choices;
        }
        this.addIfValid(choices, MonarchAction.NO_ACTION, Math.max(200 - turn, 100));
        this.addIfValid(choices, MonarchAction.RAISE_TAX_ACT, 5 + dx);
        this.addIfValid(choices, MonarchAction.RAISE_TAX_WAR, 5 + dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_WAR, 5 - dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_OTHER, 5 - dx);
        this.addIfValid(choices, MonarchAction.ADD_TO_REF, 10 + dx);
        this.addIfValid(choices, MonarchAction.DECLARE_PEACE, 6 - dx);
        this.addIfValid(choices, MonarchAction.DECLARE_WAR, 5 + dx);
        if (this.player.checkGold(300)) {
            this.addIfValid(choices, MonarchAction.OFFER_MERCENARIES, 6 - dx);
        } else if (dx < 3) {
            this.addIfValid(choices, MonarchAction.SUPPORT_LAND, 3 - dx);
        }
        this.addIfValid(choices, MonarchAction.SUPPORT_SEA, 6 - dx);
        return choices;
    }

    private void addIfValid(List<RandomChoice<MonarchAction>> choices, MonarchAction action, int weight) {
        if (this.actionIsValid(action)) {
            choices.add(new RandomChoice<MonarchAction>(action, weight));
        }
    }

    public int raiseTax(Random random) {
        Specification spec = this.getSpecification();
        int taxAdjustment = spec.getInteger("model.option.taxAdjustment");
        int turn = this.getGame().getTurn().getNumber();
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, (6 - taxAdjustment) * 10);
        adjust = 1 + Utils.randomInt(logger, "Tax rise", random, 5 + turn / adjust);
        return Math.min(oldTax + adjust, this.taxMaximum());
    }

    public int lowerTax(Random random) {
        Specification spec = this.getSpecification();
        int taxAdjustment = spec.getInteger("model.option.taxAdjustment");
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, 10 - taxAdjustment);
        adjust = 1 + Utils.randomInt(logger, "Tax reduction", random, adjust);
        return Math.max(oldTax - adjust, 20);
    }

    public AbstractUnit chooseForREF(Random random) {
        AbstractUnit result = null;
        boolean needNaval = this.expeditionaryForce.getCapacity() < this.expeditionaryForce.getSpaceRequired() + 15;
        logger.info("Add to REF: capacity=" + this.expeditionaryForce.getCapacity() + " spaceRequired=" + this.expeditionaryForce.getSpaceRequired() + " => " + (needNaval ? "naval" : "land") + " unit");
        if (needNaval) {
            result = Utils.getRandomMember(logger, "Choose naval", this.expeditionaryForce.getNavalUnits(), random);
            result = result.clone();
            result.setNumber(1);
        } else {
            result = Utils.getRandomMember(logger, "Choose land", this.expeditionaryForce.getLandUnits(), random);
            result = result.clone();
            result.setNumber(Utils.randomInt(logger, "Choose land#", random, 3) + 1);
        }
        return result;
    }

    public void updateInterventionForce() {
        Specification spec = this.getSpecification();
        int interventionTurns = spec.getInteger("model.option.interventionTurns");
        if (interventionTurns > 0) {
            int updates = this.getGame().getTurn().getNumber() / interventionTurns;
            for (AbstractUnit unit : this.interventionForce.getLandUnits()) {
                int value = unit.getNumber() + updates;
                unit.setNumber(value);
            }
            this.interventionForce.updateSpaceAndCapacity();
            while (this.interventionForce.getCapacity() < this.interventionForce.getSpaceRequired()) {
                boolean progress = false;
                for (AbstractUnit ship : this.interventionForce.getNavalUnits()) {
                    if (!ship.getUnitType(spec).canCarryUnits() || ship.getUnitType(spec).getSpace() <= 0) continue;
                    int value = ship.getNumber() + 1;
                    ship.setNumber(value);
                    progress = true;
                }
                if (!progress) break;
                this.interventionForce.updateSpaceAndCapacity();
            }
        }
    }

    public List<AbstractUnit> getSupport(Random random, boolean naval) {
        Specification spec = this.getSpecification();
        ArrayList<AbstractUnit> support = new ArrayList<AbstractUnit>();
        ArrayList<UnitType> navalTypes = new ArrayList<UnitType>();
        ArrayList<UnitType> bombardTypes = new ArrayList<UnitType>();
        ArrayList<UnitType> mountedTypes = new ArrayList<UnitType>();
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (!unitType.hasAbility("model.ability.supportUnit")) continue;
            if (unitType.hasAbility("model.ability.navalUnit")) {
                navalTypes.add(unitType);
                continue;
            }
            if (unitType.hasAbility("model.ability.bombard")) {
                bombardTypes.add(unitType);
                continue;
            }
            if (!unitType.hasAbility("model.ability.canBeEquipped")) continue;
            mountedTypes.add(unitType);
        }
        if (naval) {
            support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose naval support", navalTypes, random), Unit.Role.DEFAULT, 1));
            this.setSupportSea(true);
            return support;
        }
        int difficulty = spec.getInteger("model.option.monarchSupport");
        switch (difficulty) {
            case 4: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose bombard", bombardTypes, random), Unit.Role.DEFAULT, 1));
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 2));
                break;
            }
            case 3: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 2));
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose soldier", mountedTypes, random), Unit.Role.SOLDIER, 1));
                break;
            }
            case 2: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 2));
                break;
            }
            case 1: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 1));
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose soldier", mountedTypes, random), Unit.Role.SOLDIER, 1));
                break;
            }
            case 0: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose soldier", mountedTypes, random), Unit.Role.SOLDIER, 1));
                break;
            }
        }
        return support;
    }

    public List<AbstractUnit> getMercenaries(Random random) {
        Specification spec = this.getSpecification();
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (!unitType.hasAbility("model.ability.mercenaryUnit")) continue;
            unitTypes.add(unitType);
        }
        int mercPrice = spec.getInteger("model.option.mercenaryPrice");
        ArrayList<AbstractUnit> mercs = new ArrayList<AbstractUnit>();
        int price = 0;
        int limit = unitTypes.size();
        UnitType unitType = null;
        for (int count = 0; count < limit; ++count) {
            int newPrice;
            AbstractUnit au;
            int number;
            unitType = (UnitType)Utils.getRandomMember(logger, "Choose unit", unitTypes, random);
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                for (number = 3; number > 0; --number) {
                    au = new AbstractUnit(unitType, Unit.Role.DRAGOON, number);
                    newPrice = this.player.getPrice(au) * mercPrice / 100;
                    if (!this.player.checkGold(price + newPrice)) continue;
                    mercs.add(au);
                    price += newPrice;
                    break;
                }
                for (number = 3; number > 0; --number) {
                    au = new AbstractUnit(unitType, Unit.Role.SOLDIER, number);
                    newPrice = this.player.getPrice(au) * mercPrice / 100;
                    if (!this.player.checkGold(price + newPrice)) continue;
                    mercs.add(au);
                    price += newPrice;
                    break;
                }
            } else {
                for (number = 3; number > 0; --number) {
                    au = new AbstractUnit(unitType, Unit.Role.DEFAULT, number);
                    newPrice = this.player.getPrice(au) * mercPrice / 100;
                    if (!this.player.checkGold(price + newPrice)) continue;
                    mercs.add(au);
                    price += newPrice;
                    break;
                }
            }
            unitTypes.remove(unitType);
        }
        if (mercs.isEmpty() && unitType != null) {
            Unit.Role role = unitType.hasAbility("model.ability.canBeEquipped") ? Unit.Role.SOLDIER : Unit.Role.DEFAULT;
            mercs.add(new AbstractUnit(unitType, role, 1));
        }
        return mercs;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Monarch.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("player", this.player.getId());
        out.writeAttribute("name", this.name);
        out.writeAttribute("supportSea", String.valueOf(this.supportSea));
        out.writeAttribute("displeasure", String.valueOf(this.displeasure));
        this.expeditionaryForce.toXML(out, "expeditionaryForce");
        this.interventionForce.toXML(out, "interventionForce");
        this.mercenaryForce.toXML(out, "mercenaryForce");
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        super.readAttributes(in);
        this.player = game.getFreeColGameObject(in.getAttributeValue(null, "player"), Player.class);
        if (this.player == null) {
            this.player = new Player(game, in.getAttributeValue(null, "player"));
        }
        this.name = this.getAttribute(in, "name", this.player.getNation().getRulerNameKey());
        this.supportSea = this.getAttribute(in, "supportSea", false);
        this.displeasure = this.getAttribute(in, "displeasure", false);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            AbstractUnit newUnit;
            String childName = in.getLocalName();
            if ("expeditionaryForce".equals(childName)) {
                this.expeditionaryForce.readFromXML(in);
                continue;
            }
            if ("interventionForce".equals(childName)) {
                this.interventionForce.readFromXML(in);
                continue;
            }
            if ("mercenaryForce".equals(childName)) {
                this.interventionForce.readFromXML(in);
                continue;
            }
            if ("navalUnits".equals(childName)) {
                this.expeditionaryForce.getNavalUnits().clear();
                while (in.nextTag() != 2) {
                    newUnit = new AbstractUnit(in);
                    this.expeditionaryForce.getNavalUnits().add(newUnit);
                }
                continue;
            }
            if (!"landUnits".equals(childName)) continue;
            this.expeditionaryForce.getLandUnits().clear();
            while (in.nextTag() != 2) {
                newUnit = new AbstractUnit(in);
                this.expeditionaryForce.getLandUnits().add(newUnit);
            }
        }
        if (this.interventionForce.getUnits().isEmpty()) {
            this.interventionForce = new Force((UnitListOption)this.getSpecification().getOption("model.option.interventionForce"), null);
        }
        if (this.mercenaryForce.getUnits().isEmpty()) {
            this.mercenaryForce = new Force((UnitListOption)this.getSpecification().getOption("model.option.mercenaryForce"), null);
        }
        if (!in.getLocalName().equals(Monarch.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Monarch.getXMLElementTagName() + "> found instead: " + in.getLocalName());
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "monarch";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Force {
        private final List<AbstractUnit> landUnits = new ArrayList<AbstractUnit>();
        private final List<AbstractUnit> navalUnits = new ArrayList<AbstractUnit>();
        private int spaceRequired;
        private int capacity;

        public Force() {
        }

        public Force(UnitListOption option, String ability) {
            List units = option.getOptionValues();
            for (AbstractUnit unit : units) {
                UnitType unitType = unit.getUnitType(Monarch.this.getSpecification());
                if (ability == null || unitType.hasAbility(ability)) {
                    if (unitType.hasAbility("model.ability.navalUnit")) {
                        this.navalUnits.add(unit);
                        continue;
                    }
                    this.landUnits.add(unit);
                    continue;
                }
                logger.warning("Found unit lacking required ability \"" + ability + "\": " + unit.toString());
            }
            this.updateSpaceAndCapacity();
        }

        public int getSpaceRequired() {
            return this.spaceRequired;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void updateSpaceAndCapacity() {
            Specification spec = Monarch.this.getSpecification();
            this.capacity = 0;
            for (AbstractUnit nu : this.navalUnits) {
                if (!nu.getUnitType(spec).canCarryUnits()) continue;
                this.capacity += nu.getUnitType(spec).getSpace() * nu.getNumber();
            }
            this.spaceRequired = 0;
            for (AbstractUnit lu : this.landUnits) {
                this.spaceRequired += lu.getUnitType(spec).getSpaceTaken() * lu.getNumber();
            }
        }

        public List<AbstractUnit> getUnits() {
            ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>(this.landUnits);
            result.addAll(this.navalUnits);
            return result;
        }

        public List<AbstractUnit> getNavalUnits() {
            return this.navalUnits;
        }

        public List<AbstractUnit> getLandUnits() {
            return this.landUnits;
        }

        public boolean isEmpty() {
            return this.landUnits.isEmpty() && this.navalUnits.isEmpty();
        }

        public void add(AbstractUnit units) {
            Specification spec = Monarch.this.getSpecification();
            UnitType unitType = units.getUnitType(spec);
            int n = units.getNumber();
            boolean added = false;
            if (unitType.hasAbility("model.ability.navalUnit")) {
                for (AbstractUnit refUnit : this.navalUnits) {
                    if (refUnit.getUnitType(spec) != unitType) continue;
                    refUnit.setNumber(refUnit.getNumber() + n);
                    if (unitType.canCarryUnits()) {
                        this.capacity += unitType.getSpace() * n;
                    }
                    added = true;
                    break;
                }
                if (!added) {
                    this.navalUnits.add(units);
                }
            } else {
                for (AbstractUnit refUnit : this.landUnits) {
                    if (refUnit.getUnitType(spec) != unitType || !refUnit.getRole().equals((Object)units.getRole())) continue;
                    refUnit.setNumber(refUnit.getNumber() + n);
                    this.spaceRequired += unitType.getSpaceTaken() * n;
                    added = true;
                    break;
                }
                if (!added) {
                    this.landUnits.add(units);
                }
            }
            this.updateSpaceAndCapacity();
        }

        public void toXML(XMLStreamWriter out, String tag) throws XMLStreamException {
            out.writeStartElement(tag);
            out.writeStartElement("navalUnits");
            for (AbstractUnit unit : this.navalUnits) {
                unit.toXMLImpl(out);
            }
            out.writeEndElement();
            out.writeStartElement("landUnits");
            for (AbstractUnit unit : this.landUnits) {
                unit.toXMLImpl(out);
            }
            out.writeEndElement();
            out.writeEndElement();
        }

        public void readFromXML(XMLStreamReader in) throws XMLStreamException {
            this.navalUnits.clear();
            this.landUnits.clear();
            while (in.nextTag() != 2) {
                AbstractUnit newUnit;
                String childName = in.getLocalName();
                if ("navalUnits".equals(childName)) {
                    while (in.nextTag() != 2) {
                        newUnit = new AbstractUnit(in);
                        this.navalUnits.add(newUnit);
                    }
                    continue;
                }
                if (!"landUnits".equals(childName)) continue;
                while (in.nextTag() != 2) {
                    newUnit = new AbstractUnit(in);
                    this.landUnits.add(newUnit);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonarchAction {
        NO_ACTION,
        RAISE_TAX_ACT,
        RAISE_TAX_WAR,
        FORCE_TAX,
        LOWER_TAX_WAR,
        LOWER_TAX_OTHER,
        WAIVE_TAX,
        ADD_TO_REF,
        DECLARE_PEACE,
        DECLARE_WAR,
        SUPPORT_LAND,
        SUPPORT_SEA,
        OFFER_MERCENARIES,
        DISPLEASURE;

    }
}

