/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianSettlement
extends Settlement {
    private static final Logger logger = Logger.getLogger(IndianSettlement.class.getName());
    public static final int TALES_RADIUS = 6;
    public static final String CONTACT_LEVEL_TAG_NAME = "contactLevel";
    public static final String OWNED_UNITS_TAG_NAME = "ownedUnits";
    public static final String IS_VISITED_TAG_NAME = "isVisited";
    public static final String ALARM_TAG_NAME = "alarm";
    public static final String MISSIONARY_TAG_NAME = "missionary";
    public static final String WANTED_GOODS_TAG_NAME = "wantedGoods";
    public static final int TRADE_MINIMUM_SIZE = 20;
    public static final int TRADE_MINIMUM_PRICE = 3;
    public static final int GOODS_BASE_PRICE = 12;
    public static final int KEEP_RAW_MATERIAL = 50;
    public static final int GIFT_THRESHOLD = 25;
    public static final int GIFT_MINIMUM = 10;
    public static final int GIFT_MAXIMUM = 80;
    protected UnitType learnableSkill = null;
    protected GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
    protected final Map<Player, ContactLevel> contactLevels = new HashMap<Player, ContactLevel>();
    protected List<Unit> ownedUnits = new ArrayList<Unit>();
    protected Unit missionary = null;
    protected int convertProgress = 0;
    protected int lastTribute = 0;
    protected Player mostHated = null;
    private final Map<Player, Tension> alarm = new HashMap<Player, Tension>();
    private final Comparator<GoodsType> wantedGoodsComparator = new Comparator<GoodsType>(){

        @Override
        public int compare(GoodsType goodsType1, GoodsType goodsType2) {
            return IndianSettlement.this.getNormalGoodsPriceToBuy(goodsType2, 100) - IndianSettlement.this.getNormalGoodsPriceToBuy(goodsType1, 100);
        }
    };
    private final Comparator<Goods> exportGoodsComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods goods1, Goods goods2) {
            GoodsType t1 = goods1.getType();
            GoodsType t2 = goods2.getType();
            int cmp = (t2.isNewWorldGoodsType() ? 1 : 0) - (t1.isNewWorldGoodsType() ? 1 : 0);
            if (cmp == 0) {
                int a1 = Math.min(goods2.getAmount(), 100);
                int a2 = Math.min(goods1.getAmount(), 100);
                cmp = IndianSettlement.this.getPriceToSell(t2, a2) - IndianSettlement.this.getPriceToSell(t1, a1);
                if (cmp == 0) {
                    cmp = a2 - a1;
                }
            }
            return cmp;
        }
    };

    protected IndianSettlement() {
    }

    protected IndianSettlement(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public IndianSettlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public IndianSettlement(Game game, String id) {
        super(game, id);
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        while (this.ownedUnits.size() > 0) {
            this.ownedUnits.remove(0).setIndianSettlement(null);
        }
        return super.disposeList();
    }

    public int getLastTribute() {
        return this.lastTribute;
    }

    public void setLastTribute(int lastTribute) {
        this.lastTribute = lastTribute;
    }

    public UnitType getLearnableSkill() {
        return this.learnableSkill;
    }

    public void setLearnableSkill(UnitType skill) {
        this.learnableSkill = skill;
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public Unit getMissionary(Player player) {
        return this.missionary == null || this.missionary.getOwner() != player ? null : this.missionary;
    }

    public void setMissionary(Unit missionary) {
        this.missionary = missionary;
    }

    public void changeMissionary(Unit missionary) {
        Unit old = this.getMissionary();
        this.setMissionary(missionary);
        this.getTile().updatePlayerExploredTiles();
        if (missionary != null) {
            this.getTile().updatePlayerExploredTile(missionary.getOwner(), true);
        }
        if (old != null) {
            this.getTile().updatePlayerExploredTile(old.getOwner(), true);
        }
        if (old != null && old != missionary) {
            this.getTile().fixMissionary(old);
        }
    }

    public int getConvertProgress() {
        return this.convertProgress;
    }

    public void setConvertProgress(int progress) {
        this.convertProgress = progress;
    }

    public GoodsType[] getWantedGoods() {
        return this.wantedGoods;
    }

    public void setWantedGoods(GoodsType[] wantedGoods) {
        this.wantedGoods = wantedGoods;
    }

    public void setWantedGoods(int index, GoodsType type) {
        if (0 <= index && index < this.wantedGoods.length) {
            this.wantedGoods[index] = type;
        }
    }

    public Player getMostHated() {
        return this.mostHated;
    }

    public void updateMostHated() {
        this.mostHated = null;
        int bestValue = Integer.MIN_VALUE;
        for (Player p : this.getGame().getLiveEuropeanPlayers()) {
            int value;
            Tension alarm = this.getAlarm(p);
            if (alarm == null || alarm.getLevel() == Tension.Level.HAPPY || bestValue >= (value = alarm.getValue())) continue;
            bestValue = value;
            this.mostHated = p;
        }
    }

    public ContactLevel getContactLevel(Player player) {
        ContactLevel cl = this.contactLevels.get(player);
        return cl == null ? ContactLevel.UNCONTACTED : cl;
    }

    public boolean hasContacted(Player player) {
        return this.getContactLevel(player) != ContactLevel.UNCONTACTED;
    }

    public boolean setContacted(Player player) {
        if (!this.hasContacted(player)) {
            this.contactLevels.put(player, ContactLevel.CONTACTED);
            this.initializeAlarm(player);
            return true;
        }
        return false;
    }

    public boolean hasVisited(Player player) {
        return this.getContactLevel(player).ordinal() >= ContactLevel.VISITED.ordinal();
    }

    public boolean setVisited(Player player) {
        if (!this.hasVisited(player)) {
            if (!this.hasContacted(player)) {
                this.initializeAlarm(player);
            }
            this.contactLevels.put(player, ContactLevel.VISITED);
            return true;
        }
        return false;
    }

    public boolean hasScouted(Player player) {
        return this.getContactLevel(player) == ContactLevel.SCOUTED;
    }

    public boolean setScouted(Player player) {
        if (!this.hasScouted(player)) {
            if (!this.hasContacted(player)) {
                this.initializeAlarm(player);
            }
            this.contactLevels.put(player, ContactLevel.SCOUTED);
            return true;
        }
        return false;
    }

    public boolean hasAnyScouted() {
        for (Player p : this.contactLevels.keySet()) {
            if (!this.hasScouted(p)) continue;
            return true;
        }
        return false;
    }

    public Tension getAlarm(Player player) {
        return this.alarm.get(player);
    }

    public void setAlarm(Player player, Tension newAlarm) {
        if (player != null && player != this.owner) {
            this.alarm.put(player, newAlarm);
            this.updateMostHated();
        }
    }

    public void removeAlarm(Player player) {
        if (player != null) {
            this.alarm.remove(player);
            this.updateMostHated();
        }
    }

    private void initializeAlarm(Player player) {
        Tension tension = this.owner.getTension(player);
        this.setAlarm(player, new Tension(tension == null ? 0 : tension.getValue()));
    }

    protected boolean changeAlarm(Player player, int amount) {
        Tension alarm = this.getAlarm(player);
        if (alarm == null) {
            this.initializeAlarm(player);
            alarm = this.getAlarm(player);
        }
        Tension.Level oldLevel = alarm.getLevel();
        alarm.modify(amount);
        this.updateMostHated();
        return oldLevel != alarm.getLevel();
    }

    public String getShortAlarmLevelMessageId(Player player) {
        return !player.hasContacted(this.owner) ? "tension.wary" : (this.hasContacted(player) ? this.getAlarm(player).getKey() : "tension.unknown");
    }

    public String getAlarmLevelMessageId(Player player) {
        Tension alarm = this.hasContacted(player) ? this.getAlarm(player) : new Tension(0);
        return "indianSettlement." + alarm.getKey();
    }

    public boolean allowContact(Unit unit) {
        return unit.getOwner().hasContacted(this.owner) || !unit.isNaval() || unit.hasGoodsCargo();
    }

    public void addOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        if (!this.ownedUnits.contains(unit)) {
            this.ownedUnits.add(unit);
        }
    }

    public List<Unit> getOwnedUnits() {
        return new ArrayList<Unit>(this.ownedUnits);
    }

    public Iterator<Unit> getOwnedUnitsIterator() {
        return this.ownedUnits.iterator();
    }

    public boolean removeOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        return this.ownedUnits.remove(unit);
    }

    @Override
    public boolean add(Locatable locatable) {
        Unit indian;
        boolean result = super.add(locatable);
        if (result && locatable instanceof Unit && (indian = (Unit)locatable).getIndianSettlement() == null) {
            indian.setIndianSettlement(this);
        }
        return result;
    }

    public int getPriceToBuy(Goods goods) {
        return this.getPriceToBuy(goods.getType(), goods.getAmount());
    }

    public int getPriceToBuy(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int price = 0;
        if (type.isMilitaryGoods()) {
            price = this.getMilitaryGoodsPriceToBuy(type, amount);
        }
        if (price == 0) {
            price = this.getNormalGoodsPriceToBuy(type, amount);
        }
        int wantedBase = 100;
        int wantedBonus = type == this.wantedGoods[0] ? 150 : (type == this.wantedGoods[1] ? 125 : (type == this.wantedGoods[2] ? 110 : 100));
        price = wantedBonus * price / 100;
        logger.finest("Full price(" + amount + " " + type + ")" + " -> " + price);
        return price;
    }

    private int getNormalGoodsPriceToBuy(GoodsType type, int amount) {
        int tradeGoodsAdd = 20;
        int capacity = this.getGoodsCapacity();
        int current = this.getGoodsCount(type);
        GoodsType rawType = type.getRawMaterial();
        if (rawType != null) {
            int rawProduction = this.getMaximumProduction(rawType);
            int add = rawProduction < 5 ? 10 * rawProduction : (rawProduction < 10 ? 5 * rawProduction + 25 : (rawProduction < 20 ? 2 * rawProduction + 55 : 100));
            add = add * Math.max(0, capacity - current) / capacity;
            current += add;
        } else if (type.isTradeGoods()) {
            current += 20;
        }
        int retain = Math.min(this.getWantedGoodsAmount(type), capacity);
        int valued = retain <= current ? 0 : Math.min(amount, retain - current);
        int unitPrice = (12 + this.getType().getTradeBonus()) * Math.max(0, capacity - current) / capacity;
        if (type.isFarmed() || type.isRawBuildingMaterial()) {
            unitPrice /= 2;
        }
        int price = unitPrice < 0 ? 0 : valued * unitPrice;
        return price;
    }

    protected int getWantedGoodsAmount(GoodsType type) {
        Specification spec = this.getSpecification();
        if (type.isMilitaryGoods()) {
            int need = 0;
            int toArm = 0;
            if (type == spec.getGoodsType("model.goods.muskets")) {
                for (Unit u : this.ownedUnits) {
                    if (u.isArmed()) continue;
                    ++need;
                }
                toArm = spec.getEquipmentType("model.equipment.indian.muskets").getRequiredAmountOf(type);
            } else if (type == spec.getGoodsType("model.goods.horses")) {
                for (Unit u : this.ownedUnits) {
                    if (u.isMounted()) continue;
                    ++need;
                }
                toArm = spec.getEquipmentType("model.equipment.indian.horses").getRequiredAmountOf(type);
            }
            return need * toArm;
        }
        int consumption = this.getConsumptionOf(type);
        if (type == spec.getPrimaryFoodType()) {
            return Math.max(40, consumption * 3);
        }
        if (type.isTradeGoods() || type.isNewWorldLuxuryType() || type.isRefined()) {
            return Math.max(80, consumption * 20);
        }
        return 2 * this.getUnitCount();
    }

    private int getMilitaryGoodsPriceToBuy(GoodsType type, int amount) {
        int full = 12 + this.getType().getTradeBonus();
        int required = this.getWantedGoodsAmount(type);
        if (required == 0) {
            return 0;
        }
        int valued = Math.max(0, required - this.getGoodsCount(type));
        int price = valued > amount / 2 ? full * amount : valued * full + this.getNormalGoodsPriceToBuy(type, amount - valued);
        logger.finest("Military price(" + amount + " " + type + ")" + " valued=" + valued + " -> " + price);
        return price;
    }

    public int getPriceToSell(Goods goods) {
        return this.getPriceToSell(goods.getType(), goods.getAmount());
    }

    public int getPriceToSell(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int full = 12 + this.getType().getTradeBonus();
        int price = amount + Math.max(0, 11 * this.getPriceToBuy(type, amount) / 10);
        if (type.isMilitaryGoods()) {
            price = Math.max(price, amount * full * 2);
        } else if (type.isTradeGoods()) {
            price = Math.max(price, 150 * amount * full / 100);
        }
        return price;
    }

    public boolean willSell(GoodsType type) {
        return !type.isTradeGoods();
    }

    public List<Goods> getSellGoods(int limit, Unit unit) {
        ArrayList<Goods> result = new ArrayList<Goods>();
        List<Goods> settlementGoods = this.getCompactGoods();
        Collections.sort(settlementGoods, this.exportGoodsComparator);
        int count = 0;
        for (Goods goods : settlementGoods) {
            if (!this.willSell(goods.getType())) continue;
            int amount = goods.getAmount();
            int retain = this.getWantedGoodsAmount(goods.getType());
            if (retain >= amount) continue;
            if ((amount -= retain) > 100) {
                amount = 100;
            }
            if (unit != null) {
                amount = Math.round(FeatureContainer.applyModifierSet(amount, this.getGame().getTurn(), unit.getModifierSet("model.modifier.tradeVolumePenalty")));
            }
            if (amount < 20) continue;
            result.add(new Goods(this.getGame(), this, goods.getType(), amount));
            if (++count < limit) continue;
            break;
        }
        return result;
    }

    public void tradeGoodsWithSettlement(IndianSettlement settlement) {
        GoodsType armsType = this.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType horsesType = this.getSpecification().getGoodsType("model.goods.horses");
        ArrayList<GoodsType> goodsToTrade = new ArrayList<GoodsType>();
        goodsToTrade.add(armsType);
        goodsToTrade.add(horsesType);
        for (GoodsType goods : goodsToTrade) {
            int goodsInStock = this.getGoodsCount(goods);
            if (goodsInStock <= 50) continue;
            int goodsTraded = goodsInStock / 2;
            settlement.addGoods(goods, goodsTraded);
            this.removeGoods(goods, goodsTraded);
        }
    }

    public int getMaximumProduction(GoodsType goodsType) {
        int amount = 0;
        for (Tile workTile : this.getTile().getSurroundingTiles(this.getRadius())) {
            if (workTile.getOwningSettlement() != null && workTile.getOwningSettlement() != this) continue;
            amount += workTile.potential(goodsType, null);
        }
        return amount;
    }

    public void updateWantedGoods() {
        ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>(this.getSpecification().getGoodsTypeList());
        Collections.sort(goodsTypes, this.wantedGoodsComparator);
        int wantedIndex = 0;
        for (GoodsType goodsType : goodsTypes) {
            if (goodsType.isMilitaryGoods() || !goodsType.isStorable()) continue;
            if (this.getNormalGoodsPriceToBuy(goodsType, 100) <= 300 || wantedIndex >= this.wantedGoods.length) break;
            this.wantedGoods[wantedIndex] = goodsType;
            ++wantedIndex;
        }
        while (wantedIndex < this.wantedGoods.length) {
            this.wantedGoods[wantedIndex] = null;
            ++wantedIndex;
        }
    }

    private GoodsType goodsToMake() {
        GoodsType wantGoods = null;
        int wantAmount = -1;
        for (GoodsType g : this.getSpecification().getGoodsTypeList()) {
            int diff;
            GoodsType produced;
            if (!g.isRawMaterial() || (produced = g.getProducedMaterial()) == null || !produced.isStorable() || this.getGoodsCount(g) <= this.getWantedGoodsAmount(g) || (diff = this.getWantedGoodsAmount(produced) - this.getGoodsCount(produced)) <= wantAmount) continue;
            wantGoods = produced;
            wantAmount = diff;
        }
        return wantGoods;
    }

    public Goods getRandomGift(Random random) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsType type : this.getSpecification().getNewWorldGoodsTypeList()) {
            int n = this.getGoodsCount(type) - 50;
            if (n < 25) continue;
            Goods goods = new Goods(this.getGame(), this, type, Math.min(Utils.randomInt(logger, "Gift amount", random, n -= 10) + 10, 80));
            goodsList.add(goods);
        }
        return goodsList.isEmpty() ? null : (Goods)Utils.getRandomMember(logger, "Gift type", goodsList, random);
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.hasContacted(player) ? StringTemplate.name(this.getName()) : StringTemplate.label("indianSettlement.nameUnknown");
    }

    @Override
    public final Colony getColony() {
        return null;
    }

    @Override
    public int getGoodsCapacity() {
        return this.getType().getWarehouseCapacity();
    }

    @Override
    public String getImageKey() {
        return this.getOwner().getNationID() + (this.isCapital() ? ".capital" : ".settlement") + (this.getMissionary() == null ? "" : ".mission") + ".image";
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : this.getUnitList()) {
            float unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = attacker.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        return defender;
    }

    @Override
    public float getDefenceRatio() {
        return (float)this.getUnitCount() * 2.0f / (float)(this.getType().getMinimumSize() + this.getType().getMaximumSize());
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        return this.getType().getPlunderRange(attacker);
    }

    @Override
    public int getSoL() {
        return 0;
    }

    @Override
    public int getUpkeep() {
        return 0;
    }

    @Override
    public boolean propagateAlarm(Player player, int addToAlarm) {
        return this.hasContacted(player) ? this.changeAlarm(player, addToAlarm) : false;
    }

    @Override
    public int getTotalProductionOf(GoodsType type) {
        if (type.isRefined()) {
            if (type != this.goodsToMake()) {
                return 0;
            }
            return this.getUnitCount();
        }
        int potential = 0;
        int tiles = 1;
        for (Tile workTile : this.getOwnedTiles()) {
            if (workTile == this.getTile() || workTile.isOccupied()) continue;
            potential += workTile.potential(type, null);
            ++tiles;
        }
        if (tiles > this.getUnitCount()) {
            potential = (int)((float)potential * ((float)this.getUnitCount() / (float)tiles));
        }
        return potential += this.getTile().potential(type, null);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        PlayerExploredTile pet;
        boolean full = showAll || toSavedGame || player == this.getOwner();
        PlayerExploredTile playerExploredTile = pet = player == null ? null : this.getTile().getPlayerExploredTile(player);
        if (toSavedGame && !showAll) {
            logger.warning("toSavedGame is true, but showAll is false");
        }
        out.writeStartElement(IndianSettlement.getXMLElementTagName());
        super.writeAttributes(out);
        if (full) {
            out.writeAttribute("lastTribute", Integer.toString(this.lastTribute));
            out.writeAttribute("convertProgress", Integer.toString(this.convertProgress));
            this.writeAttribute(out, "learnableSkill", this.learnableSkill);
            for (int i = 0; i < this.wantedGoods.length; ++i) {
                if (this.wantedGoods[i] == null) continue;
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
                out.writeAttribute(tag, this.wantedGoods[i].getId());
            }
            Player hated = this.getMostHated();
            if (hated != null) {
                out.writeAttribute("mostHated", hated.getId());
            }
        } else if (pet != null) {
            this.writeAttribute(out, "learnableSkill", pet.getSkill());
            GoodsType[] wanted = pet.getWantedGoods();
            int j = 0;
            for (int i = 0; i < wanted.length; ++i) {
                if (wanted[i] == null) continue;
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(j);
                out.writeAttribute(tag, wanted[i].getId());
                ++j;
            }
            Player hated = pet.getMostHated();
            if (hated != null) {
                out.writeAttribute("mostHated", hated.getId());
            }
        }
        this.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (showAll || toSavedGame || player == this.getOwner()) {
            for (Player player2 : this.contactLevels.keySet()) {
                out.writeStartElement(CONTACT_LEVEL_TAG_NAME);
                out.writeAttribute("level", this.contactLevels.get(player2).toString().toLowerCase(Locale.US));
                out.writeAttribute("player", player2.getId());
                out.writeEndElement();
            }
            for (Map.Entry entry : this.alarm.entrySet()) {
                out.writeStartElement(ALARM_TAG_NAME);
                out.writeAttribute("player", ((Player)entry.getKey()).getId());
                out.writeAttribute("value", String.valueOf(((Tension)entry.getValue()).getValue()));
                out.writeEndElement();
            }
            if (this.missionary != null) {
                out.writeStartElement(MISSIONARY_TAG_NAME);
                this.missionary.toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            }
            for (Unit unit : this.ownedUnits) {
                out.writeStartElement(OWNED_UNITS_TAG_NAME);
                out.writeAttribute("ID", unit.getId());
                out.writeEndElement();
            }
            super.writeChildren(out, player, showAll, toSavedGame);
        } else {
            PlayerExploredTile pet = this.getTile().getPlayerExploredTile(player);
            if (pet != null) {
                ContactLevel cl = this.contactLevels.get(player);
                if (cl != null) {
                    out.writeStartElement(CONTACT_LEVEL_TAG_NAME);
                    out.writeAttribute("level", cl.toString().toLowerCase(Locale.US));
                    out.writeAttribute("player", player.getId());
                    out.writeEndElement();
                }
                if (this.getAlarm(player) != null) {
                    out.writeStartElement(ALARM_TAG_NAME);
                    out.writeAttribute("player", player.getId());
                    out.writeAttribute("value", String.valueOf(this.getAlarm(player).getValue()));
                    out.writeEndElement();
                }
                if (pet.getMissionary() != null) {
                    out.writeStartElement(MISSIONARY_TAG_NAME);
                    pet.getMissionary().toXML(out, player, showAll, toSavedGame);
                    out.writeEndElement();
                }
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.owner.addSettlement(this);
        this.ownedUnits.clear();
        for (int i = 0; i < this.wantedGoods.length; ++i) {
            String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
            String wantedGoodsId = this.getAttribute(in, tag, null);
            this.wantedGoods[i] = wantedGoodsId == null ? null : this.getSpecification().getGoodsType(wantedGoodsId);
        }
        this.convertProgress = this.getAttribute(in, "convertProgress", 0);
        this.lastTribute = this.getAttribute(in, "lastTribute", 0);
        this.learnableSkill = this.getSpecification().getType(in, "learnableSkill", UnitType.class, null);
        this.mostHated = this.getFreeColGameObject(in, "mostHated", Player.class, null);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.contactLevels.clear();
        this.alarm.clear();
        this.missionary = null;
        this.ownedUnits.clear();
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        String tag = in.getLocalName();
        if (ALARM_TAG_NAME.equals(tag)) {
            Player player = this.getFreeColGameObject(in, "player", Player.class);
            this.setContacted(player);
            this.alarm.put(player, new Tension(this.getAttribute(in, "value", 0)));
            in.nextTag();
        } else if (CONTACT_LEVEL_TAG_NAME.equals(tag)) {
            String levelString = in.getAttributeValue(null, "level");
            ContactLevel cl = Enum.valueOf(ContactLevel.class, levelString.toUpperCase(Locale.US));
            Player player = this.getFreeColGameObject(in, "player", Player.class);
            this.contactLevels.put(player, cl);
            in.nextTag();
        } else if (IS_VISITED_TAG_NAME.equals(tag)) {
            Player player = this.getFreeColGameObject(in, "player", Player.class);
            this.setScouted(player);
            in.nextTag();
        } else if (WANTED_GOODS_TAG_NAME.equals(tag)) {
            String[] wantedGoodsID = this.readFromArrayElement(WANTED_GOODS_TAG_NAME, in, new String[0]);
            for (int i = 0; i < this.wantedGoods.length; ++i) {
                String goodsId = i < wantedGoodsID.length ? wantedGoodsID[i] : null;
                this.wantedGoods[i] = goodsId == null || "".equals(goodsId) ? null : this.getSpecification().getGoodsType(goodsId);
            }
        } else if (MISSIONARY_TAG_NAME.equals(tag)) {
            in.nextTag();
            this.missionary = this.updateFreeColGameObject(in, Unit.class);
            this.missionary.setLocationNoUpdate(this);
            in.nextTag();
        } else if ("units".equals(tag)) {
            while (in.nextTag() != 2) {
                if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                Unit unit = this.updateFreeColGameObject(in, Unit.class);
                if (unit.getLocation() != this) {
                    logger.warning("fixing unit location");
                    unit.setLocation(this);
                }
                this.add(unit);
            }
        } else if (OWNED_UNITS_TAG_NAME.equals(tag)) {
            Unit unit = this.getFreeColGameObject(in, "ID", Unit.class);
            if (unit.getOwner() != null && !this.owner.owns(unit)) {
                logger.warning("Error in savegame: unit " + unit.getId() + " does not belong to settlement " + this.getId());
            } else {
                this.ownedUnits.add(unit);
                this.owner.setUnit(unit);
            }
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        s.append(" at (").append(this.tile.getX());
        s.append(",").append(this.tile.getY()).append(")");
        return s.toString();
    }

    public static String getXMLElementTagName() {
        return "indianSettlement";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContactLevel {
        UNCONTACTED,
        CONTACTED,
        VISITED,
        SCOUTED;

    }
}

