/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeColObject {
    protected static Logger logger = Logger.getLogger(FreeColObject.class.getName());
    public static final int INFINITY = Integer.MAX_VALUE;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    public static final String NO_ID = "NO_ID";
    public static final String ID_ATTRIBUTE = "ID";
    protected static final String VALUE_TAG = "value";
    public static final String ID_ATTRIBUTE_TAG = "id";
    protected static final String ARRAY_SIZE = "xLength";
    protected static final String PARTIAL_ATTRIBUTE = "PARTIAL";
    private String id;
    private Specification specification;
    private PropertyChangeSupport pcs = null;

    public String getId() {
        return this.id;
    }

    protected void setId(String newId) {
        this.id = newId;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    protected void setSpecification(Specification specification) {
        this.specification = specification;
    }

    public void dumpObject() {
        this.save(System.err);
    }

    public void save(File file) throws FileNotFoundException {
        this.save(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream out) {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter xsw = null;
        try {
            xsw = xof.createXMLStreamWriter(out, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            this.toXML(xsw, null, true, true);
            xsw.writeEndDocument();
            xsw.flush();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception writing object.", e);
        }
        finally {
            try {
                if (xsw != null) {
                    xsw.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception closing save stream.", e);
            }
        }
    }

    public Element toXMLElement(Document document) {
        return this.toXMLElement(null, document, true, false);
    }

    public Element toXMLElement(Player player, Document document) {
        return this.toXMLElement(player, document, true, false);
    }

    public Element toXMLElement(Player player, Document document, boolean showAll, boolean toSavedGame) {
        return this.toXMLElement(player, document, showAll, toSavedGame, null);
    }

    public Element toXMLElementPartial(Document document, String ... fields) {
        return this.toXMLElement(null, document, true, false, fields);
    }

    public Element toXMLElement(Player player, Document document, boolean showAll, boolean toSavedGame, String[] fields) {
        try {
            StringWriter sw = new StringWriter();
            XMLOutputFactory xif = XMLOutputFactory.newInstance();
            XMLStreamWriter xsw = xif.createXMLStreamWriter(sw);
            if (fields == null) {
                this.toXML(xsw, player, showAll, toSavedGame);
            } else {
                this.toXMLPartialImpl(xsw, fields);
            }
            xsw.close();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document tempDocument = null;
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                tempDocument = builder.parse(new InputSource(new StringReader(sw.toString())));
                return (Element)document.importNode(tempDocument.getDocumentElement(), true);
            }
            catch (ParserConfigurationException pce) {
                logger.log(Level.WARNING, "ParserConfigurationException", pce);
                throw new IllegalStateException("ParserConfigurationException: " + pce.getMessage());
            }
            catch (SAXException se) {
                logger.log(Level.WARNING, "SAXException", se);
                throw new IllegalStateException("SAXException: " + se.getMessage());
            }
            catch (IOException ie) {
                logger.log(Level.WARNING, "IOException", ie);
                throw new IllegalStateException("IOException: " + ie.getMessage());
            }
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
            throw new IllegalStateException("XMLStreamException: " + e.getMessage());
        }
    }

    public void toXML(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out);
    }

    public void toXML(XMLStreamWriter out, String tag) throws XMLStreamException {
        out.writeStartElement(tag);
        this.writeAttributes(out);
        this.writeChildren(out);
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        if (this.getId() == null) {
            logger.warning("FreeColObject with null id: " + this.toString());
        } else {
            out.writeAttribute(ID_ATTRIBUTE_TAG, this.getId());
        }
    }

    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
    }

    public void toXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        this.toXMLImpl(out);
    }

    protected abstract void toXMLImpl(XMLStreamWriter var1) throws XMLStreamException;

    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        throw new UnsupportedOperationException("Partial update of unsupported type.");
    }

    public void readFromXMLElement(Element element) {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer xmlTransformer = factory.newTransformer();
                StringWriter stringWriter = new StringWriter();
                xmlTransformer.transform(new DOMSource(element), new StreamResult(stringWriter));
                String xml = stringWriter.toString();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(xml));
                xsr.nextTag();
                this.readFromXML(xsr);
            }
            catch (TransformerException e) {
                logger.log(Level.WARNING, "TransformerException", e);
                throw new IllegalStateException("TransformerException");
            }
        }
        catch (XMLStreamException e) {
            logger.log(Level.WARNING, "XMLStreamException", e);
            throw new IllegalStateException("XMLStreamException");
        }
    }

    public void readFromXMLElement(Element element, Specification specification) {
        this.setSpecification(specification);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer xmlTransformer = factory.newTransformer();
                StringWriter stringWriter = new StringWriter();
                xmlTransformer.transform(new DOMSource(element), new StreamResult(stringWriter));
                String xml = stringWriter.toString();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(xml));
                xsr.nextTag();
                this.readFromXML(xsr);
            }
            catch (TransformerException e) {
                logger.log(Level.WARNING, "TransformerException", e);
                throw new IllegalStateException("TransformerException");
            }
        }
        catch (XMLStreamException e) {
            logger.log(Level.WARNING, "XMLStreamException", e);
            throw new IllegalStateException("XMLStreamException");
        }
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        if (in.getAttributeValue(null, PARTIAL_ATTRIBUTE) == null) {
            this.readAttributes(in);
            this.readChildren(in);
        } else {
            this.readFromXMLPartialImpl(in);
        }
    }

    protected int[] readFromArrayElement(String tagName, XMLStreamReader in, int[] arrayType) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            in.nextTag();
        }
        int[] array = new int[Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE))];
        for (int x = 0; x < array.length; ++x) {
            array[x] = Integer.parseInt(in.getAttributeValue(null, "x" + Integer.toString(x)));
        }
        in.nextTag();
        return array;
    }

    protected <T> List<T> readFromListElement(String tagName, XMLStreamReader in, Class<T> type) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            throw new XMLStreamException(tagName + " expected, not:" + in.getLocalName());
        }
        int length = Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE));
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int x = 0; x < length; ++x) {
            try {
                Object object;
                String value = in.getAttributeValue(null, "x" + Integer.toString(x));
                if (value != null) {
                    Constructor<T> c = type.getConstructor(type);
                    object = c.newInstance(value);
                } else {
                    object = null;
                }
                list.add(object);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (in.nextTag() != 2) {
            throw new XMLStreamException(tagName + " end expected, not: " + in.getLocalName());
        }
        return list;
    }

    protected String[] readFromArrayElement(String tagName, XMLStreamReader in, String[] arrayType) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            in.nextTag();
        }
        String[] array = new String[Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE))];
        for (int x = 0; x < array.length; ++x) {
            array[x] = in.getAttributeValue(null, "x" + Integer.toString(x));
        }
        in.nextTag();
        return array;
    }

    public boolean hasAttribute(XMLStreamReader in, String attributeName) {
        String attrib = in.getAttributeValue(null, attributeName);
        return attrib != null;
    }

    public boolean getAttribute(XMLStreamReader in, String attributeName, boolean defaultValue) {
        String attrib = in.getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : Boolean.parseBoolean(attrib);
    }

    public float getAttribute(XMLStreamReader in, String attributeName, float defaultValue) {
        String attrib = in.getAttributeValue(null, attributeName);
        float result = defaultValue;
        if (attrib != null) {
            try {
                result = Float.parseFloat(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning("Attribute '" + attributeName + "' should be a float, not '" + attrib + "'.");
            }
        }
        return result;
    }

    public int getAttribute(XMLStreamReader in, String attributeName, int defaultValue) {
        String attrib = in.getAttributeValue(null, attributeName);
        int result = defaultValue;
        if (attrib != null) {
            try {
                result = Integer.parseInt(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning("Attribute '" + attributeName + "' should be an integer, not '" + attrib + "'.");
            }
        }
        return result;
    }

    public String getAttribute(XMLStreamReader in, String attributeName, String defaultValue) {
        String attrib = in.getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : attrib;
    }

    public <T extends Enum<T>> T getAttribute(XMLStreamReader in, String attributeName, Class<T> returnType, T defaultValue) {
        String attrib = in.getAttributeValue(null, attributeName);
        T result = defaultValue;
        if (attrib != null) {
            try {
                result = Enum.valueOf(returnType, attrib.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                logger.warning("Attribute '" + attributeName + "' should be a " + defaultValue.getClass().getName() + " value, not '" + attrib + "'.");
            }
        }
        return result;
    }

    public <T extends FreeColGameObject> T getAttribute(XMLStreamReader in, String attributeName, Game game, Class<T> returnType, T defaultValue) {
        String attrib = in.getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : game.getFreeColGameObject(attrib, returnType);
    }

    public Location getLocationAttribute(XMLStreamReader in, String attributeName, Game game) {
        String attrib = in.getAttributeValue(null, attributeName);
        return attrib == null ? null : game.getFreeColLocation(attrib);
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, boolean value) throws XMLStreamException {
        out.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, float value) throws XMLStreamException {
        out.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, int value) throws XMLStreamException {
        out.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, Enum<?> value) throws XMLStreamException {
        out.writeAttribute(attributeName, value.toString().toLowerCase(Locale.US));
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, Object value) throws XMLStreamException {
        out.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, FreeColObject value) throws XMLStreamException {
        if (value != null) {
            out.writeAttribute(attributeName, value.getId());
        }
    }

    public void writeLocationAttribute(XMLStreamWriter out, String attributeName, Location value) throws XMLStreamException {
        if (value != null) {
            out.writeAttribute(attributeName, ((FreeColGameObject)((Object)value)).getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String newId = in.getAttributeValue(null, ID_ATTRIBUTE_TAG);
        if (newId == null) {
            this.setId(in.getAttributeValue(null, ID_ATTRIBUTE));
        } else {
            this.setId(newId);
        }
    }

    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        throw new XMLStreamException("Unexpected tag: " + in.getLocalName());
    }

    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        throw new UnsupportedOperationException("Partial update of unsupported type");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.pcs == null) {
            return new PropertyChangeListener[0];
        }
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.pcs == null) {
            return new PropertyChangeListener[0];
        }
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        if (this.pcs == null) {
            return false;
        }
        return this.pcs.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyName, listener);
        }
    }

    public FeatureContainer getFeatureContainer() {
        return null;
    }

    public final boolean hasAbility(String id) {
        return this.hasAbility(id, null);
    }

    public final boolean hasAbility(String id, FreeColGameObjectType fcgot) {
        return this.hasAbility(id, fcgot, null);
    }

    public boolean hasAbility(String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.hasAbility(this.getFeatureContainer(), id, fcgot, turn);
    }

    public boolean containsAbilityKey(String key) {
        return FeatureContainer.containsAbilityKey(this.getFeatureContainer(), key);
    }

    public Set<Ability> getAbilities() {
        return FeatureContainer.getAbilities(this.getFeatureContainer());
    }

    public final Set<Ability> getAbilitySet(String id) {
        return this.getAbilitySet(id, null);
    }

    public final Set<Ability> getAbilitySet(String id, FreeColGameObjectType fcgot) {
        return this.getAbilitySet(id, fcgot, null);
    }

    public Set<Ability> getAbilitySet(String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.getAbilitySet(this.getFeatureContainer(), id, fcgot, turn);
    }

    public boolean addAbility(Ability ability) {
        return FeatureContainer.addAbility(this.getFeatureContainer(), ability);
    }

    public Ability removeAbility(Ability ability) {
        return FeatureContainer.removeAbility(this.getFeatureContainer(), ability);
    }

    public void removeAbilities(String id) {
        FeatureContainer.removeAbilities(this.getFeatureContainer(), id);
    }

    public final boolean containsModifierKey(String key) {
        Set<Modifier> set = this.getModifierSet(key);
        return set == null ? false : !set.isEmpty();
    }

    public final Set<Modifier> getModifiers() {
        return FeatureContainer.getModifiers(this.getFeatureContainer());
    }

    public final Set<Modifier> getModifierSet(String id) {
        return this.getModifierSet(id, null);
    }

    public final Set<Modifier> getModifierSet(String id, FreeColGameObjectType fcgot) {
        return this.getModifierSet(id, fcgot, null);
    }

    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.getModifierSet(this.getFeatureContainer(), id, fcgot, turn);
    }

    public final float applyModifier(float number, String id) {
        return this.applyModifier(number, id, null);
    }

    public final float applyModifier(float number, String id, FreeColGameObjectType fcgot) {
        return this.applyModifier(number, id, fcgot, null);
    }

    public final float applyModifier(float number, String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.applyModifierSet(number, turn, this.getModifierSet(id, fcgot, turn));
    }

    public boolean addModifier(Modifier modifier) {
        return FeatureContainer.addModifier(this.getFeatureContainer(), modifier);
    }

    public Modifier removeModifier(Modifier modifier) {
        return FeatureContainer.removeModifier(this.getFeatureContainer(), modifier);
    }

    public void removeModifiers(String id) {
        FeatureContainer.removeModifiers(this.getFeatureContainer(), id);
    }

    public void addFeatures(FreeColObject fco) {
        FeatureContainer.addFeatures(this.getFeatureContainer(), fco);
    }

    public void removeFeatures(FreeColObject fco) {
        FeatureContainer.removeFeatures(this.getFeatureContainer(), fco);
    }

    public static String getXMLElementTagName() {
        return null;
    }
}

