/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeColGameObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColGameObject.class.getName());
    public static final String UNITS_TAG_NAME = "units";
    private Game game;
    private boolean disposed = false;
    private boolean uninitialized;

    protected FreeColGameObject() {
        logger.info("FreeColGameObject without ID created.");
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game) {
        this.game = game;
        if (game != null && game instanceof Game) {
            this.setDefaultId(game);
        } else if (this instanceof Game) {
            this.setId("0");
        } else {
            logger.warning("Created 'FreeColGameObject' with 'game == null':" + this.getId());
        }
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game, XMLStreamReader in) throws XMLStreamException {
        this.game = game;
        if (game == null && !(this instanceof Game)) {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game, Element e) {
        this.game = game;
        if (game == null && !(this instanceof Game)) {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game, String id) {
        this.game = game;
        if (game == null && !(this instanceof Game)) {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.setId(id);
        this.uninitialized = true;
    }

    protected void setDefaultId(Game game) {
        this.setId(this.getRealXMLElementTagName() + ":" + game.getNextID());
    }

    public Game getGame() {
        return this.game;
    }

    @Override
    public Specification getSpecification() {
        if (this.game == null) {
            return null;
        }
        return this.game.getSpecification();
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void fundamentalDispose() {
        this.disposed = true;
        this.getGame().removeFreeColGameObject(this.getId());
    }

    public List<FreeColGameObject> disposeList() {
        this.fundamentalDispose();
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        objects.add(this);
        return objects;
    }

    public void dispose() {
        this.disposeList();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public Integer getIntegerID() {
        String stringPart = this.getRealXMLElementTagName() + ":";
        return new Integer(this.getId().substring(stringPart.length()));
    }

    @Override
    public final void setId(String newID) {
        if (this.game != null && !(this instanceof Game)) {
            if (!newID.equals(this.getId())) {
                if (this.getId() != null) {
                    this.game.removeFreeColGameObject(this.getId());
                }
                super.setId(newID);
                this.game.setFreeColGameObject(newID, this);
            }
        } else {
            super.setId(newID);
        }
    }

    public boolean equals(FreeColGameObject o) {
        if (o != null) {
            return Utils.equals(this.getGame(), o.getGame()) && this.getId().equals(o.getId());
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof FreeColGameObject ? this.equals((FreeColGameObject)o) : false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public <T extends FreeColGameObject> T getAttribute(XMLStreamReader in, String attributeName, Class<T> returnType, T defaultValue) {
        return this.getAttribute(in, attributeName, this.getGame(), returnType, defaultValue);
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(XMLStreamReader in, String attributeName, Class<T> returnClass) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString == null) {
            return null;
        }
        FreeColGameObject returnValue = (FreeColGameObject)returnClass.cast(this.getGame().getFreeColGameObject(attributeString));
        try {
            if (returnValue == null) {
                Constructor<T> c = returnClass.getConstructor(Game.class, String.class);
                returnValue = (FreeColGameObject)returnClass.cast(c.newInstance(this.getGame(), attributeString));
            }
            return (T)returnValue;
        }
        catch (Exception e) {
            logger.warning("Failed to create FreeColGameObject with ID " + attributeString);
            return null;
        }
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(XMLStreamReader in, String attributeName, Class<T> returnClass, T defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return (T)((FreeColGameObject)returnClass.cast(this.getGame().getFreeColGameObject(attributeString)));
        }
        return defaultValue;
    }

    public <T extends FreeColGameObject> T updateFreeColGameObject(XMLStreamReader in, Class<T> returnClass) {
        String idString = in.getAttributeValue(null, "ID");
        if (idString == null) {
            idString = in.getAttributeValue(null, "id");
        }
        if (idString == null) {
            return null;
        }
        FreeColGameObject fcgo = this.getGame().getFreeColGameObject(idString);
        FreeColGameObject returnValue = fcgo == null ? null : (FreeColGameObject)returnClass.cast(fcgo);
        try {
            if (returnValue == null) {
                Constructor<T> c = returnClass.getConstructor(Game.class, XMLStreamReader.class);
                returnValue = (FreeColGameObject)returnClass.cast(c.newInstance(this.getGame(), in));
            } else {
                returnValue.readFromXML(in);
            }
            return (T)returnValue;
        }
        catch (Exception e) {
            logger.warning("Failed to update FreeColGameObject with ID " + idString);
            e.printStackTrace();
            return null;
        }
    }

    protected Location newLocation(String locationString) {
        Location destination = null;
        if (locationString != null) {
            FreeColGameObject fcgo = this.game.getFreeColGameObject(locationString);
            if (fcgo instanceof Location) {
                destination = (Location)((Object)fcgo);
            } else {
                String XMLElementTag = locationString.substring(0, locationString.indexOf(58));
                if (XMLElementTag.equals(Tile.getXMLElementTagName())) {
                    return new Tile(this.game, locationString);
                }
                if (XMLElementTag.equals(ColonyTile.getXMLElementTagName())) {
                    return new ColonyTile(this.game, locationString);
                }
                if (XMLElementTag.equals(Colony.getXMLElementTagName())) {
                    return new Colony(this.game, locationString);
                }
                if (XMLElementTag.equals(IndianSettlement.getXMLElementTagName())) {
                    return new IndianSettlement(this.game, locationString);
                }
                if (XMLElementTag.equals(Europe.getXMLElementTagName())) {
                    return new Europe(this.game, locationString);
                }
                if (XMLElementTag.equals(Building.getXMLElementTagName())) {
                    return new Building(this.game, locationString);
                }
                if (XMLElementTag.equals(Unit.getXMLElementTagName())) {
                    return new Unit(this.game, locationString);
                }
                if (XMLElementTag.equals(HighSeas.getXMLElementTagName())) {
                    return new HighSeas(this.game, locationString);
                }
                if (XMLElementTag.equals(Map.getXMLElementTagName())) {
                    return new Map(this.game, locationString);
                }
                if (!XMLElementTag.equals("newWorld")) {
                    logger.warning("Unknown type of Location: " + locationString);
                    return new Tile(this.game, locationString);
                }
            }
        }
        return destination;
    }

    @Override
    public final void toXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (toSavedGame && !showAll) {
            throw new IllegalArgumentException("'showAll' should be true when saving a game.");
        }
        this.toXMLImpl(out, player, showAll, toSavedGame);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out, null, false, false);
    }

    protected abstract void toXMLImpl(XMLStreamWriter var1, Player var2, boolean var3, boolean var4) throws XMLStreamException;

    @Override
    public final void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.uninitialized = false;
        super.readFromXML(in);
    }

    private String getRealXMLElementTagName() {
        String tagName = "";
        try {
            Method m = this.getClass().getMethod("getXMLElementTagName", null);
            tagName = (String)m.invoke((Object)null, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tagName;
    }

    protected void toXMLPartialByClass(XMLStreamWriter out, Class<?> theClass, String[] fields) throws XMLStreamException {
        try {
            Introspector tag = new Introspector(theClass, "XMLElementTagName");
            out.writeStartElement(tag.getter(this));
        }
        catch (IllegalArgumentException e) {
            logger.warning("Could not get tag field: " + e.toString());
        }
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("PARTIAL", String.valueOf(true));
        for (int i = 0; i < fields.length; ++i) {
            try {
                Introspector intro = new Introspector(theClass, fields[i]);
                out.writeAttribute(fields[i], intro.getter(this));
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.warning("Could not get field " + fields[i] + ": " + e.toString());
            }
        }
        out.writeEndElement();
    }

    public void readFromXMLPartialByClass(XMLStreamReader in, Class<?> theClass) throws XMLStreamException {
        int n = in.getAttributeCount();
        this.setId(in.getAttributeValue(null, "ID"));
        for (int i = 0; i < n; ++i) {
            String name = in.getAttributeLocalName(i);
            if (name.equals("ID") || name.equals("PARTIAL")) continue;
            try {
                Introspector intro = new Introspector(theClass, name);
                intro.setter(this, in.getAttributeValue(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.warning("Could not set field " + name + ": " + e.toString());
            }
        }
        while (in.nextTag() != 2) {
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getId() + " (super's hash code: " + Integer.toHexString(super.hashCode()) + ")";
    }

    public static String getXMLElementTagName() {
        return "unknown";
    }
}

