/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildableType
extends FreeColGameObjectType {
    private static final int DEFAULT_REQUIRED_POPULATION = 1;
    private int requiredPopulation = 1;
    private Map<String, Boolean> requiredAbilities = null;
    private List<AbstractGoods> requiredGoods = null;
    private List<Limit> limits = null;
    private static final String REQUIRED_ABILITY_TAG = "required-ability";
    private static final String REQUIRED_GOODS_TAG = "required-goods";
    public static final String REQUIRED_POPULATION_TAG = "required-population";

    public BuildableType(String id, Specification specification) {
        super(id, specification);
    }

    public int getRequiredPopulation() {
        return this.requiredPopulation;
    }

    public void setRequiredPopulation(int newPopulation) {
        this.requiredPopulation = newPopulation;
    }

    public Map<String, Boolean> getRequiredAbilities() {
        return this.requiredAbilities != null ? this.requiredAbilities : new HashMap<String, Boolean>();
    }

    public void setRequiredAbilities(Map<String, Boolean> abilities) {
        this.requiredAbilities = abilities;
    }

    public boolean isAvailableTo(Player player) {
        if (this.requiredAbilities != null) {
            for (Map.Entry<String, Boolean> entry : this.requiredAbilities.entrySet()) {
                if (player.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public List<AbstractGoods> getRequiredGoods() {
        return this.requiredGoods != null ? this.requiredGoods : new ArrayList<AbstractGoods>();
    }

    public int getRequiredAmountOf(GoodsType type) {
        for (AbstractGoods goods : this.getRequiredGoods()) {
            if (goods.getType() != type) continue;
            return goods.getAmount();
        }
        return 0;
    }

    public void setRequiredGoods(List<AbstractGoods> newGoods) {
        this.requiredGoods = newGoods;
    }

    public boolean needsGoodsToBuild() {
        return this.requiredGoods != null && !this.requiredGoods.isEmpty();
    }

    public List<Limit> getLimits() {
        return this.limits != null ? this.limits : new ArrayList<Limit>();
    }

    public void setLimits(List<Limit> newLimits) {
        this.limits = newLimits;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.requiredPopulation > 1) {
            this.writeAttribute(out, REQUIRED_POPULATION_TAG, this.requiredPopulation);
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.requiredAbilities != null) {
            for (Map.Entry entry : this.requiredAbilities.entrySet()) {
                out.writeStartElement(REQUIRED_ABILITY_TAG);
                this.writeAttribute(out, "id", entry.getKey());
                this.writeAttribute(out, "value", entry.getValue());
                out.writeEndElement();
            }
        }
        for (AbstractGoods abstractGoods : this.getRequiredGoods()) {
            out.writeStartElement(REQUIRED_GOODS_TAG);
            this.writeAttribute(out, "id", abstractGoods.getType());
            this.writeAttribute(out, "value", abstractGoods.getAmount());
            out.writeEndElement();
        }
        for (Limit limit : this.getLimits()) {
            limit.toXMLImpl(out);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.requiredPopulation = this.getAttribute(in, REQUIRED_POPULATION_TAG, 1);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        if (this.readShouldClearContainers(in)) {
            this.requiredAbilities = null;
            this.requiredGoods = null;
            this.limits = null;
        }
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = in.getLocalName();
        if (REQUIRED_ABILITY_TAG.equals(tag)) {
            String str = this.getAttribute(in, "id", null);
            if (str != null) {
                if (this.requiredAbilities == null) {
                    this.requiredAbilities = new HashMap<String, Boolean>();
                }
                this.requiredAbilities.put(str, this.getAttribute(in, "value", true));
                spec.addAbility(str);
            }
            in.nextTag();
        } else if (REQUIRED_GOODS_TAG.equals(tag)) {
            GoodsType type = spec.getType(in, "id", GoodsType.class, null);
            int amount = this.getAttribute(in, "value", 0);
            if (type != null && amount > 0) {
                AbstractGoods ag = new AbstractGoods(type, amount);
                type.setBuildingMaterial(true);
                if (this.requiredGoods == null) {
                    this.requiredGoods = new ArrayList<AbstractGoods>();
                }
                this.requiredGoods.add(ag);
            }
            in.nextTag();
        } else if (Limit.getXMLElementTagName().equals(tag)) {
            Limit limit = new Limit(spec);
            limit.readFromXML(in);
            if (limit.getLeftHandSide().getType() == null) {
                limit.getLeftHandSide().setType(this.getId());
            }
            if (this.limits == null) {
                this.limits = new ArrayList<Limit>();
            }
            this.limits.add(limit);
        } else {
            super.readChild(in);
        }
    }
}

