/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public class WorkProductionPanel
extends FreeColPanel {
    private final Turn turn = this.getGame().getTurn();
    private static final Border border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2));

    public WorkProductionPanel(FreeColClient freeColClient, GUI gui, Unit unit) {
        super(freeColClient, gui);
        GoodsType goodsType;
        this.setLayout((LayoutManager)new MigLayout("wrap 3, insets 10 10 10 10", "[]30:push[right][]", ""));
        Colony colony = unit.getColony();
        UnitType unitType = unit.getType();
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        ArrayList<Modifier> moreModifiers = new ArrayList<Modifier>();
        if (unit.getLocation() instanceof ColonyTile) {
            ColonyTile colonyTile = (ColonyTile)unit.getLocation();
            List<Modifier> tileModifiers = colonyTile.getProductionModifiers(goodsType = unit.getWorkType(), unitType);
            if (FeatureContainer.applyModifiers(0.0f, this.turn, tileModifiers) > 0.0f) {
                modifiers.addAll(tileModifiers);
            }
            this.add((Component)this.localizedLabel(colonyTile.getLabel()), "span, align center, wrap 30");
            Tile tile = colonyTile.getWorkTile();
            TileType tileType = tile.getType();
            ImageLibrary lib = this.getGUI().getImageLibrary();
            Image terrain = lib.getTerrainImage(tileType, tile.getX(), tile.getY());
            BufferedImage image = new BufferedImage(terrain.getWidth(null), terrain.getHeight(null), 2);
            this.getGUI().displayColonyTile((Graphics2D)image.getGraphics(), colonyTile.getWorkTile(), colony);
            this.add(new JLabel(new ImageIcon(image)));
        } else if (unit.getLocation() instanceof Building) {
            Building building = (Building)unit.getLocation();
            goodsType = building.getGoodsOutputType();
            modifiers.addAll(building.getProductionModifiers(goodsType, unitType));
            moreModifiers.addAll(building.getProductionModifiers(goodsType, null));
            this.add((Component)this.localizedLabel(building.getNameKey()), "span, align center, wrap 30");
            this.add(new JLabel(ResourceManager.getImageIcon(building.getType().getId() + ".image")));
        }
        this.add((Component)new UnitLabel(this.getFreeColClient(), unit, this.getGUI(), false, false), "wrap");
        Collections.sort(modifiers);
        float result = 0.0f;
        for (Modifier modifier : modifiers) {
            JLabel[] mLabels = WorkProductionPanel.getModifierLabels(modifier, unitType, this.turn);
            for (int i = 0; i < mLabels.length; ++i) {
                if (mLabels[i] == null) continue;
                if (i == 0) {
                    this.add((Component)mLabels[i], "newline");
                    continue;
                }
                this.add(mLabels[i]);
            }
            result = modifier.applyTo(result, this.turn);
        }
        if (result < 0.0f) {
            this.add((Component)new JLabel(Messages.message("model.source.zeroThreshold.name")), "newline");
            this.add((Component)new JLabel(WorkProductionPanel.getModifierFormat().format(-result)), "wrap 30");
            result = 0.0f;
        }
        Font bigFont = this.getFont().deriveFont(1, 16.0f);
        JLabel finalLabel = new JLabel(Messages.message("model.source.finalResult.name"));
        finalLabel.setFont(bigFont);
        this.add((Component)finalLabel, "newline");
        JLabel finalResult = new JLabel(WorkProductionPanel.getModifierFormat().format(result));
        finalResult.setFont(bigFont);
        finalResult.setBorder(border);
        this.add((Component)finalResult, "wrap 30");
        Collections.sort(moreModifiers);
        for (Modifier modifier : moreModifiers) {
            JLabel[] mLabels = WorkProductionPanel.getModifierLabels(modifier, null, this.turn);
            for (int i = 0; i < mLabels.length; ++i) {
                if (mLabels[i] == null) continue;
                if (i == 0) {
                    this.add((Component)mLabels[i], "newline");
                    continue;
                }
                this.add(mLabels[i]);
            }
        }
        this.add((Component)this.okButton, "span, tag ok");
        this.setSize(this.getPreferredSize());
    }
}

