/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportLabourPanel
extends ReportPanel {
    private Map<UnitType, Map<Location, Integer>> data;
    private TypeCountMap<UnitType> unitCount;
    private List<Colony> colonies = this.getSortedColonies();

    public ReportLabourPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportLabourAction.name"));
        this.gatherData();
        this.displayData();
    }

    public void gatherData() {
        this.data = new HashMap<UnitType, Map<Location, Integer>>();
        this.unitCount = new TypeCountMap();
        for (Unit unit : this.getMyPlayer().getUnits()) {
            Location location;
            UnitType type = unit.getType();
            this.unitCount.incrementCount(type, 1);
            Map<Location, Integer> unitMap = this.data.get(type);
            if (unitMap == null) {
                unitMap = new HashMap<Location, Integer>();
                this.data.put(type, unitMap);
            }
            if ((location = unit.getLocation()) == null) {
                logger.warning("Unit has null location: " + unit.toString());
            } else if (location.getSettlement() != null) {
                location = location.getSettlement();
            } else if (unit.isInEurope()) {
                location = this.getMyPlayer().getEurope();
            } else if (location.getTile() != null) {
                location = location.getTile();
            }
            Integer count = unitMap.get(location);
            if (count == null) {
                unitMap.put(location, 1);
                continue;
            }
            unitMap.put(location, count + 1);
        }
    }

    public void displayData() {
        List<UnitType> unitTypes = this.getSpecification().getUnitTypeList();
        ArrayList<UnitType> colonists = new ArrayList<UnitType>();
        for (UnitType unitType : unitTypes) {
            if (!unitType.hasSkill()) continue;
            colonists.add(unitType);
        }
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 9", "[]10[]10[]30[]10[]10[]30[]10[]10[]", ""));
        for (UnitType unitType : colonists) {
            JLabel unitCount;
            JLabel unitIcon;
            if (!unitType.isAvailableTo(this.getMyPlayer())) continue;
            Unit.Role role = Unit.Role.DEFAULT;
            if (unitType.hasAbility("model.ability.expertPioneer")) {
                role = Unit.Role.PIONEER;
            } else if (unitType.hasAbility("model.ability.expertMissionary")) {
                role = Unit.Role.MISSIONARY;
            }
            int unitTypeCount = this.unitCount.getCount(unitType);
            if (unitTypeCount == 0) {
                unitIcon = new JLabel(this.getLibrary().getUnitImageIcon(unitType, role, true, 0.8));
                unitCount = new JLabel("0");
                JLabel unitName = this.localizedLabel(unitType.getNameKey());
                unitCount.setForeground(Color.GRAY);
                unitName.setForeground(Color.GRAY);
                this.reportPanel.add(unitIcon);
                this.reportPanel.add(unitCount);
                this.reportPanel.add(unitName);
                continue;
            }
            unitIcon = new JLabel(this.getLibrary().getUnitImageIcon(unitType, role, false, 0.8));
            unitCount = new JLabel("" + unitTypeCount);
            JButton linkButton = ReportLabourPanel.getLinkButton(Messages.message(unitType.getNameKey()), null, unitType.getId());
            linkButton.addActionListener(this);
            this.reportPanel.add(unitIcon);
            this.reportPanel.add(unitCount);
            this.reportPanel.add(linkButton);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(event);
        } else {
            UnitType unitType = this.getSpecification().getUnitType(command);
            this.getGUI().showReportLabourDetailPanel(unitType, this.data, this.unitCount, this.colonies);
        }
    }
}

