/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.resources.ResourceManager;

public final class ReportContinentalCongressPanel
extends ReportPanel {
    static final String title = Messages.message("reportCongressAction.name");
    static final String none = Messages.message("report.continentalCongress.none");

    public ReportContinentalCongressPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, title);
        JPanel panel;
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.setOpaque(false);
        Player player = this.getMyPlayer();
        JPanel recruitingPanel = new JPanel((LayoutManager)new MigLayout("center, wrap 1", "center"));
        if (player.getCurrentFather() == null) {
            recruitingPanel.add((Component)new JLabel(none), "wrap 20");
        } else {
            FoundingFather father = player.getCurrentFather();
            String name = Messages.message(father.getNameKey());
            JButton button = ReportContinentalCongressPanel.getLinkButton(name, null, father.getId());
            button.addActionListener(this);
            recruitingPanel.add(button);
            JLabel currentFatherLabel = new JLabel(new ImageIcon(this.getLibrary().getFoundingFatherImage(father)));
            currentFatherLabel.setToolTipText(Messages.message(father.getDescriptionKey()));
            recruitingPanel.add(currentFatherLabel);
            GoodsType bellsType = this.getSpecification().getGoodsType("model.goods.bells");
            FreeColProgressBar progressBar = new FreeColProgressBar(this.getGUI(), bellsType);
            int total = 0;
            for (Colony colony : player.getColonies()) {
                total += colony.getNetProductionOf(bellsType);
            }
            int bells = player.getLiberty();
            int required = player.getTotalFoundingFatherCost();
            progressBar.update(0, required, bells, total);
            recruitingPanel.add((Component)progressBar, "wrap 20");
        }
        tabs.addTab(Messages.message("report.continentalCongress.recruiting"), null, recruitingPanel, null);
        EnumMap<FoundingFather.FoundingFatherType, JPanel> panels = new EnumMap<FoundingFather.FoundingFatherType, JPanel>(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            panel = new JPanel((LayoutManager)new MigLayout("flowy", "[center]"));
            panels.put(type, panel);
            JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
            tabs.addTab(Messages.message(FoundingFather.getTypeKey(type)), null, scrollPane, null);
        }
        Map<String, Turn> electionTurns = this.getElectionTurns();
        for (FoundingFather father : this.getSpecification().getFoundingFathers()) {
            Image image;
            String name = Messages.message(father.getNameKey());
            panel = (JPanel)panels.get((Object)father.getType());
            Turn turn = null;
            if (player.hasFather(father)) {
                image = this.getLibrary().getFoundingFatherImage(father);
                turn = electionTurns.get(name);
            } else {
                image = ResourceManager.getGrayscaleImage(father.getId() + ".image", 1.0);
            }
            panel.add((Component)new JLabel(new ImageIcon(image)), "newline");
            JButton button = ReportContinentalCongressPanel.getLinkButton(name, null, father.getId());
            button.addActionListener(this);
            panel.add(button);
            if (turn == null) continue;
            panel.add(this.localizedLabel("report.continentalCongress.elected"));
            panel.add(this.localizedLabel(turn.getLabel()));
        }
        this.setMainComponent(tabs);
    }
}

