/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;

public class RebelToolTip
extends JToolTip {
    public RebelToolTip(FreeColClient freeColClient, GUI gui, Colony colony) {
        Specification spec = colony.getSpecification();
        int population = colony.getUnitCount();
        int solPercent = colony.getSoL();
        int rebels = Colony.calculateRebels(population, solPercent);
        this.setLayout((LayoutManager)new MigLayout("fillx, wrap 3", "[][right][right]", ""));
        StringTemplate t = StringTemplate.template("colonyPanel.rebelLabel").addName("%number%", "");
        this.add(new JLabel(Messages.message(t)));
        this.add(new JLabel(Integer.toString(rebels)));
        this.add(new JLabel(solPercent + "%"));
        t = StringTemplate.template("colonyPanel.royalistLabel").addName("%number%", "");
        this.add(new JLabel(Messages.message(t)));
        this.add(new JLabel(Integer.toString(population - rebels)));
        this.add(new JLabel(colony.getTory() + "%"));
        int libertyProduction = 0;
        for (GoodsType goodsType : spec.getLibertyGoodsTypeList()) {
            this.add(new JLabel(Messages.message(goodsType.getNameKey())));
            int production = colony.getNetProductionOf(goodsType);
            libertyProduction += production;
            this.add((Component)new ProductionLabel(freeColClient, gui, goodsType, production), "span 2");
        }
        int liberty = colony.getLiberty();
        int modulo = liberty % 200;
        int width = (int)this.getPreferredSize().getWidth() - 32;
        FreeColProgressBar progress = new FreeColProgressBar(gui, null, 0, 200, modulo, libertyProduction);
        progress.setPreferredSize(new Dimension(width, 20));
        this.add((Component)progress, "span 3");
        double turns100 = -1.0;
        double turns50 = -1.0;
        double turnsNext = -1.0;
        if (libertyProduction > 0) {
            int requiredLiberty = 200 * colony.getUnitCount();
            if (liberty < requiredLiberty) {
                turns100 = (double)(requiredLiberty - liberty) / (double)libertyProduction;
            }
            if (liberty < (requiredLiberty /= 2)) {
                turns50 = (double)(requiredLiberty - liberty) / (double)libertyProduction;
            }
            if (rebels < population && liberty < (requiredLiberty = 200 * (rebels + 1))) {
                turnsNext = (double)(requiredLiberty - liberty) / (double)libertyProduction;
            }
        }
        String na = Messages.message("notApplicable.short");
        this.add(new JLabel(Messages.message("report.nextMember")));
        this.add((Component)new JLabel(turnsNext < 0.0 ? na : Integer.toString((int)Math.ceil(turnsNext))), "skip");
        this.add(new JLabel(Messages.message("report.50percent")));
        this.add((Component)new JLabel(turns50 < 0.0 ? na : Integer.toString((int)Math.ceil(turns50))), "skip");
        this.add(new JLabel(Messages.message("report.100percent")));
        this.add((Component)new JLabel(turns100 < 0.0 ? na : Integer.toString((int)Math.ceil(turns100))), "skip");
        int grow = colony.getPreferredSizeChange();
        if (grow > 0) {
            this.add(new JLabel(Messages.message("report.changeMore")));
            this.add((Component)new JLabel(Integer.toString(grow)), "skip");
        } else if (grow < 0) {
            this.add(new JLabel(Messages.message("report.changeLess")));
            this.add((Component)new JLabel(Integer.toString(-grow)), "skip");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 250);
    }
}

