/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditSettlementDialog
extends FreeColDialog<IndianSettlement>
implements ItemListener {
    private static final Logger logger = Logger.getLogger(EditSettlementDialog.class.getName());
    private static final String REMOVE = "REMOVE";
    private final IndianSettlement settlement;
    private final JCheckBox capital;
    private final JComboBox owner;
    private final JComboBox skill;
    private final JSpinner units;
    private final JTextField name;

    public EditSettlementDialog(FreeColClient freeColClient, GUI gui, IndianSettlement settlement) {
        super(freeColClient, gui);
        this.settlement = settlement;
        this.okButton.addActionListener(this);
        this.setLayout((LayoutManager)new MigLayout("wrap 2, gapx 20"));
        this.add(new JLabel(Messages.message("name")));
        this.name = new JTextField(settlement.getName(), 30);
        this.add(this.name);
        this.add(new JLabel(Messages.message("nation")));
        DefaultComboBoxModel<Nation> nationModel = new DefaultComboBoxModel<Nation>();
        for (Player player : settlement.getGame().getPlayers()) {
            if (!player.isAI() || !player.isIndian()) continue;
            nationModel.addElement(player.getNation());
        }
        this.owner = new JComboBox(nationModel);
        this.owner.setSelectedItem(settlement.getOwner().getNation());
        this.owner.addItemListener(this);
        this.owner.setRenderer(new FreeColComboBoxRenderer());
        this.add(this.owner);
        this.add(new JLabel(Messages.message("capital")));
        this.capital = new JCheckBox();
        this.capital.setSelected(settlement.isCapital());
        this.add(this.capital);
        this.add(new JLabel(Messages.message("report.indian.skillTaught")));
        this.skill = new JComboBox(this.getSkillModel());
        this.skill.setSelectedItem(settlement.getLearnableSkill());
        this.skill.setRenderer(new FreeColComboBoxRenderer());
        this.add(this.skill);
        this.add(new JLabel(Messages.message("report.units")));
        int unitCount = settlement.getUnitCount();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(unitCount, 1, 20, 1);
        this.units = new JSpinner(spinnerModel);
        this.add(this.units);
        JButton remove = new JButton(Messages.message("editor.removeSettlement"));
        remove.setActionCommand(REMOVE);
        remove.addActionListener(this);
        this.add((Component)this.okButton, "newline 20, span, split 3, tag ok");
        this.add((Component)remove, "");
        this.add((Component)this.cancelButton, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    private DefaultComboBoxModel getSkillModel() {
        IndianNationType ownerType = (IndianNationType)((Nation)this.owner.getSelectedItem()).getType();
        DefaultComboBoxModel<UnitType> skillModel = new DefaultComboBoxModel<UnitType>();
        for (RandomChoice<UnitType> skill : ownerType.getSkills()) {
            skillModel.addElement(skill.getObject());
        }
        return skillModel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.skill.setModel(this.getSkillModel());
        this.skill.setSelectedItem(this.settlement.getLearnableSkill());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.settlement.setName(this.name.getText());
            Nation newNation = (Nation)this.owner.getSelectedItem();
            if (newNation != this.settlement.getOwner().getNation()) {
                Player newPlayer = this.settlement.getGame().getPlayer(newNation.getId());
                this.settlement.changeOwner(newPlayer);
                MapEditorTransformPanel.setNativePlayer(newPlayer);
            }
            if (this.capital.isSelected() && !this.settlement.isCapital()) {
                for (IndianSettlement indianSettlement : this.settlement.getOwner().getIndianSettlements()) {
                    indianSettlement.setCapital(false);
                }
                this.settlement.setCapital(true);
            } else if (!this.capital.isSelected() && this.settlement.isCapital()) {
                this.settlement.setCapital(false);
            }
            this.settlement.setLearnableSkill((UnitType)this.skill.getSelectedItem());
            int numberOfUnits = (Integer)this.units.getValue() - this.settlement.getUnitCount();
            if (numberOfUnits > 0) {
                UnitType BRAVE = this.getSpecification().getUnitType("model.unit.brave");
                for (int index = 0; index < numberOfUnits; ++index) {
                    this.settlement.add(new ServerUnit(this.settlement.getGame(), this.settlement, this.settlement.getOwner(), BRAVE));
                }
            } else if (numberOfUnits < 0) {
                List<Unit> unitList = this.settlement.getUnitList().subList(0, -numberOfUnits);
                for (Unit unit : unitList) {
                    unit.dispose();
                }
            }
        } else if (REMOVE.equals(command)) {
            if (!this.getGUI().showConfirmDialog("editor.removeSettlement.text", "ok", "cancel")) {
                return;
            }
            Tile tile = this.settlement.getTile();
            for (Unit unit : tile.getUnitList()) {
                unit.dispose();
            }
            ((ServerPlayer)this.settlement.getOwner()).csDisposeSettlement(this.settlement, new ChangeSet());
        }
        this.getGUI().removeFromCanvas(this);
    }
}

