/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class DifficultyDialog
extends OptionsDialog
implements TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(DifficultyDialog.class.getName());
    private static final String EDIT = "EDIT";
    private JButton edit = new JButton(Messages.message("edit"));
    private String DEFAULT_LEVEL = "model.difficulty.medium";
    private String CUSTOM_LEVEL = "model.difficulty.custom";
    private OptionGroup selected;
    private Specification specification;

    public DifficultyDialog(FreeColClient freeColClient, GUI gui, OptionGroup level, boolean editable) {
        super(freeColClient, gui, editable);
        this.specification = this.getSpecification();
        this.selected = level;
        this.initialize(level, Messages.message("difficulty"), null);
        this.getOptionUI().getTree().addTreeSelectionListener(this);
    }

    public DifficultyDialog(FreeColClient freeColClient, GUI gui, Specification specification) {
        super(freeColClient, gui, true);
        this.specification = specification;
        boolean customized = this.loadCustomOptions();
        OptionGroup group = specification.getOptionGroup("difficultyLevels");
        this.selected = specification.getDifficultyLevel(customized ? this.CUSTOM_LEVEL : this.DEFAULT_LEVEL);
        if (this.selected == null) {
            this.selected = specification.getDifficultyLevels().get(0);
        }
        this.edit.setActionCommand(EDIT);
        this.edit.addActionListener(this);
        this.edit.setEnabled(!this.isGroupEditable());
        this.getButtons().add(this.edit);
        this.save.setEnabled(this.isGroupEditable());
        this.initialize(group, Messages.message("difficulty"), null);
        this.getOptionUI().getTree().addTreeSelectionListener(this);
        this.selectLevel(this.getOptionUI().getTree(), this.selected.getId());
    }

    private boolean isGroupEditable() {
        return this.selected != null && this.selected.isEditable();
    }

    public String getOptionGroupId() {
        return this.CUSTOM_LEVEL;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getOptionUI().updateOption();
            this.getGUI().removeFromCanvas(this);
            this.setResponse(this.selected);
        } else if (EDIT.equals(command)) {
            OptionGroup custom = this.specification.getOptionGroup(this.CUSTOM_LEVEL);
            custom.setValue(this.selected);
            JTree tree = this.getOptionUI().getTree();
            for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                tree.collapseRow(row);
            }
            this.selectLevel(tree, this.CUSTOM_LEVEL);
        } else if ("LOAD".equals(command)) {
            File loadFile = this.getGUI().showLoadDialog(FreeColDirectories.getOptionsDirectory(), filters);
            if (loadFile != null) {
                this.load(loadFile);
            }
        } else {
            super.actionPerformed(event);
        }
    }

    private void selectLevel(JTree tree, String id) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        for (int index = 0; index < root.getChildCount(); ++index) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(index);
            OptionGroup group = (OptionGroup)node.getUserObject();
            if (!id.equals(group.getId())) continue;
            Object[] nodes = new TreeNode[]{root, node, node.getFirstChild()};
            tree.setSelectionPath(new TreePath(nodes));
            break;
        }
    }

    public OptionGroup getSelectedGroup(TreePath path) {
        if (path.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
        return (OptionGroup)node.getUserObject();
    }

    public void valueChanged(TreeSelectionEvent event) {
        this.selected = this.getSelectedGroup(event.getPath());
        this.edit.setEnabled(!this.isGroupEditable());
        this.save.setEnabled(this.isGroupEditable());
    }

    public String getDefaultFileName() {
        return "custom.xml";
    }
}

