/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.RebelToolTip;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.UnitPanel;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColonyPanel
extends PortPanel
implements ActionListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger(ColonyPanel.class.getName());
    public static final int SCROLL_AREA_HEIGHT = 40;
    public static final int SCROLL_SPEED = 40;
    private static final int EXIT = 0;
    private static final int BUILDQUEUE = 1;
    private static final int UNLOAD = 2;
    private static final int WAREHOUSE = 4;
    private static final int FILL = 5;
    private static final int COLONY_UNITS = 6;
    private static final int SETGOODS = 7;
    private final JPanel netProductionPanel = new JPanel();
    private final PopulationPanel populationPanel = new PopulationPanel();
    private final JComboBox nameBox;
    private final OutsideColonyPanel outsideColonyPanel;
    private final WarehousePanel warehousePanel;
    private final TilePanel tilePanel;
    private final BuildingsPanel buildingsPanel;
    private final ConstructionPanel constructionPanel;
    private final MouseListener releaseListener;
    private Colony colony;
    private JButton unloadButton = new JButton(Messages.message("unload"));
    private JButton fillButton = new JButton(Messages.message("fill"));
    private JButton warehouseButton = new JButton(Messages.message("warehouseDialog.name"));
    private JButton buildQueueButton = new JButton(Messages.message("colonyPanel.buildQueue"));
    private JButton colonyUnitsButton = new JButton(Messages.message("colonyPanel.colonyUnits"));
    private JButton setGoodsButton = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? new JButton("Set Goods") : null;

    public ColonyPanel(FreeColClient freeColClient, GUI gui, Colony colony) {
        super(freeColClient, gui);
        this.setFocusCycleRoot(true);
        ComponentInputMap closeInputMap = new ComponentInputMap(this.okButton);
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, closeInputMap);
        ComponentInputMap unloadInputMap = new ComponentInputMap(this.unloadButton);
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.unloadButton, 2, unloadInputMap);
        ComponentInputMap fillInputMap = new ComponentInputMap(this.fillButton);
        ((InputMap)fillInputMap).put(KeyStroke.getKeyStroke(76, 0, false), "pressed");
        ((InputMap)fillInputMap).put(KeyStroke.getKeyStroke(76, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.fillButton, 2, fillInputMap);
        ComponentInputMap warehouseInputMap = new ComponentInputMap(this.warehouseButton);
        ((InputMap)warehouseInputMap).put(KeyStroke.getKeyStroke(87, 0, false), "pressed");
        ((InputMap)warehouseInputMap).put(KeyStroke.getKeyStroke(87, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.warehouseButton, 2, warehouseInputMap);
        ComponentInputMap buildQueueInputMap = new ComponentInputMap(this.buildQueueButton);
        ((InputMap)buildQueueInputMap).put(KeyStroke.getKeyStroke(66, 0, false), "pressed");
        ((InputMap)buildQueueInputMap).put(KeyStroke.getKeyStroke(66, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.buildQueueButton, 2, buildQueueInputMap);
        ComponentInputMap colonyUnitsInputMap = new ComponentInputMap(this.colonyUnitsButton);
        ((InputMap)colonyUnitsInputMap).put(KeyStroke.getKeyStroke(67, 0, false), "pressed");
        ((InputMap)colonyUnitsInputMap).put(KeyStroke.getKeyStroke(67, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.colonyUnitsButton, 2, colonyUnitsInputMap);
        this.netProductionPanel.setOpaque(false);
        this.constructionPanel = new ConstructionPanel(gui, colony, true);
        this.constructionPanel.setOpaque(true);
        this.outsideColonyPanel = new OutsideColonyPanel();
        this.inPortPanel = new ColonyInPortPanel();
        this.warehousePanel = new WarehousePanel();
        this.tilePanel = new TilePanel(freeColClient);
        this.buildingsPanel = new BuildingsPanel();
        this.cargoPanel = new ColonyCargoPanel(freeColClient);
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, gui, this);
        this.pressListener = new DragListener(freeColClient, gui, this);
        this.releaseListener = new DropListener();
        JScrollPane outsideColonyScroll = new JScrollPane(this.outsideColonyPanel, 20, 31);
        outsideColonyScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        JScrollPane warehouseScroll = new JScrollPane(this.warehousePanel, 21, 30);
        JScrollPane tilesScroll = new JScrollPane(this.tilePanel, 20, 30);
        JScrollPane buildingsScroll = new JScrollPane(this.buildingsPanel, 20, 30);
        buildingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.nameBox = new JComboBox();
        this.nameBox.setFont(smallHeaderFont);
        for (Colony aColony : this.getSortedColonies()) {
            this.nameBox.addItem(aColony);
        }
        this.nameBox.setSelectedItem(colony);
        this.nameBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ColonyPanel.this.initialize((Colony)ColonyPanel.this.nameBox.getSelectedItem());
            }
        });
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        ComponentInputMap nameInputMap = new ComponentInputMap(this.nameBox);
        ((InputMap)nameInputMap).put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        ((InputMap)nameInputMap).put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        SwingUtilities.replaceUIInputMap(this.nameBox, 2, nameInputMap);
        buildingsScroll.setAutoscrolls(true);
        buildingsScroll.getViewport().setOpaque(false);
        this.buildingsPanel.setOpaque(false);
        tilesScroll.setBorder(BorderFactory.createBevelBorder(1));
        buildingsScroll.setBorder(BorderFactory.createEtchedBorder());
        warehouseScroll.setBorder(BorderFactory.createEtchedBorder());
        cargoScroll.setBorder(BorderFactory.createEtchedBorder());
        inPortScroll.setBorder(BorderFactory.createEtchedBorder());
        outsideColonyScroll.setBorder(BorderFactory.createEtchedBorder());
        this.okButton.setText(Messages.message("close"));
        this.unloadButton.setActionCommand(String.valueOf(2));
        ColonyPanel.enterPressesWhenFocused(this.unloadButton);
        this.unloadButton.addActionListener(this);
        this.fillButton.setActionCommand(String.valueOf(5));
        ColonyPanel.enterPressesWhenFocused(this.fillButton);
        this.fillButton.addActionListener(this);
        this.warehouseButton.setActionCommand(String.valueOf(4));
        ColonyPanel.enterPressesWhenFocused(this.warehouseButton);
        this.warehouseButton.addActionListener(this);
        this.buildQueueButton.setActionCommand(String.valueOf(1));
        ColonyPanel.enterPressesWhenFocused(this.buildQueueButton);
        this.buildQueueButton.addActionListener(this);
        this.colonyUnitsButton.setActionCommand(String.valueOf(6));
        ColonyPanel.enterPressesWhenFocused(this.colonyUnitsButton);
        this.colonyUnitsButton.addActionListener(this);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.setActionCommand(String.valueOf(7));
            ColonyPanel.enterPressesWhenFocused(this.setGoodsButton);
            this.setGoodsButton.addActionListener(this);
        }
        this.selectedUnitLabel = null;
        this.addMouseListener(new MouseAdapter(){});
        this.setLayout((LayoutManager)new MigLayout("fill, wrap 2, insets 2", "[390!][fill]", "[][]0[]0[][growprio 200,shrinkprio 10][growprio 150,shrinkprio 50]"));
        this.add((Component)this.nameBox, "height 48:, grow");
        this.add((Component)this.netProductionPanel, "growx");
        this.add((Component)tilesScroll, "width 390!, height 200!, top");
        this.add((Component)buildingsScroll, "span 1 3, grow");
        this.add((Component)this.populationPanel, "grow");
        this.add((Component)this.constructionPanel, "grow, top");
        this.add((Component)inPortScroll, "span, split 3, grow, sg, height 60:121:");
        this.add((Component)cargoScroll, "grow, sg, height 60:121:");
        this.add((Component)outsideColonyScroll, "grow, sg, height 60:121:");
        this.add((Component)warehouseScroll, "span, height 40:60:, growx");
        this.add((Component)this.unloadButton, "span, split " + Integer.toString(this.setGoodsButton == null ? 6 : 7) + ", align center");
        this.add(this.fillButton);
        this.add(this.warehouseButton);
        this.add(this.buildQueueButton);
        this.add(this.colonyUnitsButton);
        if (this.setGoodsButton != null) {
            this.add(this.setGoodsButton);
        }
        this.add((Component)this.okButton, "tag ok");
        this.initialize(colony);
        this.restoreSavedSize(850, 600);
    }

    public final synchronized Colony getColony() {
        return this.colony;
    }

    private synchronized void setColony(Colony colony) {
        this.colony = colony;
    }

    public final WarehousePanel getWarehousePanel() {
        return this.warehousePanel;
    }

    public final TilePanel getTilePanel() {
        return this.tilePanel;
    }

    public void updateConstructionPanel() {
        this.constructionPanel.update();
    }

    public void updateInPortPanel() {
        this.inPortPanel.update();
    }

    public void updateWarehousePanel() {
        this.warehousePanel.update();
    }

    public void updateOutsideColonyPanel() {
        this.outsideColonyPanel.update();
    }

    public void updateBuildingsPanel() {
        this.buildingsPanel.update();
    }

    public void updateTilePanel() {
        this.tilePanel.update();
    }

    public void updateProductionPanel() {
        Specification spec = this.colony.getSpecification();
        this.colony.invalidateCache();
        this.netProductionPanel.removeAll();
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            int amount = this.colony.getAdjustedNetProductionOf(goodsType);
            if (amount == 0) continue;
            this.netProductionPanel.add(new ProductionLabel(this.getFreeColClient(), this.getGUI(), goodsType, amount));
        }
        this.netProductionPanel.revalidate();
    }

    private void updateProduction() {
        this.updateTilePanel();
        this.updateBuildingsPanel();
        this.updateProductionPanel();
        this.updateConstructionPanel();
    }

    private void sortBuildings(List<Building> buildings) {
        Collections.sort(buildings);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Colony colony = this.getColony();
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.closeColonyPanel();
        } else {
            try {
                switch (Integer.valueOf(command)) {
                    case 2: {
                        this.unload();
                        break;
                    }
                    case 4: {
                        if (this.getGUI().showWarehouseDialog(colony)) {
                            this.updateWarehousePanel();
                        }
                        break;
                    }
                    case 1: {
                        this.getGUI().showBuildQueuePanel(colony);
                        this.updateConstructionPanel();
                        break;
                    }
                    case 5: {
                        this.fill();
                        break;
                    }
                    case 6: {
                        this.generateColonyUnitsMenu();
                        break;
                    }
                    case 7: {
                        DebugUtils.setColonyGoods(this.getFreeColClient(), colony);
                        this.updateWarehousePanel();
                        this.updateProduction();
                        break;
                    }
                    default: {
                        logger.warning("Invalid action");
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.warning("Invalid action number: " + command);
            }
        }
    }

    private void unload() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            for (Goods goods : unit.getGoodsContainer().getGoods()) {
                this.getController().unloadCargo(goods, false);
            }
            for (Unit u : unit.getUnitList()) {
                this.getController().leaveShip(u);
            }
            this.cargoPanel.update();
            this.outsideColonyPanel.update();
        }
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
    }

    private void fill() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            for (Goods goods : unit.getGoodsContainer().getGoods()) {
                int space = 100 - goods.getAmount();
                int count = this.getColony().getGoodsCount(goods.getType());
                if (space <= 0 || count <= 0) continue;
                Goods newGoods = new Goods(goods.getGame(), this.getColony(), goods.getType(), Math.min(space, count));
                this.getController().loadCargo(newGoods, unit);
            }
        }
    }

    private void updateCarrierButtons() {
        Unit unit;
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
        if (this.isEditable() && this.selectedUnitLabel != null && (unit = this.selectedUnitLabel.getUnit()) != null && unit.isCarrier() && unit.hasCargo()) {
            this.unloadButton.setEnabled(true);
            for (Goods goods : unit.getGoodsList()) {
                if (this.getColony().getGoodsCount(goods.getType()) <= 0) continue;
                this.fillButton.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public Unit getSelectedUnit() {
        return this.selectedUnitLabel == null ? null : this.selectedUnitLabel.getUnit();
    }

    @Override
    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
                this.selectedUnitLabel.getUnit().removePropertyChangeListener(this);
            }
            this.selectedUnitLabel = unitLabel;
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
                unitLabel.getUnit().addPropertyChangeListener(this);
            }
        }
        this.updateCarrierButtons();
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.colony.getTile().getUnitList();
    }

    private void initialize(Colony colony) {
        this.removePropertyChangeListeners();
        this.setColony(colony);
        this.editable = colony.getOwner() == this.getMyPlayer();
        this.addPropertyChangeListeners();
        this.outsideColonyPanel.removeMouseListener(this.releaseListener);
        this.inPortPanel.removeMouseListener(this.releaseListener);
        this.cargoPanel.removeMouseListener(this.releaseListener);
        this.warehousePanel.removeMouseListener(this.releaseListener);
        if (this.isEditable()) {
            this.outsideColonyPanel.setTransferHandler(this.defaultTransferHandler);
            this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
            this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
            this.warehousePanel.setTransferHandler(this.defaultTransferHandler);
            this.outsideColonyPanel.addMouseListener(this.releaseListener);
            this.inPortPanel.addMouseListener(this.releaseListener);
            this.cargoPanel.addMouseListener(this.releaseListener);
            this.warehousePanel.addMouseListener(this.releaseListener);
        } else {
            this.outsideColonyPanel.setTransferHandler(null);
            this.inPortPanel.setTransferHandler(null);
            this.cargoPanel.setTransferHandler(null);
            this.warehousePanel.setTransferHandler(null);
        }
        this.unloadButton.setEnabled(this.isEditable());
        this.fillButton.setEnabled(this.isEditable());
        this.warehouseButton.setEnabled(this.isEditable());
        this.colonyUnitsButton.setEnabled(this.isEditable());
        this.nameBox.setEnabled(this.isEditable());
        this.cargoPanel.setCarrier(null);
        this.inPortPanel.initialize();
        this.warehousePanel.initialize();
        this.buildingsPanel.initialize();
        this.tilePanel.initialize();
        this.outsideColonyPanel.initialize();
        this.updateProductionPanel();
        this.populationPanel.update();
        this.constructionPanel.setColony(colony);
        this.inPortPanel.setName(colony.getName() + " - port");
    }

    public void closeColonyPanel() {
        if (this.getColony().getUnitCount() == 0) {
            if (this.getGUI().showConfirmDialog("abandonColony.text", "abandonColony.yes", "abandonColony.no")) {
                this.getGUI().removeFromCanvas(this);
                this.getController().abandonColony(this.getColony());
            }
        } else {
            BuildableType buildable = this.getColony().getCurrentlyBuilding();
            if (buildable != null && buildable.getRequiredPopulation() > this.getColony().getUnitCount() && !this.getGUI().showConfirmDialog(null, StringTemplate.template("colonyPanel.reducePopulation").addName("%colony%", this.getColony().getName()).addAmount("%number%", buildable.getRequiredPopulation()).add("%buildable%", buildable.getNameKey()), "ok", "cancel")) {
                return;
            }
            this.getGUI().removeFromCanvas(this);
            this.removePropertyChangeListeners();
            if (this.getSelectedUnit() != null) {
                this.getSelectedUnit().removePropertyChangeListener(this);
            }
            this.buildingsPanel.cleanup();
            this.warehousePanel.cleanup();
            this.tilePanel.cleanup();
            this.constructionPanel.removePropertyChangeListeners();
            this.cargoPanel.setCarrier(null);
            this.outsideColonyPanel.cleanup();
            if (this.getFreeColClient().currentPlayerIsMyPlayer()) {
                this.getController().nextModelMessage();
                Unit activeUnit = this.getGUI().getActiveUnit();
                if (activeUnit == null || activeUnit.getTile() == null || !(activeUnit.getLocation() instanceof Tile) && !activeUnit.isOnCarrier()) {
                    this.getController().nextActiveUnit();
                }
            }
            this.getGUI().getMapViewer().restartBlinking();
        }
    }

    private void generateColonyUnitsMenu() {
        int lastIndex;
        int elements;
        JPopupMenu colonyUnitsMenu = new JPopupMenu("Colony Units");
        ImageLibrary imageLibrary = super.getLibrary();
        ImageIcon unitIcon = null;
        final QuickActionMenu unitMenu = new QuickActionMenu(this.getFreeColClient(), this.getGUI(), this);
        Tile colonyTile = this.colony.getTile();
        int unitNumber = 0;
        JMenuItem subMenu = null;
        for (final Unit unit : this.colony.getUnitList()) {
            ColonyTile workingOnLand = unit.getWorkTile();
            if (workingOnLand != null) {
                GoodsType goodsType = unit.getWorkType();
                int producing = workingOnLand.getProductionOf(unit, goodsType);
                unitIcon = imageLibrary.getUnitImageIcon(unit, 0.5);
                String nominative = Messages.message(StringTemplate.template(goodsType.getNameKey()).addAmount("%amount%", producing));
                String menuTitle = new String(Messages.message(unit.getLabel()) + " " + Messages.message("producing.name") + " " + producing + " " + nominative);
                subMenu = new JMenuItem(menuTitle, unitIcon);
                subMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        unitMenu.createUnitMenu(new UnitLabel(ColonyPanel.this.getFreeColClient(), unit, ColonyPanel.this.getGUI()));
                        unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                    }
                });
                ++unitNumber;
                colonyUnitsMenu.add(subMenu);
                continue;
            }
            Building workingInBuilding = unit.getWorkLocation();
            if (workingInBuilding == null) continue;
            GoodsType goodsType = unit.getWorkType();
            int producing = workingInBuilding.getProductionOf(unit, workingInBuilding.getGoodsOutputType());
            unitIcon = imageLibrary.getUnitImageIcon(unit, 0.5);
            String nominative = Messages.message(StringTemplate.template(goodsType.getNameKey()).addAmount("%amount%", producing));
            String menuTitle = new String(Messages.message(unit.getLabel()) + " " + Messages.message("producing.name") + " " + producing + " " + nominative);
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    unitMenu.createUnitMenu(new UnitLabel(ColonyPanel.this.getFreeColClient(), unit, ColonyPanel.this.getGUI()));
                    unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                }
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        for (final Unit unit : colonyTile.getUnitList()) {
            String menuTitle;
            if (unit.isCarrier()) {
                unitIcon = imageLibrary.getUnitImageIcon(unit, 0.5);
                menuTitle = new String(Messages.message(unit.getLabel()) + " " + Messages.message("inPort.name"));
                subMenu = new JMenuItem(menuTitle, unitIcon);
                subMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        unitMenu.createUnitMenu(new UnitLabel(ColonyPanel.this.getFreeColClient(), unit, ColonyPanel.this.getGUI()));
                        unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                    }
                });
                ++unitNumber;
                colonyUnitsMenu.add(subMenu);
                if (unit.getUnitList() == null) continue;
                for (final Unit innerUnit : unit.getUnitList()) {
                    unitIcon = imageLibrary.getUnitImageIcon(innerUnit, 0.5);
                    menuTitle = new String(Messages.message(innerUnit.getLabel()) + " Cargo On " + Messages.message(unit.getLabel()));
                    subMenu = new JMenuItem(menuTitle, unitIcon);
                    subMenu.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            unitMenu.createUnitMenu(new UnitLabel(ColonyPanel.this.getFreeColClient(), innerUnit, ColonyPanel.this.getGUI()));
                            unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                        }
                    });
                    ++unitNumber;
                    colonyUnitsMenu.add(subMenu);
                }
                continue;
            }
            if (unit.isOnCarrier()) continue;
            unitIcon = imageLibrary.getUnitImageIcon(unit, 0.5);
            menuTitle = new String(Messages.message(unit.getLabel()) + " " + Messages.message("outsideOfColony.name"));
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    unitMenu.createUnitMenu(new UnitLabel(ColonyPanel.this.getFreeColClient(), unit, ColonyPanel.this.getGUI()));
                    unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                }
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        if (colonyUnitsMenu != null && (elements = colonyUnitsMenu.getSubElements().length) > 0 && colonyUnitsMenu.getComponent(lastIndex = colonyUnitsMenu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            colonyUnitsMenu.remove(lastIndex);
        }
        colonyUnitsMenu.show(this.getGUI().getCanvas(), 0, 0);
    }

    private void addPropertyChangeListeners() {
        if (this.colony != null) {
            this.colony.addPropertyChangeListener(this);
            this.colony.getGoodsContainer().addPropertyChangeListener(this);
            this.colony.getTile().addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeListeners() {
        if (this.colony != null) {
            this.colony.removePropertyChangeListener(this);
            this.colony.getGoodsContainer().removePropertyChangeListener(this);
            this.colony.getTile().removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.isShowing() || this.colony == null) {
            return;
        }
        String property = event.getPropertyName();
        logger.finest(this.colony.getName() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        if (property == null) {
            logger.warning("Null property change");
        } else if ("CARGO_CHANGE".equals(property)) {
            this.updateInPortPanel();
        } else if (Colony.ColonyChangeEvent.POPULATION_CHANGE.toString().equals(property)) {
            this.populationPanel.update();
            this.updateProductionPanel();
        } else if (Colony.ColonyChangeEvent.BONUS_CHANGE.toString().equals(property)) {
            ModelMessage msg = this.colony.checkForGovMgtChangeMessage();
            if (msg != null) {
                this.getGUI().showInformationMessage((FreeColObject)this.colony, msg);
            }
            this.populationPanel.update();
        } else if (Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString().equals(property)) {
            FreeColGameObject object = (FreeColGameObject)event.getSource();
            UnitType oldType = (UnitType)event.getOldValue();
            UnitType newType = (UnitType)event.getNewValue();
            this.getGUI().showInformationMessage((FreeColObject)object, StringTemplate.template("model.colony.unitChange").add("%oldType%", oldType.getNameKey()).add("%newType%", newType.getNameKey()));
            this.updateTilePanel();
        } else if (property.startsWith("model.goods.")) {
            this.updateWarehousePanel();
            this.updateProduction();
        } else if ("TILE_UNIT_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
            this.updateInPortPanel();
        } else {
            logger.warning("Unknown property change event: " + event.getPropertyName());
        }
    }

    public final class TilePanel
    extends FreeColPanel {
        private final ColonyPanel colonyPanel;
        private Tile[][] tiles;

        public TilePanel(FreeColClient freeColClient) {
            super(freeColClient, freeColClient.getGUI());
            this.tiles = new Tile[3][3];
            this.colonyPanel = ColonyPanel.this;
            this.setBackground(Color.BLACK);
            this.setBorder(null);
            this.setLayout(null);
        }

        public void initialize() {
            this.cleanup();
            if (ColonyPanel.this.colony == null) {
                return;
            }
            Tile tile = ColonyPanel.this.colony.getTile();
            this.tiles[0][0] = tile.getNeighbourOrNull(Map.Direction.N);
            this.tiles[0][1] = tile.getNeighbourOrNull(Map.Direction.NE);
            this.tiles[0][2] = tile.getNeighbourOrNull(Map.Direction.E);
            this.tiles[1][0] = tile.getNeighbourOrNull(Map.Direction.NW);
            this.tiles[1][1] = tile;
            this.tiles[1][2] = tile.getNeighbourOrNull(Map.Direction.SE);
            this.tiles[2][0] = tile.getNeighbourOrNull(Map.Direction.W);
            this.tiles[2][1] = tile.getNeighbourOrNull(Map.Direction.SW);
            this.tiles[2][2] = tile.getNeighbourOrNull(Map.Direction.S);
            int layer = 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (this.tiles[x][y] == null) continue;
                    ColonyTile colonyTile = ColonyPanel.this.colony.getColonyTile(this.tiles[x][y]);
                    ASingleTilePanel p = new ASingleTilePanel(colonyTile, x, y);
                    p.initialize();
                    this.add((Component)p, new Integer(layer));
                    ++layer;
                }
            }
            this.update();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).update();
            }
            this.repaint();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).cleanup();
            }
            this.removeAll();
        }

        public void paintComponent(Graphics g) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ColonyPanel.this.colony == null) {
                return;
            }
            Tile tile = ColonyPanel.this.colony.getTile();
            TileType tileType = tile.getType();
            ImageLibrary lib = this.getLibrary();
            Image image = lib.getTerrainImage(tileType, tile.getX(), tile.getY());
            int tileWidth = image.getWidth(null) / 2;
            int tileHeight = image.getHeight(null) / 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (this.tiles[x][y] == null) continue;
                    int xx = (2 - x + y) * tileWidth;
                    int yy = (x + y) * tileHeight;
                    g.translate(xx, yy);
                    this.getGUI().displayColonyTile((Graphics2D)g, this.tiles[x][y], ColonyPanel.this.colony);
                    g.translate(-xx, -yy);
                }
            }
        }

        public final class ASingleTilePanel
        extends JPanel
        implements DropTarget,
        PropertyChangeListener {
            private ColonyTile colonyTile;

            public ASingleTilePanel(ColonyTile colonyTile, int x, int y) {
                this.colonyTile = colonyTile;
                this.setLayout(new FlowLayout(1, 0, 0));
                this.setOpaque(false);
                Tile tile = colonyTile.getTile();
                TileType tileType = tile.getType();
                Image image = TilePanel.this.getLibrary().getTerrainImage(tileType, tile.getX(), tile.getY());
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                this.setSize(width, height);
                this.setLocation((2 - x + y) * width / 2, (x + y) * height / 2);
            }

            public void initialize() {
                this.cleanup();
                this.addPropertyChangeListeners();
                this.update();
            }

            public void update() {
                this.removeAll();
                UnitLabel label = null;
                for (Unit unit : this.colonyTile.getUnitList()) {
                    label = new UnitLabel(TilePanel.this.getFreeColClient(), unit, TilePanel.this.getGUI());
                    if (TilePanel.this.colonyPanel.isEditable()) {
                        label.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        label.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    super.add(label);
                }
                this.updateDescriptionLabel(label, true);
                if (this.colonyTile.isColonyCenterTile()) {
                    this.setLayout(new GridLayout(2, 1));
                    ProductionInfo info = ColonyPanel.this.colony.getProductionInfo(this.colonyTile);
                    if (info != null) {
                        for (AbstractGoods ag : info.getProduction()) {
                            this.add(new ProductionLabel(TilePanel.this.getFreeColClient(), TilePanel.this.getGUI(), ag));
                        }
                    }
                }
                if (TilePanel.this.colonyPanel.isEditable()) {
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                }
            }

            public void cleanup() {
                this.removePropertyChangeListeners();
            }

            private void updateDescriptionLabel(UnitLabel unit, boolean toAdd) {
                String tileMsg = Messages.message(this.colonyTile.getLabel());
                if (unit == null) {
                    this.setToolTipText(tileMsg);
                } else {
                    String unitMsg = Messages.message(Messages.getLabel(unit.getUnit()));
                    if (toAdd) {
                        unitMsg = tileMsg + " [" + unitMsg + "]";
                    }
                    unit.setDescriptionLabel(unitMsg);
                }
            }

            public boolean contains(int px, int py) {
                int dy;
                int w = this.getWidth();
                int h = this.getHeight();
                int dx = Math.abs(w / 2 - px);
                return dx + w * (dy = Math.abs(h / 2 - py)) / h <= w / 2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Component add(Component comp, boolean editState) {
                Container oldParent = comp.getParent();
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        if (!this.tryWork(((UnitLabel)comp).getUnit())) return null;
                        oldParent.remove(comp);
                        ((UnitLabel)comp).setSmall(false);
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleTilePanel.");
                        return null;
                    }
                }
                this.update();
                return comp;
            }

            private boolean tryWork(Unit unit) {
                ColonyTile best;
                UnitLocation.NoAddReason reason;
                Tile tile = this.colonyTile.getWorkTile();
                Colony colony = ColonyPanel.this.getColony();
                Player player = unit.getOwner();
                if (tile.getOwningSettlement() != colony) {
                    Player.NoClaimReason claim = player.canClaimForSettlementReason(tile);
                    switch (claim) {
                        case NONE: 
                        case NATIVES: {
                            if (TilePanel.this.getController().claimLand(tile, colony, 0) && tile.getOwningSettlement() == colony) {
                                logger.info("Colony " + colony.getName() + " claims tile " + tile.toString() + " with unit " + unit.getId());
                                break;
                            }
                            logger.warning("Colony " + colony.getName() + " did not claim " + tile.toString() + " with unit " + unit.getId());
                            return false;
                        }
                        default: {
                            TilePanel.this.getGUI().showInformationMessage((FreeColObject)tile, "noClaimReason." + claim.toString().toLowerCase(Locale.US));
                            return false;
                        }
                    }
                    if (tile.getOwningSettlement() != colony) {
                        throw new IllegalStateException("Claim failed");
                    }
                }
                if ((reason = this.colonyTile.getNoAddReason(unit)) != UnitLocation.NoAddReason.NONE) {
                    TilePanel.this.getGUI().showInformationMessage((FreeColObject)this.colonyTile, "noAddReason." + reason.toString().toLowerCase(Locale.US));
                    return false;
                }
                GoodsType workType = unit.getWorkType();
                if (workType != null && this.colonyTile.getProductionOf(unit, workType) <= 0) {
                    workType = null;
                }
                if (workType == null && (workType = unit.getExperienceType()) != null && this.colonyTile.getProductionOf(unit, workType) <= 0) {
                    workType = null;
                }
                if (workType == null && (workType = unit.getType().getExpertProduction()) != null && this.colonyTile.getProductionOf(unit, workType) <= 0) {
                    workType = null;
                }
                if (workType == null && (workType = this.colonyTile.getBestWorkType(unit)) != null && this.colonyTile.getProductionOf(unit, workType) <= 0) {
                    workType = null;
                }
                if (workType == null) {
                    workType = unit.getWorkType();
                }
                TilePanel.this.getController().work(unit, this.colonyTile);
                if (workType != null && workType != unit.getWorkType()) {
                    TilePanel.this.getController().changeWorkType(unit, workType);
                }
                if (TilePanel.this.getClientOptions().getBoolean("model.option.guiShowNotBestTile") && (best = colony.getVacantColonyTileFor(unit, false, workType)) != null && this.colonyTile != best && this.colonyTile.getPotentialProduction(workType, unit.getType()) < best.getPotentialProduction(workType, unit.getType())) {
                    StringTemplate template = StringTemplate.template("colonyPanel.notBestTile").addStringTemplate("%unit%", Messages.getLabel(unit)).add("%goods%", workType.getNameKey()).addStringTemplate("%tile%", best.getLabel());
                    TilePanel.this.getGUI().showInformationMessage((FreeColObject)best, template);
                }
                return true;
            }

            private void addPropertyChangeListeners() {
                this.colonyTile.addPropertyChangeListener(this);
            }

            private void removePropertyChangeListeners() {
                this.colonyTile.removePropertyChangeListener(this);
            }

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                logger.finest(this.colonyTile.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
                TilePanel.this.colonyPanel.updateProduction();
            }

            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            public boolean accepts(Goods goods) {
                return false;
            }
        }
    }

    public final class BuildingsPanel
    extends JPanel {
        private final ColonyPanel colonyPanel;

        public BuildingsPanel() {
            this.colonyPanel = ColonyPanel.this;
            this.setLayout((LayoutManager)new MigLayout("fill, wrap 4, insets 0, gap 0:10:10:push"));
        }

        public void initialize() {
            this.cleanup();
            if (ColonyPanel.this.colony == null) {
                return;
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    ColonyPanel.this.getGUI().showBuildQueuePanel(ColonyPanel.this.getColony());
                }
            };
            List<Building> buildings = ColonyPanel.this.colony.getBuildings();
            ColonyPanel.this.sortBuildings(buildings);
            for (Building building : buildings) {
                ASingleBuildingPanel aSBP = new ASingleBuildingPanel(building);
                if (this.colonyPanel.isEditable()) {
                    aSBP.addMouseListener(ColonyPanel.this.releaseListener);
                    aSBP.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                }
                aSBP.setOpaque(false);
                aSBP.addMouseListener(mouseAdapter);
                this.add(aSBP);
            }
            this.update();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).update();
            }
            this.repaint();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).cleanup();
            }
            this.removeAll();
        }

        public String getUIClassID() {
            return "BuildingsPanelUI";
        }

        public final class ASingleBuildingPanel
        extends BuildingPanel
        implements Autoscroll,
        DropTarget {
            public ASingleBuildingPanel(Building building) {
                super(ColonyPanel.this.getFreeColClient(), building, ColonyPanel.this.getGUI());
            }

            public void initialize() {
                super.initialize();
                this.update();
            }

            public void update() {
                super.update();
                if (BuildingsPanel.this.colonyPanel.isEditable()) {
                    for (UnitLabel unitLabel : this.getUnitLabels()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                }
            }

            public void autoscroll(Point p) {
                JViewport vp = (JViewport)BuildingsPanel.this.colonyPanel.buildingsPanel.getParent();
                if (this.getLocation().y + p.y - vp.getViewPosition().y < 40) {
                    vp.setViewPosition(new Point(vp.getViewPosition().x, Math.max(vp.getViewPosition().y - 40, 0)));
                } else if (this.getLocation().y + p.y - vp.getViewPosition().y >= vp.getHeight() - 40) {
                    vp.setViewPosition(new Point(vp.getViewPosition().x, Math.min(vp.getViewPosition().y + 40, BuildingsPanel.this.colonyPanel.buildingsPanel.getHeight() - vp.getHeight())));
                }
            }

            public Insets getAutoscrollInsets() {
                Rectangle r = this.getBounds();
                return new Insets(r.x, r.y, r.width, r.height);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Component add(Component comp, boolean editState) {
                Container oldParent = comp.getParent();
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        if (!this.tryWork(((UnitLabel)comp).getUnit())) return null;
                        oldParent.remove(comp);
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleBuildingPanel.");
                        return null;
                    }
                }
                this.update();
                return null;
            }

            private boolean tryWork(Unit unit) {
                Building building = this.getBuilding();
                UnitLocation.NoAddReason reason = building.getNoAddReason(unit);
                if (reason != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationMessage((FreeColObject)building, "noAddReason." + reason.toString().toLowerCase(Locale.US));
                    return false;
                }
                ColonyPanel.this.getController().work(unit, building);
                return true;
            }

            public void propertyChange(PropertyChangeEvent event) {
                super.propertyChange(event);
                BuildingsPanel.this.colonyPanel.updateProduction();
            }

            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            public boolean accepts(Goods goods) {
                return false;
            }
        }
    }

    public final class WarehousePanel
    extends JPanel
    implements DropTarget,
    PropertyChangeListener {
        private final ColonyPanel colonyPanel;

        public WarehousePanel() {
            this.colonyPanel = ColonyPanel.this;
            this.setLayout((LayoutManager)new MigLayout("fill, gap push, insets 0"));
        }

        public void initialize() {
            this.cleanup();
            this.addPropertyChangeListeners();
            this.update();
        }

        private void update() {
            this.removeAll();
            if (ColonyPanel.this.colony == null) {
                return;
            }
            ClientOptions options = ColonyPanel.this.getClientOptions();
            int threshold = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? 1 : options.getInteger("model.option.guiMinNumberToDisplayGoods");
            Game game = ColonyPanel.this.colony.getGame();
            Specification spec = ColonyPanel.this.colony.getSpecification();
            for (GoodsType goodsType : spec.getGoodsTypeList()) {
                int count;
                if (!goodsType.isStorable() || (count = ColonyPanel.this.colony.getGoodsCount(goodsType)) < threshold) continue;
                Goods goods = new Goods(game, ColonyPanel.this.colony, goodsType, count);
                GoodsLabel goodsLabel = new GoodsLabel(goods, ColonyPanel.this.getGUI());
                if (this.colonyPanel.isEditable()) {
                    goodsLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    goodsLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)goodsLabel, false);
            }
            this.colonyPanel.updateProduction();
            this.revalidate();
            this.repaint();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component dropped on this WarehousePanel.");
                    return null;
                }
                comp.getParent().remove(comp);
                return comp;
            }
            return this.add(comp);
        }

        private void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().addPropertyChangeListener(this);
            }
        }

        private void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().removePropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            logger.finest(ColonyPanel.this.getColony().getName() + "-warehouse change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            this.update();
        }

        public boolean accepts(Unit unit) {
            return false;
        }

        public boolean accepts(Goods goods) {
            return true;
        }

        public String getUIClassID() {
            return "WarehousePanelUI";
        }
    }

    public final class ColonyInPortPanel
    extends InPortPanel {
        public ColonyInPortPanel() {
            super(ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setLayout((LayoutManager)new MigLayout("wrap 3, fill, insets 0"));
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("inPort")));
        }

        public void initialize() {
            if (ColonyPanel.this.colony != null) {
                this.setName(ColonyPanel.this.colony.getName() + " - port");
                super.initialize();
            }
        }

        public boolean accepts(Unit unit) {
            return unit.isCarrier();
        }
    }

    public final class OutsideColonyPanel
    extends UnitPanel
    implements DropTarget {
        public OutsideColonyPanel() {
            super(ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setLayout((LayoutManager)new MigLayout("wrap 4, fill, insets 0"));
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("outsideColony")));
        }

        public void initialize() {
            this.cleanup();
            super.initialize();
            if (ColonyPanel.this.colony != null) {
                this.setName(ColonyPanel.this.colony.getName() + " - port");
            }
        }

        public Component add(Component comp, boolean editState) {
            Container oldParent = comp.getParent();
            if (editState) {
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (!unit.isOnCarrier()) {
                        ColonyPanel.this.getController().putOutsideColony(unit);
                    }
                    if (unit.getColony() == null) {
                        ColonyPanel.this.closeColonyPanel();
                        return null;
                    }
                    if (!(unit.getLocation() instanceof Tile) && !unit.isOnCarrier()) {
                        return null;
                    }
                    oldParent.remove(comp);
                    this.initialize();
                    return comp;
                }
                logger.warning("An invalid component got dropped on this ColonistsPanel.");
                return null;
            }
            ((UnitLabel)comp).setSmall(false);
            Component c = this.add(comp);
            return c;
        }

        protected void addPropertyChangeListeners() {
            if (ColonyPanel.this.colony != null) {
                ColonyPanel.this.colony.getTile().addPropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        protected void removePropertyChangeListeners() {
            if (ColonyPanel.this.colony != null) {
                ColonyPanel.this.colony.getTile().removePropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        public String getUIClassID() {
            return "OutsideColonyPanelUI";
        }

        public boolean accepts(Unit unit) {
            return !unit.isCarrier();
        }

        public boolean accepts(Goods goods) {
            return false;
        }
    }

    public final class PopulationPanel
    extends JPanel {
        private final JLabel rebelShield = new JLabel();
        private final JLabel rebelLabel = new JLabel();
        private final JLabel bonusLabel = new JLabel();
        private final JLabel royalistLabel = new JLabel();
        private final JLabel royalistShield = new JLabel();
        private final JLabel rebelMemberLabel = new JLabel();
        private final JLabel popLabel = new JLabel();
        private final JLabel royalistMemberLabel = new JLabel();

        public PopulationPanel() {
            this.setOpaque(false);
            this.setToolTipText(" ");
            this.setLayout((LayoutManager)new MigLayout("wrap 5, fill, insets 0", "[][]:push[center]:push[right][]"));
            this.add((Component)this.rebelShield, "bottom");
            this.add((Component)this.rebelLabel, "split 2, flowy");
            this.add(this.rebelMemberLabel);
            this.add((Component)this.popLabel, "split 2, flowy");
            this.add(this.bonusLabel);
            this.add((Component)this.royalistLabel, "split 2, flowy");
            this.add(this.royalistMemberLabel);
            this.add((Component)this.royalistShield, "bottom");
        }

        public void update() {
            int uc = ColonyPanel.this.colony.getUnitCount();
            int solPercent = ColonyPanel.this.colony.getSoL();
            int rebels = Colony.calculateRebels(uc, solPercent);
            StringTemplate t = StringTemplate.template("colonyPanel.rebelLabel").addAmount("%number%", rebels);
            this.rebelLabel.setText(Messages.message(t));
            t = StringTemplate.template("colonyPanel.royalistLabel").addAmount("%number%", uc - rebels);
            this.royalistLabel.setText(Messages.message(t));
            t = StringTemplate.template("colonyPanel.populationLabel").addAmount("%number%", uc);
            this.popLabel.setText(Messages.message(t));
            this.rebelMemberLabel.setText(solPercent + "%");
            int grow = ColonyPanel.this.colony.getPreferredSizeChange();
            int bonus = ColonyPanel.this.colony.getProductionBonus();
            t = StringTemplate.template("colonyPanel.bonusLabel").addAmount("%number%", bonus).add("%extra%", grow == 0 ? "" : "(" + grow + ")");
            this.bonusLabel.setText(Messages.message(t));
            this.royalistMemberLabel.setText(ColonyPanel.this.colony.getTory() + "%");
            Nation nation = ColonyPanel.this.colony.getOwner().getNation();
            this.rebelShield.setIcon(new ImageIcon(ColonyPanel.this.getLibrary().getCoatOfArmsImage(nation, 0.5)));
            this.royalistShield.setIcon(new ImageIcon(ColonyPanel.this.getLibrary().getCoatOfArmsImage(nation.getRefNation(), 0.5)));
            this.revalidate();
            this.repaint();
        }

        public JToolTip createToolTip() {
            return new RebelToolTip(ColonyPanel.this.getFreeColClient(), ColonyPanel.this.getGUI(), ColonyPanel.this.getColony());
        }

        public String getUIClassID() {
            return "PopulationPanelUI";
        }
    }

    public final class ColonyCargoPanel
    extends CargoPanel {
        public ColonyCargoPanel(FreeColClient freeColClient) {
            super(freeColClient, freeColClient.getGUI(), true);
            this.setLayout((LayoutManager)new MigLayout("wrap 6, fill, insets 0"));
        }

        public void update() {
            super.update();
            ColonyPanel.this.updateCarrierButtons();
        }
    }
}

