/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueuePanel
extends FreeColPanel
implements ActionListener,
ItemListener {
    private static Logger logger = Logger.getLogger(BuildQueuePanel.class.getName());
    private static final String BUY = "buy";
    private static final int UNABLE_TO_BUILD = -1;
    private final BuildQueueTransferHandler buildQueueHandler = new BuildQueueTransferHandler();
    private ListCellRenderer cellRenderer;
    private static JCheckBox compact = new JCheckBox();
    private static JCheckBox showAll = new JCheckBox();
    private JList buildQueueList;
    private JList unitList;
    private JList buildingList;
    private ConstructionPanel constructionPanel;
    private JButton buyBuilding;
    private Colony colony;
    private int unitCount;
    private FeatureContainer featureContainer;
    private Map<BuildableType, String> lockReasons = new HashMap<BuildableType, String>();
    private Set<BuildableType> unbuildableTypes = new HashSet<BuildableType>();
    private List<UnitType> buildableUnits = new ArrayList<UnitType>();

    public BuildQueuePanel(FreeColClient freeColClient, GUI gui, Colony colony) {
        super(freeColClient, gui, (LayoutManager)new MigLayout("wrap 3", "[260:][390:, fill][260:]", "[][][300:400:][]"));
        this.colony = colony;
        this.unitCount = colony.getUnitCount();
        this.featureContainer = new FeatureContainer();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.needsGoodsToBuild() || unitType.hasAbility("model.ability.bornInColony")) continue;
            this.buildableUnits.add(unitType);
        }
        DefaultListModel<BuildableType> current = new DefaultListModel<BuildableType>();
        for (BuildableType type : colony.getBuildQueue()) {
            current.addElement(type);
            FeatureContainer.addFeatures(this.featureContainer, type);
        }
        this.cellRenderer = this.getCellRenderer();
        for (ItemListener listener : compact.getItemListeners()) {
            compact.removeItemListener(listener);
        }
        compact.setText(Messages.message("colonyPanel.compactView"));
        compact.addItemListener(this);
        for (ItemListener listener : showAll.getItemListeners()) {
            showAll.removeItemListener(listener);
        }
        showAll.setText(Messages.message("colonyPanel.showAll"));
        showAll.addItemListener(this);
        this.buildQueueList = new JList(current);
        this.buildQueueList.setTransferHandler(this.buildQueueHandler);
        this.buildQueueList.setSelectionMode(0);
        this.buildQueueList.setDragEnabled(true);
        this.buildQueueList.setCellRenderer(this.cellRenderer);
        this.buildQueueList.addMouseListener(new BuildQueueMouseAdapter(false));
        AbstractAction deleteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                for (Object type : BuildQueuePanel.this.buildQueueList.getSelectedValues()) {
                    BuildQueuePanel.this.removeBuildable(type);
                }
                BuildQueuePanel.this.updateAllLists();
            }
        };
        this.buildQueueList.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.buildQueueList.getActionMap().put("delete", deleteAction);
        AbstractAction addAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)BuildQueuePanel.this.buildQueueList.getModel();
                for (Object type : ((JList)e.getSource()).getSelectedValues()) {
                    model.addElement(type);
                }
                BuildQueuePanel.this.updateAllLists();
            }
        };
        BuildQueueMouseAdapter adapter = new BuildQueueMouseAdapter(true);
        DefaultListModel units = new DefaultListModel();
        this.unitList = new JList(units);
        this.unitList.setTransferHandler(this.buildQueueHandler);
        this.unitList.setSelectionMode(2);
        this.unitList.setDragEnabled(true);
        this.unitList.setCellRenderer(this.cellRenderer);
        this.unitList.addMouseListener(adapter);
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "add");
        this.unitList.getActionMap().put("add", addAction);
        DefaultListModel buildings = new DefaultListModel();
        this.buildingList = new JList(buildings);
        this.buildingList.setTransferHandler(this.buildQueueHandler);
        this.buildingList.setSelectionMode(2);
        this.buildingList.setDragEnabled(true);
        this.buildingList.setCellRenderer(this.cellRenderer);
        this.buildingList.addMouseListener(adapter);
        this.buildingList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "add");
        this.buildingList.getActionMap().put("add", addAction);
        JLabel headLine = new JLabel(Messages.message("colonyPanel.buildQueue"));
        headLine.setFont(bigHeaderFont);
        this.buyBuilding = new JButton(Messages.message("colonyPanel.buyBuilding"));
        this.buyBuilding.setActionCommand(BUY);
        this.buyBuilding.addActionListener(this);
        this.constructionPanel = new ConstructionPanel(gui, colony, false);
        this.constructionPanel.setOpaque(false);
        StringTemplate buildingNothing = StringTemplate.template("colonyPanel.currentlyBuilding").add("%buildable%", "nothing");
        this.constructionPanel.setDefaultLabel(buildingNothing);
        this.updateAllLists();
        this.add((Component)headLine, "span 3, align center, wrap 40");
        this.add((Component)new JLabel(Messages.message("colonyPanel.units")), "align center");
        this.add((Component)new JLabel(Messages.message("colonyPanel.buildQueue")), "align center");
        this.add((Component)new JLabel(Messages.message("colonyPanel.buildings")), "align center");
        this.add((Component)new JScrollPane(this.unitList), "grow");
        this.add((Component)this.constructionPanel, "split 2, flowy");
        this.add((Component)new JScrollPane(this.buildQueueList), "grow");
        this.add((Component)new JScrollPane(this.buildingList), "grow, wrap 20");
        this.add((Component)this.buyBuilding, "span, split 4");
        this.add(compact);
        this.add(showAll);
        this.add((Component)this.okButton, "tag ok");
    }

    private void removeBuildable(Object type) {
        DefaultListModel model = (DefaultListModel)this.buildQueueList.getModel();
        model.removeElement(type);
    }

    private void updateUnitList() {
        Specification spec = this.getSpecification();
        DefaultListModel units = (DefaultListModel)this.unitList.getModel();
        units.clear();
        block0: for (UnitType unitType : this.buildableUnits) {
            ArrayList<String> lockReason = new ArrayList<String>();
            if (this.unbuildableTypes.contains(unitType)) continue;
            if (unitType.getRequiredPopulation() > this.unitCount) {
                lockReason.add(Messages.message(StringTemplate.template("colonyPanel.populationTooSmall").addAmount("%number%", unitType.getRequiredPopulation())));
            }
            if (unitType.getLimits() != null) {
                for (Limit limit : unitType.getLimits()) {
                    if (limit.evaluate(this.colony)) continue;
                    lockReason.add(Messages.message(limit.getDescriptionKey()));
                }
            }
            if (!this.colony.hasAbility("model.ability.build", unitType, this.getGame().getTurn()) && !FeatureContainer.hasAbility(this.featureContainer, "model.ability.build", unitType, null)) {
                boolean builderFound = false;
                for (Ability ability : spec.getAbilities("model.ability.build")) {
                    if (!ability.appliesTo(unitType) || !ability.getValue() || ability.getSource() == null || this.unbuildableTypes.contains(ability.getSource())) continue;
                    builderFound = true;
                    lockReason.add(Messages.getName(ability.getSource()));
                    break;
                }
                if (!builderFound) {
                    this.unbuildableTypes.add(unitType);
                    continue;
                }
            }
            for (Map.Entry entry : unitType.getRequiredAbilities().entrySet()) {
                if (this.colony.hasAbility((String)entry.getKey()) == ((Boolean)entry.getValue()).booleanValue() || FeatureContainer.hasAbility(this.featureContainer, (String)entry.getKey(), null, null) == (Boolean)entry.getValue()) continue;
                List<FreeColGameObjectType> sources = spec.getTypesProviding((String)entry.getKey(), (Boolean)entry.getValue());
                if (sources.isEmpty()) {
                    this.unbuildableTypes.add(unitType);
                    continue block0;
                }
                lockReason.add(Messages.message(sources.get(0).getNameKey()));
            }
            if (lockReason.isEmpty()) {
                this.lockReasons.put(unitType, null);
            } else {
                this.lockReasons.put(unitType, Messages.message(StringTemplate.template("colonyPanel.requires").addName("%string%", Utils.join("/", lockReason))));
            }
            if (!lockReason.isEmpty() && !showAll.isSelected()) continue;
            units.addElement(unitType);
        }
    }

    private void updateBuildingList() {
        DefaultListModel buildings = (DefaultListModel)this.buildingList.getModel();
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        buildings.clear();
        block0: for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
            ArrayList<String> lockReason = new ArrayList<String>();
            Building colonyBuilding = this.colony.getBuilding(buildingType);
            if (current.contains(buildingType) || this.hasBuildingType(buildingType) || this.unbuildableTypes.contains(buildingType) || !buildingType.needsGoodsToBuild()) continue;
            if (this.unbuildableTypes.contains(buildingType.getUpgradesFrom())) {
                this.unbuildableTypes.add(buildingType);
                continue;
            }
            if (buildingType.getRequiredPopulation() > this.unitCount) {
                lockReason.add(Messages.message(StringTemplate.template("colonyPanel.populationTooSmall").addAmount("%number%", buildingType.getRequiredPopulation())));
            }
            for (Map.Entry<String, Boolean> entry : buildingType.getRequiredAbilities().entrySet()) {
                if (this.colony.hasAbility(entry.getKey()) == entry.getValue().booleanValue() || FeatureContainer.hasAbility(this.featureContainer, entry.getKey(), null, null) == entry.getValue()) continue;
                List<FreeColGameObjectType> sources = this.getSpecification().getTypesProviding(entry.getKey(), entry.getValue());
                if (sources.isEmpty()) {
                    this.unbuildableTypes.add(buildingType);
                    continue block0;
                }
                lockReason.add(Messages.message(sources.get(0).getNameKey()));
            }
            if (buildingType.getLimits() != null) {
                for (Limit limit : buildingType.getLimits()) {
                    if (limit.evaluate(this.colony)) continue;
                    lockReason.add(Messages.message(limit.getDescriptionKey()));
                }
            }
            if (!(buildingType.getUpgradesFrom() == null || current.contains(buildingType.getUpgradesFrom()) || colonyBuilding != null && colonyBuilding.getType() == buildingType.getUpgradesFrom())) {
                lockReason.add(Messages.message(buildingType.getUpgradesFrom().getNameKey()));
            }
            if (lockReason.isEmpty()) {
                this.lockReasons.put(buildingType, null);
            } else {
                this.lockReasons.put(buildingType, Messages.message(StringTemplate.template("colonyPanel.requires").addName("%string%", Utils.join("/", lockReason))));
            }
            if (!lockReason.isEmpty() && !showAll.isSelected()) continue;
            buildings.addElement(buildingType);
        }
    }

    private void updateAllLists() {
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        this.featureContainer = new FeatureContainer();
        for (Object type : current.toArray()) {
            if (this.getMinimumIndex((BuildableType)type) >= 0) {
                FeatureContainer.addFeatures(this.featureContainer, (BuildableType)type);
                continue;
            }
            current.removeElement(type);
        }
        this.updateBuildingList();
        this.updateUnitList();
        this.updateBuyBuildingButton();
        PropertyChangeEvent event = new PropertyChangeEvent(this.colony, ConstructionPanel.EVENT, null, this.getBuildableTypes(this.buildQueueList));
        this.constructionPanel.propertyChange(event);
    }

    private void updateBuyBuildingButton() {
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        if (current.getSize() == 0) {
            this.buyBuilding.setEnabled(false);
        } else {
            this.buyBuilding.setEnabled(this.colony.canPayToFinishBuilding((BuildableType)current.getElementAt(0)));
        }
    }

    private boolean hasBuildingType(BuildingType buildingType) {
        if (this.colony.getBuilding(buildingType) == null) {
            return false;
        }
        if (this.colony.getBuilding(buildingType).getType() == buildingType) {
            return true;
        }
        if (buildingType.getUpgradesTo() != null) {
            return this.hasBuildingType(buildingType.getUpgradesTo());
        }
        return false;
    }

    private List<BuildableType> getBuildableTypes(JList list) {
        ArrayList<BuildableType> result = new ArrayList<BuildableType>();
        if (list != null) {
            ListModel model = list.getModel();
            for (int index = 0; index < model.getSize(); ++index) {
                Object object = model.getElementAt(index);
                if (!(object instanceof BuildableType)) continue;
                result.add((BuildableType)object);
            }
        }
        return result;
    }

    private List<BuildableType> getBuildableTypes(Object[] objects) {
        ArrayList<BuildableType> result = new ArrayList<BuildableType>();
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof BuildableType)) continue;
                result.add((BuildableType)object);
            }
        }
        return result;
    }

    private int getMinimumIndex(BuildableType buildableType) {
        block6: {
            BuildingType buildingType;
            ListModel buildQueue;
            block5: {
                buildQueue = this.buildQueueList.getModel();
                if (!(buildableType instanceof UnitType)) break block5;
                if (this.colony.canBuild(buildableType)) {
                    return 0;
                }
                for (int index = 0; index < buildQueue.getSize(); ++index) {
                    if (!((BuildableType)buildQueue.getElementAt(index)).hasAbility("model.ability.build", buildableType)) continue;
                    return index + 1;
                }
                break block6;
            }
            if (!(buildableType instanceof BuildingType)) break block6;
            BuildingType upgradesFrom = ((BuildingType)buildableType).getUpgradesFrom();
            if (upgradesFrom == null) {
                return 0;
            }
            Building building = this.colony.getBuilding((BuildingType)buildableType);
            BuildingType buildingType2 = buildingType = building == null ? null : building.getType();
            if (buildingType == upgradesFrom) {
                return 0;
            }
            for (int index = 0; index < buildQueue.getSize(); ++index) {
                if (!upgradesFrom.equals(buildQueue.getElementAt(index))) continue;
                return index + 1;
            }
        }
        return -1;
    }

    private int getMaximumIndex(BuildableType buildableType) {
        ListModel buildQueue = this.buildQueueList.getModel();
        int buildQueueLastPos = buildQueue.getSize();
        boolean canBuild = false;
        if (this.colony.canBuild(buildableType)) {
            canBuild = true;
        }
        if (buildableType instanceof UnitType) {
            if (canBuild) {
                return buildQueueLastPos;
            }
            for (int index = 0; index < buildQueue.getSize(); ++index) {
                BuildableType toBuild = (BuildableType)buildQueue.getElementAt(index);
                if (toBuild == buildableType || !toBuild.hasAbility("model.ability.build", buildableType)) continue;
                return buildQueueLastPos;
            }
            return -1;
        }
        if (buildableType instanceof BuildingType) {
            BuildingType upgradesFrom = ((BuildingType)buildableType).getUpgradesFrom();
            BuildingType upgradesTo = ((BuildingType)buildableType).getUpgradesTo();
            if (!canBuild && upgradesFrom == null) {
                return -1;
            }
            if (canBuild && upgradesTo == null) {
                return buildQueueLastPos;
            }
            boolean foundUpgradesFrom = canBuild;
            for (int index = 0; index < buildQueue.getSize(); ++index) {
                BuildableType toBuild = (BuildableType)buildQueue.getElementAt(index);
                if (toBuild == buildableType) continue;
                if (!canBuild && !foundUpgradesFrom && upgradesFrom.equals(toBuild)) {
                    foundUpgradesFrom = true;
                    if (upgradesTo == null) {
                        return buildQueueLastPos;
                    }
                }
                if (foundUpgradesFrom && upgradesTo != null && upgradesTo.equals(toBuild)) {
                    return index;
                }
                if (!buildableType.hasAbility("model.ability.build", toBuild)) continue;
                return index;
            }
            return buildQueueLastPos;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String FAIL = "FAIL";
        if (this.colony.getOwner() == this.getMyPlayer()) {
            String command = event.getActionCommand();
            List<BuildableType> buildables = this.getBuildableTypes(this.buildQueueList);
            while (!buildables.isEmpty() && this.lockReasons.get(buildables.get(0)) != null) {
                this.getGUI().showInformationMessage((FreeColObject)buildables.get(0), StringTemplate.template("colonyPanel.unbuildable").addName("%colony%", this.colony.getName()).add("%object%", buildables.get(0).getNameKey()));
                command = "FAIL";
                this.removeBuildable(buildables.remove(0));
            }
            this.getController().setBuildQueue(this.colony, buildables);
            if ("FAIL".equals(command)) {
                this.updateAllLists();
                return;
            }
            if (!"OK".equals(command)) {
                if (BUY.equals(command)) {
                    this.getController().payForBuilding(this.colony);
                } else {
                    logger.warning("Unsupported command " + command);
                }
            }
        }
        this.getGUI().removeFromCanvas(this);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == compact) {
            this.updateDetailView();
        } else if (event.getSource() == showAll) {
            this.updateAllLists();
        }
    }

    private void updateDetailView() {
        this.cellRenderer = this.getCellRenderer();
        this.buildQueueList.setCellRenderer(this.cellRenderer);
        this.buildingList.setCellRenderer(this.cellRenderer);
        this.unitList.setCellRenderer(this.cellRenderer);
    }

    private ListCellRenderer getCellRenderer() {
        if (compact.isSelected()) {
            if (this.cellRenderer == null || this.cellRenderer instanceof DefaultBuildQueueCellRenderer) {
                return new SimpleBuildQueueCellRenderer();
            }
        } else if (this.cellRenderer == null || this.cellRenderer instanceof SimpleBuildQueueCellRenderer) {
            return new DefaultBuildQueueCellRenderer();
        }
        return this.cellRenderer;
    }

    class BuildQueueMouseAdapter
    extends MouseAdapter {
        private boolean add = true;
        private boolean enabled = false;

        public BuildQueueMouseAdapter(boolean add) {
            this.add = add;
        }

        public void mousePressed(MouseEvent e) {
            if (!this.enabled && e.getClickCount() == 1 && !e.isConsumed()) {
                this.enabled = true;
            }
            if (this.enabled) {
                JList source = (JList)e.getSource();
                if (e.getButton() == 3 || e.isPopupTrigger()) {
                    int index = source.locationToIndex(e.getPoint());
                    BuildableType type = (BuildableType)source.getModel().getElementAt(index);
                    BuildQueuePanel.this.getGUI().showColopediaPanel(type.getId());
                } else if (e.getClickCount() > 1 && !e.isConsumed()) {
                    DefaultListModel model = (DefaultListModel)BuildQueuePanel.this.buildQueueList.getModel();
                    if (source.getSelectedIndex() == -1) {
                        source.setSelectedIndex(source.locationToIndex(e.getPoint()));
                    }
                    for (Object type : source.getSelectedValues()) {
                        if (this.add) {
                            model.addElement(type);
                            continue;
                        }
                        model.removeElement(type);
                    }
                    BuildQueuePanel.this.updateAllLists();
                }
            }
        }
    }

    class DefaultBuildQueueCellRenderer
    implements ListCellRenderer {
        JPanel itemPanel = new JPanel();
        JPanel selectedPanel = new JPanel();
        JLabel imageLabel = new JLabel(new ImageIcon());
        JLabel nameLabel = new JLabel();
        private JLabel lockLabel = new JLabel(new ImageIcon(ResourceManager.getImage("lock.image", 0.5)));
        private Dimension buildingDimension = new Dimension(-1, 48);

        public DefaultBuildQueueCellRenderer() {
            this.itemPanel.setOpaque(false);
            this.itemPanel.setLayout((LayoutManager)new MigLayout());
            this.selectedPanel.setOpaque(false);
            this.selectedPanel.setLayout((LayoutManager)new MigLayout());
            this.selectedPanel.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.selectedPanel));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            BuildableType item = (BuildableType)value;
            JPanel panel = isSelected ? this.selectedPanel : this.itemPanel;
            panel.removeAll();
            ((ImageIcon)this.imageLabel.getIcon()).setImage(ResourceManager.getImage(item.getId() + ".image", this.buildingDimension));
            this.nameLabel.setText(Messages.message(item.getNameKey()));
            panel.setToolTipText((String)BuildQueuePanel.this.lockReasons.get(item));
            panel.add((Component)this.imageLabel, "span 1 2");
            if (BuildQueuePanel.this.lockReasons.get(item) == null) {
                panel.add((Component)this.nameLabel, "wrap");
            } else {
                panel.add((Component)this.nameLabel, "split 2");
                panel.add((Component)this.lockLabel, "wrap");
            }
            List<AbstractGoods> required = item.getRequiredGoods();
            int size = required.size();
            for (int i = 0; i < size; ++i) {
                AbstractGoods goods = required.get(i);
                ImageIcon icon = new ImageIcon(ResourceManager.getImage(goods.getType().getId() + ".image", 0.66));
                JLabel goodsLabel = new JLabel(Integer.toString(goods.getAmount()), icon, 0);
                if (i == 0 && size > 1) {
                    panel.add((Component)goodsLabel, "split " + size);
                    continue;
                }
                panel.add(goodsLabel);
            }
            return panel;
        }
    }

    class SimpleBuildQueueCellRenderer
    extends FreeColComboBoxRenderer {
        SimpleBuildQueueCellRenderer() {
        }

        public void setLabelValues(JLabel c, Object value) {
            c.setText(Messages.message(((BuildableType)value).getNameKey()));
        }
    }

    public class BuildQueueTransferHandler
    extends TransferHandler {
        private final DataFlavor buildQueueFlavor = new DataFlavor(List.class, "BuildingQueueFlavor");
        JList source = null;
        int[] indices = null;
        int numberOfItems = 0;

        public boolean importData(JComponent comp, Transferable data) {
            DefaultListModel targetModel;
            if (!this.canImport(comp, data.getTransferDataFlavors())) {
                return false;
            }
            JList target = null;
            ArrayList<BuildableType> buildQueue = new ArrayList<BuildableType>();
            try {
                target = (JList)comp;
                targetModel = (DefaultListModel)target.getModel();
                Object transferData = data.getTransferData(this.buildQueueFlavor);
                if (!(transferData instanceof List)) {
                    return false;
                }
                for (Object object : (List)transferData) {
                    if (!(object instanceof BuildableType)) {
                        return false;
                    }
                    if (object instanceof BuildingType && target == BuildQueuePanel.this.unitList || object instanceof UnitType && target == BuildQueuePanel.this.buildingList) {
                        return false;
                    }
                    buildQueue.add((BuildableType)object);
                }
            }
            catch (Exception e) {
                logger.warning(e.toString());
                return false;
            }
            for (BuildableType type : buildQueue) {
                if (BuildQueuePanel.this.getMinimumIndex(type) >= 0) continue;
                return false;
            }
            int preferredIndex = target.getSelectedIndex();
            boolean isOrderingQueue = false;
            int prevPos = -1;
            if (this.source.equals(target)) {
                if (target != BuildQueuePanel.this.buildQueueList && target.getParent() != BuildQueuePanel.this.buildQueueList) {
                    return false;
                }
                for (int i = 0; i < targetModel.getSize(); ++i) {
                    if (targetModel.getElementAt(i) != buildQueue.get(0)) continue;
                    prevPos = i;
                    break;
                }
                if (preferredIndex != -1 && prevPos == preferredIndex) {
                    this.indices = null;
                    return false;
                }
                int maximumIndex = BuildQueuePanel.this.getMaximumIndex((BuildableType)buildQueue.get(0));
                if (preferredIndex > maximumIndex) {
                    this.indices = null;
                    return false;
                }
                isOrderingQueue = true;
                this.numberOfItems = buildQueue.size();
            } else if (this.source == BuildQueuePanel.this.buildQueueList) {
                DefaultListModel sourceModel = (DefaultListModel)this.source.getModel();
                for (Object e : buildQueue) {
                    sourceModel.removeElement(e);
                }
                return true;
            }
            int maxIndex = targetModel.size();
            if (preferredIndex < 0 || preferredIndex > maxIndex) {
                preferredIndex = maxIndex;
            }
            if (isOrderingQueue) {
                for (Object e : buildQueue) {
                    targetModel.removeElement(e);
                }
            }
            for (int index = 0; index < buildQueue.size(); ++index) {
                int maximumIndex;
                BuildableType buildableType = (BuildableType)buildQueue.get(index);
                int minimumIndex = BuildQueuePanel.this.getMinimumIndex(buildableType);
                if (minimumIndex < targetModel.size() && minimumIndex != (maximumIndex = BuildQueuePanel.this.getMaximumIndex(buildableType))) {
                    if (minimumIndex < preferredIndex + index) {
                        minimumIndex = preferredIndex + index;
                    }
                    if (minimumIndex > targetModel.size()) {
                        minimumIndex = targetModel.size();
                    }
                    if (minimumIndex > maximumIndex) {
                        minimumIndex = maximumIndex;
                    }
                }
                targetModel.add(minimumIndex, buildQueue.get(index));
            }
            if (isOrderingQueue) {
                BuildQueuePanel.this.buildQueueList.setSelectedIndex(preferredIndex);
            }
            return true;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            this.indices = null;
            this.numberOfItems = 0;
            BuildQueuePanel.this.updateAllLists();
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            if (flavors == null) {
                return false;
            }
            for (DataFlavor flavor : flavors) {
                if (!flavor.equals(this.buildQueueFlavor)) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent comp) {
            if (comp instanceof JList) {
                this.source = (JList)comp;
                this.indices = this.source.getSelectedIndices();
                List buildQueue = BuildQueuePanel.this.getBuildableTypes(this.source.getSelectedValues());
                return new BuildQueueTransferable(buildQueue);
            }
            return null;
        }

        public int getSourceActions(JComponent comp) {
            if (comp == BuildQueuePanel.this.unitList) {
                return 1;
            }
            return 2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BuildQueueTransferable
        implements Transferable {
            private List<BuildableType> buildQueue;
            private final DataFlavor[] supportedFlavors;

            public BuildQueueTransferable(List<BuildableType> buildQueue) {
                this.supportedFlavors = new DataFlavor[]{BuildQueueTransferHandler.this.buildQueueFlavor};
                this.buildQueue = buildQueue;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return this.buildQueue;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            public List<BuildableType> getBuildQueue() {
                return this.buildQueue;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.supportedFlavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                for (DataFlavor myFlavor : this.supportedFlavors) {
                    if (!myFlavor.equals(flavor)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

