/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

public final class OptionGroupUI
extends JPanel
implements OptionUpdater,
TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(OptionGroupUI.class.getName());
    private final List<OptionUpdater> optionUpdaters = new ArrayList<OptionUpdater>();
    private final HashMap<String, OptionUI> optionUIs = new HashMap();
    private JPanel detailPanel;
    private JTree tree;
    private GUI gui;
    private OptionGroup group;
    private boolean editable;

    public OptionGroupUI(GUI gui, OptionGroup group, boolean editable) {
        this.gui = gui;
        this.group = group;
        this.editable = editable;
        this.setLayout((LayoutManager)new MigLayout("fill", "[200:]unrelated[550:, grow, fill]", "[top]"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(group);
        this.buildTree(group, root);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel){

            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Option option = (Option)node.getUserObject();
                return Messages.message(option.getId() + ".name");
            }
        };
        this.tree.setOpaque(false);
        this.tree.addTreeSelectionListener(this);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
        renderer.setBackgroundNonSelectionColor(new Color(0, 0, 0, 1));
        this.add(this.tree);
        this.detailPanel = new JPanel((LayoutManager)new MigLayout("wrap 2", "[fill]related[fill]"));
        this.detailPanel.setOpaque(false);
        this.add((Component)this.detailPanel, "grow");
    }

    public JTree getTree() {
        return this.tree;
    }

    private void buildTree(OptionGroup group, DefaultMutableTreeNode parent) {
        for (Option option : group.getOptions()) {
            if (!(option instanceof OptionGroup)) continue;
            DefaultMutableTreeNode branch = new DefaultMutableTreeNode(option);
            parent.add(branch);
            this.buildTree((OptionGroup)option, branch);
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        this.detailPanel.removeAll();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            if (node.isLeaf()) {
                OptionGroup group = (OptionGroup)node.getUserObject();
                for (Option option : group.getOptions()) {
                    this.addOptionUI(option, this.editable && group.isEditable());
                }
            } else {
                this.tree.expandPath(event.getPath());
            }
        }
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    public void updateOption() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.updateOption();
        }
    }

    public OptionUI getOptionUI(String key) {
        return this.optionUIs.get(key);
    }

    private void addOptionUI(Option option, boolean editable) {
        OptionUI ui = OptionUI.getOptionUI(this.gui, option, editable);
        if (ui == null) {
            logger.warning("Unknown option type: " + option.toString());
        } else if (ui instanceof FreeColActionUI) {
            ((FreeColActionUI)ui).setOptionGroupUI(this);
        }
        JLabel label = ui.getLabel();
        if (label == null) {
            this.detailPanel.add((Component)ui.getComponent(), "newline, span");
        } else {
            this.detailPanel.add(label);
            this.detailPanel.add(ui.getComponent());
        }
        if (this.group.isEditable()) {
            this.optionUpdaters.add(ui);
        }
        if (!option.getId().equals("NO_ID")) {
            this.optionUIs.put(option.getId(), ui);
        }
    }

    public void removeKeyStroke(KeyStroke keyStroke) {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            if (!(optionUpdater instanceof FreeColActionUI)) continue;
            ((FreeColActionUI)optionUpdater).removeKeyStroke(keyStroke);
        }
    }

    public void reset() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.reset();
        }
    }

    public String getUIClassID() {
        return "ReportPanelUI";
    }
}

