/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.i18n;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.i18n.DefaultNumberRule;
import net.sf.freecol.client.gui.i18n.DualNumberRule;
import net.sf.freecol.client.gui.i18n.Number;
import net.sf.freecol.client.gui.i18n.OtherNumberRule;
import net.sf.freecol.client.gui.i18n.PluralNumberRule;
import net.sf.freecol.client.gui.i18n.Rule;
import net.sf.freecol.client.gui.i18n.ZeroOneNumberRule;

public class NumberRules {
    private static final Logger logger = Logger.getLogger(NumberRules.class.getName());
    public static final Number OTHER_NUMBER_RULE = new OtherNumberRule();
    public static final Number DUAL_NUMBER_RULE = new DualNumberRule();
    public static final Number PLURAL_NUMBER_RULE = new PluralNumberRule();
    public static final Number ZERO_ONE_NUMBER_RULE = new ZeroOneNumberRule();
    private static Map<String, Number> numberMap = new HashMap<String, Number>();

    public NumberRules(InputStream in) {
        NumberRules.load(in);
    }

    public static Number getNumberForLanguage(String lang) {
        Number number = numberMap.get(lang);
        return number == null ? OTHER_NUMBER_RULE : number;
    }

    public static boolean isInitialized() {
        return !numberMap.isEmpty();
    }

    public static void load(InputStream in) {
        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            NumberRules.readFromXML(xsr);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Load parse", e);
            throw new RuntimeException("Error parsing number rules.");
        }
    }

    private static void readFromXML(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String tag = in.getLocalName();
            if ("version".equals(tag)) {
                in.nextTag();
                continue;
            }
            if ("generation".equals(tag)) {
                in.nextTag();
                continue;
            }
            if (!"plurals".equals(tag)) continue;
            while (in.nextTag() != 2) {
                tag = in.getLocalName();
                if (!"pluralRules".equals(tag)) continue;
                NumberRules.readChild(in);
            }
        }
    }

    private static void readChild(XMLStreamReader in) throws XMLStreamException {
        String[] locales = in.getAttributeValue(null, "locales").split(" ");
        if (locales != null) {
            Rule rule;
            DefaultNumberRule numberRule = new DefaultNumberRule();
            while (in.nextTag() != 2) {
                if (!"pluralRule".equals(in.getLocalName())) continue;
                Number.Category category = Number.Category.valueOf(in.getAttributeValue(null, "count"));
                rule = new Rule(in.getElementText());
                numberRule.addRule(category, rule);
            }
            Number number = null;
            switch (numberRule.countRules()) {
                case 0: {
                    number = OTHER_NUMBER_RULE;
                    break;
                }
                case 1: {
                    rule = numberRule.getRule(Number.Category.one);
                    if (rule == null) break;
                    if ("n is 1".equals(rule.toString())) {
                        number = PLURAL_NUMBER_RULE;
                        break;
                    }
                    if (!"n in 0..1".equals(rule.toString())) break;
                    number = ZERO_ONE_NUMBER_RULE;
                    break;
                }
                case 2: {
                    Rule oneRule = numberRule.getRule(Number.Category.one);
                    Rule twoRule = numberRule.getRule(Number.Category.two);
                    if (oneRule == null || !"n is 1".equals(oneRule.toString()) || twoRule == null || !"n is 2".equals(twoRule.toString())) break;
                    number = DUAL_NUMBER_RULE;
                    break;
                }
                default: {
                    number = numberRule;
                }
            }
            for (String locale : locales) {
                numberMap.put(locale, number);
            }
        }
    }
}

