/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class FrameMotionListener
extends MouseAdapter
implements MouseMotionListener {
    public static final String COPYRIGHT = "Copyright (C) 2003-2012 The FreeCol Team";
    public static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    public static final String REVISION = "$Revision: 9687 $";
    private JInternalFrame f;
    private Point loc = null;

    FrameMotionListener(JInternalFrame f) {
        this.f = f;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        int moveX = this.loc.x - p.x;
        int moveY = this.loc.y - p.y;
        this.f.getDesktopPane().getDesktopManager().dragFrame(this.f, this.f.getX() - moveX, this.f.getY() - moveY);
        this.loc = p;
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
            return;
        }
        this.loc = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        this.f.getDesktopPane().getDesktopManager().beginDraggingFrame(this.f);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
            return;
        }
        this.f.getDesktopPane().getDesktopManager().endDraggingFrame(this.f);
    }
}

