/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class CanvasMouseListener
implements ActionListener,
MouseListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseListener.class.getName());
    private final Canvas canvas;
    private final MapViewer mapViewer;
    private final int doubleClickDelay = 200;
    private Timer doubleClickTimer = new Timer(200, this);
    private int centerX;
    private int centerY;
    private FreeColClient freeColClient;

    public CanvasMouseListener(FreeColClient freeColClient, Canvas canvas, MapViewer mapViewer) {
        this.freeColClient = freeColClient;
        this.canvas = canvas;
        this.mapViewer = mapViewer;
    }

    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getClickCount() > 1) {
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
                    if (tile.getSettlement() != null) {
                        this.canvas.debugForeignColony(tile.getSettlement());
                    }
                } else {
                    this.canvas.showColonyPanel(tile);
                }
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        try {
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                if (this.mapViewer.isGotoStarted()) {
                    this.mapViewer.stopGoto();
                }
                this.canvas.showTilePopup(this.mapViewer.convertToMapTile(e.getX(), e.getY()), e.getX(), e.getY());
            } else if (e.getButton() == 2) {
                Unit unit;
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                if (tile != null && (unit = this.mapViewer.getActiveUnit()) != null && unit.getTile() != tile) {
                    PathNode dragPath = unit.findPath(tile);
                    this.mapViewer.startGoto();
                    this.mapViewer.setGotoPath(dragPath);
                }
            } else if (e.getButton() == 1) {
                if (this.mapViewer.isGotoStarted()) {
                    PathNode path = this.mapViewer.getGotoPath();
                    if (path != null) {
                        this.mapViewer.stopGoto();
                        this.freeColClient.getInGameController().goToTile(this.mapViewer.getActiveUnit(), path.getLastNode().getTile());
                    }
                } else if (this.doubleClickTimer.isRunning()) {
                    this.doubleClickTimer.stop();
                } else {
                    this.centerX = e.getX();
                    this.centerY = e.getY();
                    this.doubleClickTimer.start();
                }
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if (this.mapViewer.getGotoPath() != null) {
                PathNode temp = this.mapViewer.getGotoPath();
                this.mapViewer.stopGoto();
                this.freeColClient.getInGameController().goToTile(this.mapViewer.getActiveUnit(), temp.getLastNode().getTile());
            } else if (this.mapViewer.isGotoStarted()) {
                this.mapViewer.stopGoto();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseReleased!", ex);
        }
    }

    public void actionPerformed(ActionEvent timerEvent) {
        this.doubleClickTimer.stop();
        this.mapViewer.setSelectedTile(this.mapViewer.convertToMapTile(this.centerX, this.centerY), true);
    }
}

