/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.ScrollThread;
import net.sf.freecol.common.model.Map;

public class AbstractCanvasListener {
    protected final MapViewer mapViewer;
    protected ScrollThread scrollThread;
    protected FreeColClient freeColClient;
    private static final int DRAG_SCROLLSPACE = 100;
    protected static final int AUTO_SCROLLSPACE = 1;

    public AbstractCanvasListener(FreeColClient freeColClient, MapViewer mapViewer) {
        this.freeColClient = freeColClient;
        this.mapViewer = mapViewer;
        this.scrollThread = null;
    }

    protected void autoScroll(int x, int y) {
        this.scroll(x, y, 1);
    }

    protected void dragScroll(int x, int y) {
        this.scroll(x, y, 100);
    }

    protected void performAutoScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.autoScroll")) {
            this.autoScroll(e.getX(), e.getY());
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void performDragScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.dragScroll(e.getX(), e.getY());
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void stopScrollIfScrollIsActive() {
        if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
    }

    private void scroll(int x, int y, int scrollspace) {
        Map.Direction direction;
        if (x < scrollspace && y < scrollspace) {
            direction = Map.Direction.NW;
        } else if (x >= this.mapViewer.getWidth() - scrollspace && y < scrollspace) {
            direction = Map.Direction.NE;
        } else if (x >= this.mapViewer.getWidth() - scrollspace && y >= this.mapViewer.getHeight() - scrollspace) {
            direction = Map.Direction.SE;
        } else if (x < scrollspace && y >= this.mapViewer.getHeight() - scrollspace) {
            direction = Map.Direction.SW;
        } else if (y < scrollspace) {
            direction = Map.Direction.N;
        } else if (x >= this.mapViewer.getWidth() - scrollspace) {
            direction = Map.Direction.E;
        } else if (y >= this.mapViewer.getHeight() - scrollspace) {
            direction = Map.Direction.S;
        } else if (x < scrollspace) {
            direction = Map.Direction.W;
        } else {
            this.stopScrollIfScrollIsActive();
            return;
        }
        if (this.scrollThread != null) {
            this.scrollThread.setDirection(direction);
        } else {
            this.scrollThread = new ScrollThread(this.mapViewer);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        }
    }
}

