/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImage;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.DiffProject;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class PreviewPatchLabelDecorator
implements ILabelDecorator {
    private Map fImages = new Hashtable(10);
    private List fDisposeOnShutdownImages = new ArrayList();
    ImageDescriptor errId = CompareUIPlugin.getImageDescriptor("ovr16/error_ov.gif");
    static final String error = "error";
    static final String add = "add";
    static final String delete = "del";

    public Image decorateImage(Image image, Object element) {
        if (element instanceof Diff) {
            Diff diff = (Diff)element;
            switch (diff.getType()) {
                case 1: {
                    return this.getImageFor(add + (diff.fMatches ? "" : error), image, diff.fMatches);
                }
                case 2: {
                    return this.getImageFor(delete + (diff.fMatches ? "" : error), image, diff.fMatches);
                }
            }
            return this.getImageFor(diff.fMatches ? "" : error, image, diff.fMatches);
        }
        if (element instanceof Hunk) {
            Hunk hunk = (Hunk)element;
            return this.getImageFor(hunk.fMatches ? "" : error, image, hunk.fMatches);
        }
        return null;
    }

    private Image getImageFor(String id, Image image, boolean hasMatches) {
        Image cached_image = (Image)this.fImages.get(id);
        if (cached_image == null) {
            DiffImage diffImage = new DiffImage(image, hasMatches ? null : this.errId, 16, false);
            cached_image = diffImage.createImage();
            this.fImages.put(id, cached_image);
            this.fDisposeOnShutdownImages.add(cached_image);
        }
        return cached_image;
    }

    public String decorateText(String text, Object element) {
        if (element instanceof DiffProject) {
            DiffProject project = (DiffProject)element;
            IResource projectExistsInWorkspace = ResourcesPlugin.getWorkspace().getRoot().findMember(project.getProject().getFullPath());
            if (projectExistsInWorkspace == null) {
                return NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, PatchMessages.PreviewPatchLabelDecorator_ProjectDoesNotExist});
            }
            if (!project.getName().equals(project.getOriginalProjectName())) {
                return NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{project.getOriginalProjectName(), NLS.bind((String)PatchMessages.PreviewPatchPage_Target, (Object[])new String[]{project.getName()})});
            }
        }
        return null;
    }

    public void dispose() {
        if (this.fDisposeOnShutdownImages != null) {
            for (Image img : this.fDisposeOnShutdownImages) {
                if (img.isDisposed()) continue;
                img.dispose();
            }
            this.fImages = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

