/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.AdaptableResourceList;
import org.tigris.subversion.subclipse.ui.dialogs.CompareDialog;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusLabelProvider;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusSorter;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusUtil;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.TableSetter;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CommitDialog
extends TrayDialog {
    private static final int WIDTH_HINT = 500;
    private static final int SELECTION_HEIGHT_HINT = 100;
    private SashForm sashForm;
    private CommitCommentArea commitCommentArea;
    private IResource[] resourcesToCommit;
    private String url;
    private ProjectProperties projectProperties;
    private Object[] selectedResources;
    private CheckboxTableViewer listViewer;
    private Text issueText;
    private String issue;
    private Button keepLocksButton;
    private boolean keepLocks;
    private IDialogSettings settings;
    private TableSetter setter;
    private int sorterColumn = 1;
    private boolean sorterReversed = false;
    private Button okButton;
    private CommentProperties commentProperties;
    private boolean sharing;
    protected static final int LABEL_WIDTH_HINT = 400;

    public CommitDialog(Shell parentShell, IResource[] resourcesToCommit, String url, boolean unaddedResources, ProjectProperties projectProperties) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        if (resourcesToCommit.length > 0) {
            try {
                this.commentProperties = CommentProperties.getCommentProperties(resourcesToCommit[0]);
            }
            catch (SVNException sVNException) {}
        }
        this.commitCommentArea = new CommitCommentArea((Dialog)this, null, this.commentProperties);
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CommitDialog.this.okButton.setEnabled(CommitDialog.this.commitCommentArea.getComment().length() >= CommitDialog.this.commentProperties.getMinimumLogMessageSize());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.resourcesToCommit = resourcesToCommit;
        this.url = url;
        this.projectProperties = projectProperties;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        this.setter = new TableSetter();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.url == null) {
            this.getShell().setText(String.valueOf(Policy.bind("CommitDialog.commitTo")) + " " + Policy.bind("CommitDialog.multiple"));
        } else {
            this.getShell().setText(String.valueOf(Policy.bind("CommitDialog.commitTo")) + " " + this.url);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(composite, 512);
        this.sashForm.setLayout((Layout)new GridLayout());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite cTop = new Composite((Composite)this.sashForm, 0);
        cTop.setLayout((Layout)new GridLayout());
        cTop.setLayoutData((Object)new GridData(1808));
        Composite cBottom1 = new Composite((Composite)this.sashForm, 0);
        cBottom1.setLayout((Layout)new GridLayout());
        cBottom1.setLayoutData((Object)new GridData(1808));
        Composite cBottom2 = new Composite(cBottom1, 0);
        cBottom2.setLayout((Layout)new GridLayout());
        cBottom2.setLayoutData((Object)new GridData(1808));
        try {
            int[] weights = new int[]{this.settings.getInt("CommitDialog.weights.0"), this.settings.getInt("CommitDialog.weights.1")};
            this.sashForm.setWeights(weights);
        }
        catch (Exception exception) {
            this.sashForm.setWeights(new int[]{5, 4});
        }
        if (this.projectProperties != null) {
            this.addBugtrackingArea(cTop);
        }
        this.commitCommentArea.createArea(cTop);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    CommitDialog.this.okPressed();
                }
            }
        });
        this.addResourcesArea(cBottom2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.commit_dialog_context");
        return composite;
    }

    private void addResourcesArea(Composite composite) {
        Label label = this.createWrappingLabel(composite);
        label.setText(Policy.bind("CommitDialog.resources"));
        Table table = new Table(composite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.listViewer = new CheckboxTableViewer(table);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 500;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.createColumns(table, layout);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ResourceWithStatusLabelProvider(this.url));
        int sort = this.setter.getSorterColumn("CommitDialog");
        if (sort != -1) {
            this.sorterColumn = sort;
        }
        ResourceWithStatusSorter sorter = new ResourceWithStatusSorter(this.sorterColumn);
        sorter.setReversed(this.setter.getSorterReversed("CommitDialog"));
        this.listViewer.setSorter((ViewerSorter)sorter);
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CommitDialog.this.resourcesToCommit;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.setInput((Object)new AdaptableResourceList(this.resourcesToCommit));
        if (this.selectedResources == null) {
            this.setChecks();
        } else {
            this.listViewer.setCheckedElements(this.selectedResources);
        }
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitDialog.this.selectedResources = CommitDialog.this.listViewer.getCheckedElements();
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object sel0 = sel.getFirstElement();
                if (sel0 instanceof IFile) {
                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                    try {
                        new CompareDialog(CommitDialog.this.getShell(), new SVNLocalCompareInput(localResource, SVNRevision.BASE, true)).open();
                    }
                    catch (SVNException sVNException) {}
                }
            }
        });
        this.addSelectionButtons(composite);
    }

    private void addBugtrackingArea(Composite composite) {
        Composite bugtrackingComposite = new Composite(composite, 0);
        GridLayout bugtrackingLayout = new GridLayout();
        bugtrackingLayout.numColumns = 2;
        bugtrackingComposite.setLayout((Layout)bugtrackingLayout);
        Label label = new Label(bugtrackingComposite, 0);
        label.setText(this.projectProperties.getLabel());
        this.issueText = new Text(bugtrackingComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.issueText.setLayoutData((Object)data);
    }

    protected void okPressed() {
        this.saveLocation();
        if (this.projectProperties != null) {
            String issueError;
            this.issue = this.issueText.getText().trim();
            if (this.projectProperties.isWarnIfNoIssue() && this.issueText.getText().trim().length() == 0 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.0", this.projectProperties.getLabel()))) {
                this.issueText.setFocus();
                return;
            }
            if (this.issueText.getText().trim().length() > 0 && (issueError = this.projectProperties.validateIssue(this.issueText.getText().trim())) != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)issueError);
                this.issueText.selectAll();
                this.issueText.setFocus();
                return;
            }
        }
        this.keepLocks = this.keepLocksButton.getSelection();
        if (!this.checkForUnselectedPropChangeChildren()) {
            return;
        }
        super.okPressed();
    }

    private boolean checkForUnselectedPropChangeChildren() {
        if (this.selectedResources == null) {
            return true;
        }
        ArrayList<IResource> folderPropertyChanges = new ArrayList<IResource>();
        boolean folderDeletionSelected = false;
        int i = 0;
        while (i < this.selectedResources.length) {
            IResource resource = (IResource)this.selectedResources[i];
            if (resource instanceof IContainer) {
                String propertyStatus;
                if (ResourceWithStatusUtil.getStatus(resource).equals(Policy.bind("CommitDialog.deleted"))) {
                    folderDeletionSelected = true;
                }
                if ((propertyStatus = ResourceWithStatusUtil.getPropertyStatus(resource)) != null && propertyStatus.length() > 0) {
                    folderPropertyChanges.add(resource);
                }
            }
            ++i;
        }
        boolean unselectedPropChangeChildren = false;
        if (folderDeletionSelected) {
            Iterator iter = folderPropertyChanges.iterator();
            block1: while (iter.hasNext()) {
                IContainer container = (IContainer)iter.next();
                TableItem[] items = this.listViewer.getTable().getItems();
                int i2 = 0;
                while (i2 < items.length) {
                    IResource resource;
                    if (!items[i2].getChecked() && this.isChild(resource = (IResource)items[i2].getData(), container)) {
                        unselectedPropChangeChildren = true;
                        break block1;
                    }
                    ++i2;
                }
            }
        }
        if (unselectedPropChangeChildren) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.unselectedPropChangeChildren"));
            return false;
        }
        return true;
    }

    private boolean isChild(IResource resource, IContainer folder) {
        IContainer container = resource.getParent();
        while (container != null) {
            if (container.getFullPath().toString().equals(folder.getFullPath().toString())) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("CommitDialog.location.x", x);
        this.settings.put("CommitDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("CommitDialog.size.x", x);
        this.settings.put("CommitDialog.size.y", y);
        TableSetter setter = new TableSetter();
        setter.saveColumnWidths(this.listViewer.getTable(), "CommitDialog");
        setter.saveSorterColumn("CommitDialog", this.sorterColumn);
        setter.saveSorterReversed("CommitDialog", this.sorterReversed);
        int[] weights = this.sashForm.getWeights();
        int i = 0;
        while (i < weights.length) {
            this.settings.put("CommitDialog.weights." + i, weights[i]);
            ++i;
        }
    }

    private void createColumns(Table table, TableLayout layout) {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = CommitDialog.this.listViewer.getTable().indexOf((TableColumn)e.widget);
                ResourceWithStatusSorter oldSorter = (ResourceWithStatusSorter)CommitDialog.this.listViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    CommitDialog.this.sorterReversed = oldSorter.isReversed();
                    CommitDialog.this.listViewer.refresh();
                } else {
                    CommitDialog.this.listViewer.setSorter((ViewerSorter)new ResourceWithStatusSorter(column));
                    CommitDialog.this.sorterColumn = column;
                }
            }
        };
        int[] widths = this.setter.getColumnWidths("CommitDialog", 4);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        col.addSelectionListener((SelectionListener)headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("PendingOperationsView.resource"));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[1], true));
        col.addSelectionListener((SelectionListener)headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("CommitDialog.status"));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[2], true));
        col.addSelectionListener((SelectionListener)headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("CommitDialog.property"));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[3], true));
        col.addSelectionListener((SelectionListener)headerListener);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, Policy.bind("ReleaseCommentDialog.selectAll"), false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.listViewer.setAllChecked(true);
                CommitDialog.this.selectedResources = null;
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Policy.bind("ReleaseCommentDialog.deselectAll"), false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.listViewer.setAllChecked(false);
                CommitDialog.this.selectedResources = new Object[0];
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        this.keepLocksButton = new Button(buttonComposite, 32);
        this.keepLocksButton.setText(Policy.bind("CommitDialog.keepLocks"));
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("CommitDialog.location.x");
            int y = this.settings.getInt("CommitDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("CommitDialog.size.x");
            int y = this.settings.getInt("CommitDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    public String getComment() {
        if (this.projectProperties != null && this.issue != null && this.issue.length() > 0) {
            if (this.projectProperties.isAppend()) {
                return String.valueOf(this.commitCommentArea.getComment()) + "\n" + this.projectProperties.getResolvedMessage(this.issue) + "\n";
            }
            return String.valueOf(this.projectProperties.getResolvedMessage(this.issue)) + "\n" + this.commitCommentArea.getComment();
        }
        return this.commitCommentArea.getComment();
    }

    public IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return this.resourcesToCommit;
        }
        List<Object> result = Arrays.asList(this.selectedResources);
        return result.toArray(new IResource[result.size()]);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
                this.okButton.setEnabled(false);
            }
        }
        return button;
    }

    protected Label createWrappingLabel(Composite parent) {
        Label label = new Label(parent, 16448);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    private void setChecks() {
        this.listViewer.setAllChecked(true);
        this.deselect();
        this.selectedResources = this.listViewer.getCheckedElements();
    }

    private void deselect() {
        boolean selectUnadded = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_select_unadded_resources_on_commit");
        TableItem[] items = this.listViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            IResource resource = (IResource)items[i].getData();
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            try {
                if (!(this.sharing || selectUnadded || svnResource.isManaged())) {
                    items[i].setChecked(false);
                } else if (svnResource.getStatus().isMissing()) {
                    items[i].setChecked(false);
                }
            }
            catch (SVNException sVNException) {}
            ++i;
        }
    }

    public boolean isKeepLocks() {
        return this.keepLocks;
    }

    public void setComment(String proposedComment) {
        this.commitCommentArea.setProposedComment(proposedComment);
    }

    public void setSharing(boolean sharing) {
        this.sharing = sharing;
    }
}

